package attitude;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.attitudes.GPAttitudeLawSelector;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPAttitudeLawSelector.
 * @author goesterjf
 *
 */
public class TestGPAttitudeLaw extends GPanel implements GReadWrite{

    private GPAttitudeLawSelector attitude;
    
    public TestGPAttitudeLaw() throws IllegalArgumentException {
        
        attitude = new GPAttitudeLawSelector("My attitude law");

    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(attitude);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws PatriusException 
     * @throws IOException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPAttitudeLawSelector.xml");
        final File locFile = new File("GPAttitudeLawSelector.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPAttitudeLaw test = new TestGPAttitudeLaw();

        GPanTest frame = new GPanTest("Attitude law", test, "GPAttitudeLawSelector.xml");
        frame.display();

    }

}
