package attitude;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.attitudes.GPAttitudeSequence;
import fr.cnes.genopus.exception.GPAttitudeException;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.attitudes.AttitudeLaw;
import fr.cnes.sirius.patrius.attitudes.LofOffset;
import fr.cnes.sirius.patrius.attitudes.SunPointing;
import fr.cnes.sirius.patrius.frames.LOFType;
import fr.cnes.sirius.patrius.math.geometry.euclidean.threed.Vector3D;
import fr.cnes.sirius.patrius.time.AbsoluteDate;
import fr.cnes.sirius.patrius.time.TimeScalesFactory;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPAttitudeSequence.
 * @author goesterjf
 *
 */
public class TestGPSeqAtt extends GPanel implements GReadWrite {

    private GPAttitudeSequence attSeq;
    
    public TestGPSeqAtt() throws IllegalArgumentException, PatriusException, GPAttitudeException {
        
        AbsoluteDate date0 = new AbsoluteDate(2010, 1, 1, TimeScalesFactory.getUTC());
        //attSeq = new GPAttitudeSequence(date0, false, true);
        final AttitudeLaw[] laws = { new LofOffset(LOFType.LVLH), new SunPointing(new Vector3D(1., 0., 0.), new Vector3D(0., 1., 0.)) };
        final String[] lawNames = { "LVLH", "SP" };
        attSeq = new GPAttitudeSequence(date0, false, true, laws, lawNames, 0);
        attSeq.getGComboBoxSimpleLaw().getGComboBox().setValue(2);

    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(attSeq);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws GPAttitudeException 
     * @throws IllegalArgumentException 
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IllegalArgumentException, GPAttitudeException, IOException {

        final File refFile = new File("src/test/resources/AttitudeSequence.xml");
        final File locFile = new File("AttitudeSequence.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;

        GPanTest frame = new GPanTest("Sequence of attitude", new TestGPSeqAtt(), "AttitudeSequence.xml");
        frame.display();

    }

}
