package events;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.events.GPEventSelector;
import fr.cnes.genopus.events.GPEventSelector.GPEventsEnum;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.events.EventDetector.Action;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Testing GPEventSelector.
 * @author goesterjf
 *
 */
public class TestGPEventSelector extends GPanel implements GReadWrite {

    private GPEventSelector eventSelector;
    
    public TestGPEventSelector() {
        
        final Action[] actionsToShow = { Action.RESET_STATE, Action.STOP};
        eventSelector = new GPEventSelector("Events:", actionsToShow, GPEventsEnum.APSIDE, GPEventsEnum.NODE);
        
    }

    public void generic() throws GException {
        put(eventSelector);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPEventSelector.xml");
        final File locFile = new File("GPEventSelector.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        GPanTest panTest = new GPanTest("Events", new TestGPEventSelector(), "GPEventSelector.xml");
        // GFrame panTest = new GFrame("Events", new TestGPEvent());
        panTest.display();

    }

}
