package maneuver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.maneuvers.GPConstantManeuver;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.assembly.properties.PropulsiveProperty;
import fr.cnes.sirius.patrius.assembly.properties.TankProperty;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPConstantManeuver.
 * @author goesterjf
 *
 */
public class TestGPConstantManeuver extends GPanel implements GReadWrite {

    private GPConstantManeuver constMan;
    
    public TestGPConstantManeuver() throws IllegalArgumentException, PatriusException {
        
        constMan = new GPConstantManeuver("My Maneuver");
        
        ArrayList<PropulsiveProperty> listOfEngines = new ArrayList<PropulsiveProperty>();
        PropulsiveProperty prop = new PropulsiveProperty(320., 490.);
        prop.setPartName("OCS");
        listOfEngines.add(prop);
        constMan.setEnginesList(listOfEngines);
        
        ArrayList<TankProperty> listOfTanks = new ArrayList<TankProperty>();
        TankProperty tank = new TankProperty(100.);
        tank.setPartName("TANK");
        listOfTanks.add(tank);
        constMan.setTanksList(listOfTanks);
        
    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(constMan);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPConstantManeuver.xml");
        final File locFile = new File("GPConstantManeuver.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;

        TestGPConstantManeuver test = new TestGPConstantManeuver();
        GPanTest frame = new GPanTest("Constant maneuver", test, "GPConstantManeuver.xml");
        frame.display();

    }

}
