package maneuver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.maneuvers.GPImpulseManeuver;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.assembly.properties.PropulsiveProperty;
import fr.cnes.sirius.patrius.assembly.properties.TankProperty;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPImpulseManeuver.
 * @author goesterjf
 *
 */
public class TestGPImpulseManeuver extends GPanel implements GReadWrite {

    private GPImpulseManeuver impMan;
    
    public TestGPImpulseManeuver() throws IllegalArgumentException, PatriusException {
        
        impMan = new GPImpulseManeuver("My Maneuver");
        ArrayList<PropulsiveProperty> listOfEngines = new ArrayList<PropulsiveProperty>();
        PropulsiveProperty prop = new PropulsiveProperty(320., 490.);
        prop.setPartName("OCS");
        listOfEngines.add(prop);
        impMan.setEnginesList(listOfEngines);
        
        ArrayList<TankProperty> listOfTanks = new ArrayList<TankProperty>();
        TankProperty tank = new TankProperty(100.);
        tank.setPartName("TANK");
        listOfTanks.add(tank);
        impMan.setTanksList(listOfTanks);

    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(impMan);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

   /**
     * @param args
 * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPImpulseManeuver.xml");
        final File locFile = new File("GPImpulseManeuver.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;

        TestGPImpulseManeuver test = new TestGPImpulseManeuver();
        
        GPanTest frame = new GPanTest("Impulse maneuver", test, "GPImpulseManeuver.xml");
        frame.display();

    }

}
