package maneuver;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.maneuvers.GPManeuverSequence;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.time.AbsoluteDate;
import fr.cnes.sirius.patrius.time.TimeScalesFactory;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPManeuverSequence.
 * @author goesterjf
 *
 */
public class TestGPSeqMan extends GPanel implements GReadWrite {

    private final GPManeuverSequence manSeq;
    
    public TestGPSeqMan() throws IllegalArgumentException, PatriusException {
        
        AbsoluteDate date0 = new AbsoluteDate(2010, 1, 1, TimeScalesFactory.getUTC());
        manSeq = new GPManeuverSequence(date0, true, false);
        
    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(manSeq);
    }
    
    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPManeuverSequence.xml");
        final File locFile = new File("GPManeuverSequence.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;
        
        TestGPSeqMan test = new TestGPSeqMan();

        //GFrame frame = new GFrame("Maneuver sequence", test);
        GPanTest frame = new GPanTest("Sequence of maneuver", test, "GPManeuverSequence.xml");
        frame.display();

    }

}
