package misc;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.time.GPAbsoluteDate;
import fr.cnes.genopus.time.GPAbsoluteDate.GPDateTimeScale;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.time.AbsoluteDate;
import fr.cnes.sirius.patrius.time.TimeScale;
import fr.cnes.sirius.patrius.time.TimeScalesFactory;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPAbsoluteDate.
 * @author goesterjf
 *
 */
public class TestGPAbsoluteDate extends GPanel implements GReadWrite {

    private GPAbsoluteDate gpDate;
    
    public TestGPAbsoluteDate() throws PatriusException {
        
        final TimeScale TUC = TimeScalesFactory.getUTC();
        final AbsoluteDate date0 = new AbsoluteDate(2010, 1, 1, 0, 0, 0., TUC);
        final GPDateTimeScale[] ts = new GPDateTimeScale[4];
        ts[0] = GPDateTimeScale.UTC;
        ts[1] = GPDateTimeScale.GST;
        ts[2] = GPDateTimeScale.TCG;
        ts[3] = GPDateTimeScale.GMST;
        gpDate = new GPAbsoluteDate("Date:", date0, ts);

    }

    public void generic() throws GException {
        put(gpDate);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException {

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPAbsoluteDate test = new TestGPAbsoluteDate();
        
        GPanTest frame = new GPanTest("Absolute date", test, "GPAbsoluteDate.xml");
        //GFrame frame = new GFrame("Absolute date", test);
        frame.display();
        
    }

}
