package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.unit.GMetricUnit;
import fr.cnes.genius.unit.GUnit;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.attitudes.GPAxisCoordinates;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPAxisCoordinates.
 * @author goesterjf
 *
 */
public class TestGPAxisCoordinates extends GPanel implements GReadWrite {

    private GPAxisCoordinates axisUnitary;
    private GPAxisCoordinates axisNoUnitary;
    
    public TestGPAxisCoordinates() {
        
        GUnit[] unitDis = { new GMetricUnit ("m/s") , new GMetricUnit ("km/s") };
        
        axisUnitary = new GPAxisCoordinates("Unitary", true, null);
        axisNoUnitary = new GPAxisCoordinates("Not unitary", false, unitDis);
        
//        GInterval interval = new GInterval(0., Double.POSITIVE_INFINITY);
//        try {
//            axisNoUnitary.setNormInterval(interval);
//        } catch (GIntervalException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
        
//        Vector3D iniVec = new Vector3D(1., 2., 3.);
//        axisUnitary = new GPAxisCoordinates("Unitary", true, iniVec, null);

        
    }

    public void generic() throws GException {
        put(axisUnitary);
        put(axisNoUnitary);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }
    
    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPAxisCoordinates.xml");
        final File locFile = new File("GPAxisCoordinates.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;

        GPanTest panTest = new GPanTest("Axis Coordinates", new TestGPAxisCoordinates(), "GPAxisCoordinates.xml");
        //GFrame panTest = new GFrame("Axis Coordinates", new TestGPAxisCoordinates());
        panTest.display();

    }

}
