package misc;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GFrame;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genopus.bodies.GPCelestialBody;
import fr.cnes.genopus.constantSelectors.GPCelestialBodySelector;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPCelestialBodySelector and GPCelestialBody.
 * @author goesterjf
 *
 */
public class TestGPCelestialBody extends GPanel implements GReadWrite {

    private GPCelestialBodySelector bodySel;
    private GPCelestialBody body;
    
    public TestGPCelestialBody() {

        bodySel = new GPCelestialBodySelector();
        body = new GPCelestialBody("My Body");

    }

    public void generic() throws GException {
        put(bodySel);
        put(body);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException {

        PatriusDataset.addResourcesFromPatriusDataset() ;

        //GPanTest panTest = new GPanTest("Celestial bodies", new TestGPCelestialBody(), "GPCelestialBody.xml");
        GFrame panTest = new GFrame("Celestial bodies", new TestGPCelestialBody());
        panTest.display();

    }

}
