package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.constantSelectors.GPEntryEarthEqRad;
import fr.cnes.genopus.constantSelectors.GPEntryEarthFlat;
import fr.cnes.genopus.constantSelectors.GPEntryEarthJ2;
import fr.cnes.genopus.constantSelectors.GPEntryEarthMu;
import fr.cnes.genopus.constantSelectors.GPEntryEarthRotRate;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPEntryEarth....
 * @author goesterjf
 *
 */
public class TestGPConstants extends GPanel implements GReadWrite {

    private GPEntryEarthMu muSelector;
    private GPEntryEarthEqRad earthEqRadSelector ;
    private GPEntryEarthFlat earthFlatSelector ;
    private GPEntryEarthRotRate earthRotRateSelector ;
    private GPEntryEarthJ2 earthJ2Selector ;
    
    public TestGPConstants() {
        
        muSelector = new GPEntryEarthMu("Earth Mu selector:");
        earthEqRadSelector = new GPEntryEarthEqRad("Earth Equatorial radius selector:");
        earthFlatSelector = new GPEntryEarthFlat("Earth flatness selector");
        earthRotRateSelector = new GPEntryEarthRotRate("Earth rotation rate selector");
        earthJ2Selector = new GPEntryEarthJ2("Earth J2 selector");
        
    }

    public void generic() throws GException {
        put(muSelector);
        put(earthEqRadSelector);
        put(earthFlatSelector);
        put(earthRotRateSelector);
        put(earthJ2Selector);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPConstants.xml");
        final File locFile = new File("GPConstants.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPConstants test = new TestGPConstants();
        
        GPanTest panTest = new GPanTest("GPConstants", test, "GPConstants.xml");
        //GFrame panTest = new GFrame("GPConstants", test);
        panTest.display();

    }

}
