package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.correlation.GPCorrelation;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPCorrelation.
 * @author goesterjf
 *
 */
public class TestGPCorrelation extends GPanel implements GReadWrite {

    private GPCorrelation gpCor;
    
    public TestGPCorrelation() throws PatriusException {
        
        gpCor = new GPCorrelation("Id", "Title");

    }

    public void generic() throws GException {
        put(gpCor);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPCorrelation.xml");
        final File locFile = new File("GPCorrelation.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPCorrelation test = new TestGPCorrelation();
        
        GPanTest frame = new GPanTest("GPCorrelation", test, "GPCorrelation.xml");
        //GFrame frame = new GFrame("Absolute date", test);
        frame.display();
        
    }

}
