package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.time.GPDateOffset;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPAbsoluteDate.
 * @author goesterjf
 *
 */
public class TestGPDateOffset extends GPanel implements GReadWrite {

    private GPDateOffset gpDateOffset;
    
    public TestGPDateOffset() throws PatriusException {
        
        gpDateOffset = new GPDateOffset("date offset", 86400.);

    }

    public void generic() throws GException {
        put(gpDateOffset);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPDateOffset.xml");
        final File locFile = new File("GPDateOffset.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPDateOffset test = new TestGPDateOffset();
        
        GPanTest frame = new GPanTest("Date offset", test, "GPDateOffset.xml");
        frame.display();
        
    }

}
