package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.forces.GPEarthPotentialForceModel.AttractionModelsEnum;
import fr.cnes.genopus.forces.GPForceModels;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;


/**
 * Tutorial for using GPForceModels.
 * @author goesterjf
 *
 */
public class TestGPForceModels extends GPanel implements GReadWrite {
 
    private GPForceModels models;
    
    public TestGPForceModels() {
        
        AttractionModelsEnum[] attractionModelsAvailable = { AttractionModelsEnum.DROZINER, AttractionModelsEnum.BALMINO };
        models = new GPForceModels("", "MyModels", AttractionModelsEnum.BALMINO, attractionModelsAvailable , true, true, true, true, true, true, true);
        
    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(models);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPForceModels.xml");
        final File locFile = new File("GPForceModels.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPForceModels test = new TestGPForceModels();

        GPanTest frame = new GPanTest("Force models", test, "GPForceModels.xml");
        frame.display();
        
        

    }

}
