package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.frames.GPFramesConfiguration;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.frames.configuration.DiurnalRotation;
import fr.cnes.sirius.patrius.frames.configuration.FramesConfiguration;
import fr.cnes.sirius.patrius.frames.configuration.FramesConfigurationBuilder;
import fr.cnes.sirius.patrius.frames.configuration.PolarMotion;
import fr.cnes.sirius.patrius.frames.configuration.eop.EOP2000HistoryConstantOutsideInterval;
import fr.cnes.sirius.patrius.frames.configuration.eop.EOPInterpolators;
import fr.cnes.sirius.patrius.frames.configuration.libration.LibrationCorrectionModel;
import fr.cnes.sirius.patrius.frames.configuration.libration.LibrationCorrectionModelFactory;
import fr.cnes.sirius.patrius.frames.configuration.precessionnutation.PrecessionNutation;
import fr.cnes.sirius.patrius.frames.configuration.precessionnutation.PrecessionNutationModelFactory;
import fr.cnes.sirius.patrius.frames.configuration.sp.SPrimeModelFactory;
import fr.cnes.sirius.patrius.frames.configuration.tides.TidalCorrectionModel;
import fr.cnes.sirius.patrius.frames.configuration.tides.TidalCorrectionModelFactory;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPFramesConfiguration.
 * @author goesterjf
 *
 */
public class TestGPFramesConfiguration extends GPanel implements GReadWrite {

    private GPFramesConfiguration framesConf;
    
    public TestGPFramesConfiguration() {
        
        final FramesConfiguration initFrameConf = getIniConfiguration();
        framesConf = new GPFramesConfiguration(initFrameConf, "Label");
//        try {
//            framesConf.setAvailableFrameConfs(GPFramesConfiguration.GPFrameConfs.iers2010, GPFramesConfiguration.GPFrameConfs.iers2003);
//        } catch (GPFrameException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//        framesConf = new GPFramesConfiguration("Label", GPFramesConfiguration.GPFrameConfs.iers2010);
//        framesConf = new GPFramesConfiguration("Label", GPFramesConfiguration.GPFrameConfs.iers2010, GPFramesConfiguration.GPFrameConfs.iers2003);
//        framesConf = new GPFramesConfiguration(GPFramesConfiguration.GPFrameConfs.iers2003, "Label", GPFramesConfiguration.GPFrameConfs.iers2010, GPFramesConfiguration.GPFrameConfs.iers2003);

    }

    public void generic() throws GException {
        put(framesConf);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * Method to configure frames configuration.
     * @return frame configuration object
     */
    private FramesConfiguration getIniConfiguration() {

        // Configurations builder
        final FramesConfigurationBuilder builder = new FramesConfigurationBuilder();

        // Tides and libration
        final TidalCorrectionModel tides = TidalCorrectionModelFactory.TIDE_IERS2010_INTERPOLATED;
        final LibrationCorrectionModel lib = LibrationCorrectionModelFactory.LIBRATION_IERS2010;

        // Polar Motion
        final PolarMotion defaultPolarMotion = new PolarMotion(true, tides, lib, SPrimeModelFactory.SP_IERS2010);

        // Diurnal rotation
        final DiurnalRotation defaultDiurnalRotation = new DiurnalRotation(tides, lib);

        // Precession Nutation
        PrecessionNutation precNut = new PrecessionNutation(true, PrecessionNutationModelFactory.PN_IERS2010_INTERPOLATED_NON_CONSTANT_OLD);

        builder.setDiurnalRotation(defaultDiurnalRotation);
        builder.setPolarMotion(defaultPolarMotion);
        builder.setCIRFPrecessionNutation(precNut);
        builder.setEOPHistory(new EOP2000HistoryConstantOutsideInterval(EOPInterpolators.LINEAR));
        //builder.setEOPHistory(new EOP2000History(EOPInterpolators.LINEAR));

        return builder.getConfiguration();
        
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPFramesConfiguration.xml");
        final File locFile = new File("GPFramesConfiguration.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPFramesConfiguration test = new TestGPFramesConfiguration();
        
        GPanTest panTest = new GPanTest("Frames configuration", test, "GPFramesConfiguration.xml");
        //GFrame panTest = new GFrame("Frames configuration", test);
        panTest.display();

    }

}
