package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.bodies.GPGeodeticPoint;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPGeodeticPoint.
 * @author goesterjf
 *
 */
public class TestGPGeodeticPoint extends GPanel implements GReadWrite {

    private GPGeodeticPoint geodWithAlt;
    private GPGeodeticPoint geodWithoutAlt;
    private GPGeodeticPoint geodWithoutName;
    
    public TestGPGeodeticPoint() {

        geodWithAlt = new GPGeodeticPoint ("With altitude:");
        geodWithoutAlt = new GPGeodeticPoint ("Without altitude:", false, true);
        geodWithoutName = new GPGeodeticPoint ("Without name:", true, false);
        
//        GeodeticPoint geodeticPoint = new GeodeticPoint(FastMath.toRadians(45.), FastMath.toRadians(10.), 120.e+3);
//        geodWithoutAlt = new GPGeodeticPoint("Without altitude:", geodeticPoint, false);
        
    }

    public void generic() throws GException {
        put(geodWithAlt);
        put(geodWithoutAlt);
        put(geodWithoutName);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPGeodeticPoint.xml");
        final File locFile = new File("GPGeodeticPoint.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;
        
        GPanTest panTest = new GPanTest("Geodetic coordinates", new TestGPGeodeticPoint(), "GPGeodeticPoint.xml");
        panTest.display();

    }

}
