package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GArithmeticException;
import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.exception.GPFrameException;
import fr.cnes.genopus.groundstation.GPGroundStation;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.bodies.EllipsoidPoint;
import fr.cnes.sirius.patrius.bodies.LLHCoordinates;
import fr.cnes.sirius.patrius.bodies.LLHCoordinatesSystem;
import fr.cnes.sirius.patrius.bodies.OneAxisEllipsoid;
import fr.cnes.sirius.patrius.fieldsofview.CircularField;
import fr.cnes.sirius.patrius.frames.FramesFactory;
import fr.cnes.sirius.patrius.frames.TopocentricFrame;
import fr.cnes.sirius.patrius.groundstation.GeometricStationAntenna;
import fr.cnes.sirius.patrius.math.geometry.euclidean.threed.Vector3D;
import fr.cnes.sirius.patrius.math.util.FastMath;
import fr.cnes.sirius.patrius.utils.Constants;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPGroundStation.
 * @author goesterjf
 *
 */
public class TestGPGroundStation extends GPanel implements GReadWrite {

    private final GPGroundStation gpStationVoid;
    private final GPGroundStation gpStationInit;
    
    public TestGPGroundStation() throws GPFrameException, GArithmeticException, PatriusException {
        
        final OneAxisEllipsoid body = new OneAxisEllipsoid(Constants.WGS84_EARTH_EQUATORIAL_RADIUS, Constants.WGS84_EARTH_FLATTENING, FramesFactory.getITRF(), "GeoTest");
        final LLHCoordinates coord = new LLHCoordinates(LLHCoordinatesSystem.ELLIPSODETIC, FastMath.toRadians(45.), FastMath.toRadians(45.), 100.);
        final EllipsoidPoint point = new EllipsoidPoint(body, coord, "GeoTest");
        final TopocentricFrame topoFrame = new TopocentricFrame(point, "FrameTest");
        final CircularField mask = new CircularField("Masktest", FastMath.toRadians(10.), Vector3D.PLUS_K);
        final GeometricStationAntenna antenna = new GeometricStationAntenna(topoFrame, mask);

        gpStationVoid = new GPGroundStation();
        gpStationInit = new GPGroundStation("", antenna);

    }

    public void generic() throws GException {
        put(gpStationVoid);
        put(gpStationInit);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws PatriusException 
     * @throws GArithmeticException 
     * @throws GPFrameException 
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, GPFrameException, GArithmeticException, IOException  {

        final File refFile = new File("src/test/resources/GPGroundStation.xml");
        final File locFile = new File("GPGroundStation.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPGroundStation test = new TestGPGroundStation();
        
        GPanTest frame = new GPanTest("Ground Station", test, "GPGroundStation.xml");
        //GFrame frame = new GFrame("Ground Station", test);
        frame.display();
        
    }

}
