package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.math.GPIntegrator;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

public class TestGPIntegrator extends GPanel implements GReadWrite {
    
    private final GPIntegrator gpInteg;
    
    public TestGPIntegrator() throws GException, PatriusException {

//        final IntegratorTypeEnum[] types = { IntegratorTypeEnum.RK4, IntegratorTypeEnum.DOP };
//        this.gpInteg = new GPIntegrator(types, IntegratorTypeEnum.RK4);
        this.gpInteg = new GPIntegrator();
        this.gpInteg.setRKParameters(5.);
        
    }

    @Override
    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(gpInteg);
    }

    @Override
    public void read() throws GException {
        generic();
    }

    @Override
    public void write() throws GException {
        generic();
        
    }
    public static void main(String[] args) throws PatriusException, GException, IOException {

        final File refFile = new File("src/test/resources/GPIntegrator.xml");
        final File locFile = new File("GPIntegrator.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;

        final GPanTest frame = new GPanTest("Integrator", new TestGPIntegrator(), "GPIntegrator.xml");
        frame.display();

    }


}
