package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.bodies.GPOneAxisEllipsoid;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPOneAxisEllipsoid.
 * @author goesterjf
 *
 */
public class TestGPOneAxisEllipsoïd extends GPanel implements GReadWrite {

    private GPOneAxisEllipsoid ellips;
    
    public TestGPOneAxisEllipsoïd() throws PatriusException {

        ellips = new GPOneAxisEllipsoid("My Ellipsoid");
//        ellips = new GPOneAxisEllipsoid("My Ellipsoid", GPRefFrame.ITRF, GPRefFrame.TIRF);
//
//        try {
//            ellips.setAvailableFrames(GPRefFrame.ITRF, GPRefFrame.TIRF);
//        } catch (GPFrameException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }
//        
//        final double REQ  = Constants.WGS84_EARTH_EQUATORIAL_RADIUS;
//        final double FLAT = Constants.WGS84_EARTH_FLATTENING;
//        final Frame ITRF = FramesFactory.getITRF();
//        final ExtendedOneAxisEllipsoid earth = new ExtendedOneAxisEllipsoid(REQ, FLAT, ITRF, "EARTH");
//
//        ellips = new GPOneAxisEllipsoid("My Ellipsoid", earth);

        
    }

    public void generic() throws GException {
        put(ellips);
    }
    
    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPOneAxisEllipsoid.xml");
        final File locFile = new File("GPOneAxisEllipsoid.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;

        GPanTest panTest = new GPanTest("One Axis Ellipsoid", new TestGPOneAxisEllipsoïd(), "GPOneAxisEllipsoid.xml");
        //GFrame panTest = new GFrame("One Axis Ellipsoid", new TestGPOneAxisEllipsoid());
        panTest.display();

    }

}
