package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GEvent;
import fr.cnes.genius.main.GListener;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.exception.GPOrbitException;
import fr.cnes.genopus.orbits.GPOrbit;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.math.util.FastMath;
import fr.cnes.sirius.patrius.orbits.KeplerianOrbit;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPOrbit.
 * @author goesterjf
 *
 */
public class TestGPOrbit extends GPanel implements GReadWrite, GListener {

    private GPOrbit gpOrbit;
    
    public TestGPOrbit() throws PatriusException, GPOrbitException{
        
        gpOrbit = new GPOrbit("Orbit:");
//        final TimeScale TUC = TimeScalesFactory.getUTC();
//        final Frame eme2000 = FramesFactory.getEME2000();
//        final AbsoluteDate date0 = new AbsoluteDate(2024, 1, 1, TUC);
//        try {
//            final Orbit iniOrb = new KeplerianOrbit(0.e+3, 0., 0., 0., 0., 0., PositionAngle.TRUE, eme2000, date0, Constants.WGS84_EARTH_MU);
//            // Initial orbit
//            gpOrbit.setOrbit(iniOrb);
//            // Same orbit for the default one (reset)
//            gpOrbit.setDefaultOrbit(iniOrb);
//        } catch ( GArithmeticException err ) {
//            // Nothing  to do
//        }
        
//        final Frame CIRF = FramesFactory.getCIRF();
//        final TimeScale TUC = TimeScalesFactory.getUTC();
//        final AbsoluteDate date0 = new AbsoluteDate(2010, 1, 1, 12, 0, 0., TUC);
//        final double ae = Constants.WGS84_EARTH_EQUATORIAL_RADIUS;
//        final double mu = Constants.WGS84_EARTH_MU;
//        ApsisOrbit orbit = new ApsisOrbit(ae+200.e+3, ae+300.e+3, FastMath.toRadians(51.6), 0., 0., 0., PositionAngle.MEAN, CIRF, date0, mu);
//        gpOrbit = new GPOrbit("Orbit", orbit);
//        
//        GPRefFrame[] tabFrames = gpOrbit.getAvailableFrames();
//        GPRefFrame[] tabFramesSimplified = new GPRefFrame[3];
//        tabFramesSimplified[0] = tabFrames[0];
//        tabFramesSimplified[1] = tabFrames[1];
//        tabFramesSimplified[2] = tabFrames[6];
//        gpOrbit.setAvailableFrames(tabFramesSimplified);
//                
//        GPParamsType[] tabParams = gpOrbit.getAvailableParamsTypes();
//        GPParamsType[] tabParamsSimplified = new GPParamsType[4];
//        tabParamsSimplified[0] = tabParams[0];
//        tabParamsSimplified[1] = tabParams[1];
//        tabParamsSimplified[2] = tabParams[5];
//        tabParamsSimplified[3] = tabParams[7];
//        gpOrbit.setAvailableParamsTypes(tabParamsSimplified);
        
    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(gpOrbit);
        if ( gpOrbit.getPatriusObject() != null ) {
            System.out.println(gpOrbit.getPatriusObject().getA());
            System.out.println(FastMath.toDegrees(gpOrbit.getPatriusObject().getI()));
            final KeplerianOrbit kep = new KeplerianOrbit(gpOrbit.getPatriusObject());
            System.out.println("anv = " + FastMath.toDegrees(kep.getTrueAnomaly()));
            System.out.println("anm = " + FastMath.toDegrees(kep.getMeanAnomaly()));
            System.out.println(gpOrbit.getPivotParametersType());
        }
    }

    
    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws PatriusException 
     * @throws GPOrbitException 
     * @throws IOException 
     */
    public static void main(String[] args) throws GPOrbitException, PatriusException, IOException  {

        final File refFile = new File("src/test/resources/GPOrbit.xml");
        final File locFile = new File("GPOrbit.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;
        
        // Simple configuration
//        FramesConfiguration configSimple = FramesConfigurationFactory.getSimpleConfiguration(true);
//        FramesFactory.setConfiguration(configSimple);
        
        GPanTest frame = new GPanTest("Orbit", new TestGPOrbit(), "GPOrbit.xml");
        //GFrame frame = new GFrame("Orbit", new TestGPOrbit());
        frame.display();

    }

    @Override
    public void before(GEvent e) throws GException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void after(GEvent e) throws GException {

//      if ( gpOrbit.getPatriusObject() != null ) {
//          System.out.println(gpOrbit.getPatriusObject().getA());
//          System.out.println(FastMath.toDegrees(gpOrbit.getPatriusObject().getI()));
//          final KeplerianOrbit kep = new KeplerianOrbit(gpOrbit.getPatriusObject());
//          System.out.println("anv = " + FastMath.toDegrees(kep.getTrueAnomaly()));
//          System.out.println("anm = " + FastMath.toDegrees(kep.getMeanAnomaly()));
//          System.out.println(gpOrbit.getPivotParametersType());
//      }
        
    }

}
