package misc;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.attitudes.GPRotation;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using TestGPRotation.
 * @author goesterjf
 *
 */
public class TestGPRotation extends GPanel implements GReadWrite {

    private GPRotation rotation;
    
    public TestGPRotation() {

        rotation = new GPRotation ("Label");
//        CustomRotation rot = new CustomRotation(RotationOrder.ZYX, FastMath.PI, 0., 0.);
//        rotation = new GPRotation ("Label", rot);
        
    }

    public void generic() throws GException {
        put(rotation);
    }

    public void display() throws GException {
        generic();
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPRotation.xml");
        final File locFile = new File("GPRotation.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;

        GPanTest panTest = new GPanTest("Rotation", new TestGPRotation(), "GPRotation.xml");
        //GFrame panTest = new GFrame("Rotation", new TestGPRotation());
        panTest.display();

    }

}
