package misc;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;

import fr.cnes.genius.exception.GFileManipulatorException;
import fr.cnes.genopus.exception.GPOrbitException;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPOrbit.
 * @author goesterjf
 *
 */
public class TestPrecision {

    /**
     * @param args
     * @throws PatriusException 
     * @throws GPOrbitException 
     * @throws GFileManipulatorException 
     */
    public static void main(String[] args) throws PatriusException, GPOrbitException, GFileManipulatorException {
        
        Locale.setDefault(Locale.US);
        
        MathContext MC = new MathContext(20, RoundingMode.HALF_UP);
        
        double iniValue = 0.03827;
        double convertFactor = 1.;
        int convertFactorToSIExpBaseTen = 3;
        
//        System.out.println();
//        System.out.println("Initial double value:                  " + iniValue);
//        System.out.println("Wanted value:                          " + 38.27);
//        System.out.println("Modified value using double factor:    " + iniValue*StrictMath.pow(10, convertFactorToSIExpBaseTen));
//        
//        convert(MC, iniValue, convertFactor, convertFactorToSIExpBaseTen);

        iniValue = -5.277E1;
        convertFactor = 0.017453292519943295;
        //convertFactor = StrictMath.toRadians(1.);
        convertFactorToSIExpBaseTen = 0;
        
        System.out.println();
        System.out.println("Initial double value:                  " + iniValue);
        System.out.println("Wanted value:                          " + StrictMath.toRadians(iniValue));
        System.out.println("Modified value using double factor:    " + iniValue*convertFactor);

        convert(MC, iniValue, convertFactor, convertFactorToSIExpBaseTen);

        iniValue = -5.277E1;
        convertFactor = 0.017453292519943295;

        final BigDecimal doubleVal1 =  new BigDecimal(iniValue);
        final BigDecimal doubleVal2 =  new BigDecimal(convertFactor);
        final BigDecimal bigVal1 =  BigDecimal.valueOf(iniValue);
        final BigDecimal bigVal2 =  BigDecimal.valueOf(convertFactor);
        final BigDecimal eps1 = doubleVal1.subtract(bigVal1);
        final BigDecimal eps2 = doubleVal2.subtract(bigVal2);
        System.out.println("eps1 = " + eps1);
        System.out.println("eps2 = " + eps2);
        
        final MathContext mc = new MathContext(16, RoundingMode.HALF_UP);
        final BigDecimal goodValue = bigVal1.multiply(bigVal2, mc);
        System.out.println("Good final value = " + goodValue);
        final BigDecimal eps = bigVal1.multiply(eps2).add(bigVal2.multiply(eps1)).add(eps1.multiply(eps2), MC);
        System.out.println("eps = " + eps);
        final BigDecimal wrongValue = goodValue.add(eps, mc);
        System.out.println("Wrong final value = " + wrongValue);
        
        MC = new MathContext(20, RoundingMode.HALF_UP);
        System.out.println(new BigDecimal(0.017453292519943295));
        System.out.println(new BigDecimal(0.0174532925199432951, MC));
        System.out.println(BigDecimal.valueOf(0.017453292519943295));
        System.out.println(new BigDecimal("0.017453292519943295"));
        
   }
    
    private static void convert (final MathContext MC, final double iniValue, final double convertFactor, final int convertFactorToSIExpBaseTen) {
        
        System.out.println();

        final BigDecimal iniValueBig = BigDecimal.valueOf(iniValue);
        System.out.println("Initial big value:                     " + iniValueBig);
        
        System.out.println("Conversion factor (double):            " + convertFactor);
        //final BigDecimal factorBig = new BigDecimal(convertFactor, MC);
        final BigDecimal factorBig = BigDecimal.valueOf(convertFactor);
        System.out.println("Conversion factor (big):               " + factorBig);
        final BigDecimal factorBigTen = factorBig.multiply(BigDecimal.valueOf(StrictMath.pow(10, convertFactorToSIExpBaseTen)), MC);
        System.out.println("Conversion factor with power 10 (big): " + factorBigTen);
        
        final BigDecimal valModif = iniValueBig.multiply(factorBigTen, MC);
        System.out.println("Modified big value:                    " + valModif);
        final double value = valModif.doubleValue();
        System.out.println("Modified double value:                 " + value);
        
    }
    
}
