package vehicle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.maneuvers.GPEngine;
import fr.cnes.genopus.maneuvers.GPFuelTank;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.assembly.properties.PropulsiveProperty;
import fr.cnes.sirius.patrius.assembly.properties.TankProperty;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPEngine and GPFuelTank.
 * @author goesterjf
 *
 */
public class TestGPEngineAndTank extends GPanel implements GReadWrite {

    private GPEngine engine;
    private GPFuelTank tank;
    
    public TestGPEngineAndTank() throws PatriusException {

        PropulsiveProperty prop = new PropulsiveProperty(400., 230.);
//        prop.setPartName("OCS");
//        engine = new GPEngine();
//        engine = new GPEngine("label");
//        engine = new GPEngine("widId", "label");
        engine = new GPEngine("wid", "Label", "OCS", prop);

        TankProperty tankProp = new TankProperty(250.);
        //tankProp.setPartName("T1");
        tank = new GPFuelTank("My Tank", "T1", tankProp);

    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(engine);
        put(tank);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }
    
   /**
     * @param args
 * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPEngineAndTank.xml");
        final File locFile = new File("GPEngineAndTank.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset();
        
        TestGPEngineAndTank test = new TestGPEngineAndTank();

        GPanTest frame = new GPanTest("Engine and tank", test, "GPEngineAndTank.xml");
        frame.display();

    }

}
