package vehicle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.vehicle.GPVehicle;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPVehicle.
 * @author goesterjf
 *
 */
public class TestGPVehicle extends GPanel implements GReadWrite {
    
    private GPVehicle veh;
    
    public TestGPVehicle () {
        
        //veh = new GPVehicle("My Vehicle");
        veh = new GPVehicle("My Vehicle", true, true, true, true, true);

    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(veh);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws IOException 
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException, IOException {

        final File refFile = new File("src/test/resources/GPVehicule.xml");
        final File locFile = new File("GPVehicule.xml");
        Files.copy(refFile.toPath(), locFile.toPath(), StandardCopyOption.REPLACE_EXISTING);

        PatriusDataset.addResourcesFromPatriusDataset() ;
        
        TestGPVehicle test = new TestGPVehicle();
        
        //GFrame frame = new GFrame("Vehicle", test);
        GPanTest frame = new GPanTest("Vehicle", test, "GPVehicule.xml");
        
        frame.display();

    }

}
