package vehicle;
import java.util.ArrayList;

import fr.cnes.genius.exception.GException;
import fr.cnes.genius.lowLevel.GPanel;
import fr.cnes.genius.main.GReadWrite;
import fr.cnes.genius.utils.GPanTest;
import fr.cnes.genopus.vehicle.GPVehicle;
import fr.cnes.sirius.addons.patriusdataset.PatriusDataset;
import fr.cnes.sirius.patrius.assembly.Vehicle;
import fr.cnes.sirius.patrius.assembly.properties.MassProperty;
import fr.cnes.sirius.patrius.assembly.properties.PropulsiveProperty;
import fr.cnes.sirius.patrius.assembly.properties.TankProperty;
import fr.cnes.sirius.patrius.assembly.vehicle.AerodynamicProperties;
import fr.cnes.sirius.patrius.assembly.vehicle.VehicleSurfaceModel;
import fr.cnes.sirius.patrius.math.geometry.euclidean.threed.RightParallelepiped;
import fr.cnes.sirius.patrius.utils.exception.PatriusException;

/**
 * Tutorial for using GPVehicle with initialization using CustomVehicle.
 * @author goesterjf
 *
 */
public class TestGPVehicleWithInit extends GPanel implements GReadWrite {
    
    private final GPVehicle veh;
    
    public TestGPVehicleWithInit () throws PatriusException {

        
        // DRY MASS
        final double dryMass = 1000.;
        MassProperty dryMassProperty = null;
        try {
            dryMassProperty = new MassProperty(dryMass);
        } catch (PatriusException err) {
            err.printStackTrace();
        }
        
        // PROPULSION
        final ArrayList<PropulsiveProperty> enginesList = new ArrayList<PropulsiveProperty>();
        PropulsiveProperty prop1 = new PropulsiveProperty(1000., 320.);
        prop1.setPartName("OCS");
        enginesList.add(prop1);
        PropulsiveProperty prop2 = new PropulsiveProperty(270., 150.);
        prop2.setPartName("ACS");
        enginesList.add(prop2);
        final ArrayList<TankProperty> fuelTankList = new ArrayList<TankProperty>();
        TankProperty tank = new TankProperty(500.);
        tank.setPartName("TANK");
        fuelTankList.add(tank);
        
        // SHAPE
        
        final RightParallelepiped parall = new RightParallelepiped(4.0, 1.0, 2.0);
        VehicleSurfaceModel vehicleRefSurface = new VehicleSurfaceModel(parall, null);

        final double cd = 2.0;
        final double cl = 0.;
        final AerodynamicProperties aerodynamicProperties = new AerodynamicProperties(vehicleRefSurface, cd, cl);

        final Vehicle vehicle = new Vehicle(vehicleRefSurface, null, dryMassProperty, aerodynamicProperties, null, enginesList, fuelTankList);
       
        veh = new GPVehicle("My Vehicle", vehicle);

    }

    public void display() throws GException {
        generic();
    }

    @Override
    public void generic() throws GException {
        put(veh);
    }

    public void read() throws GException {
        generic();
    }

    public void write() throws GException {
        generic();
    }

    /**
     * @param args
     * @throws PatriusException 
     */
    public static void main(String[] args) throws PatriusException {

        PatriusDataset.addResourcesFromPatriusDataset() ;
        
        TestGPVehicleWithInit test = new TestGPVehicleWithInit();
        //GFrame frame = new GFrame("Vehicle", test);
        GPanTest frame = new GPanTest("Vehicle", test, "Vehicule.xml");
        
        frame.display();
        
    }

}
