// -------------------------------------------------------
// Data from: "JGGRX_0420A_SHA.TAB" and "JGGRX_0420A_SHA.LBL" files in:
// http://pds-geosciences.wustl.edu/grail/grail-l-lgrs-5-rdr-v1/grail_1001/shadr/
// Originaly with degree max of 420, it has been cut to degree max 100.
// 
// This file contains coefficients and related data for the JPL Lunar gravity
// field GRAIL420C1A, a 420th degree and order spherical harmonic model. It is
// a JPL gravity field that includes the entire primary mission of
// GRAIL tracking data (March 1, 16:30 to May 29, 16:36:00, 2012).
//
// Some details describing this model are:
// - The spherical harmonic coefficients are fully normalized.
// - The reference radius = 1738.0 km
// - The planetary ephemeris is de421 and defines the lunar body-fixed
//   coordinate system.
// - A Kaula type power law constraint is applied to the spherical harmonics
//   coefficients for degrees >330 (3.6e-4/n^2).
// - The weighting of the KBRR data is mostly 0.1 microns/sec and otherwise
//   a variable weight is used around the orbit.
// - The Love number k2 = 0.0248 (not estimated but held fixed). The second 
//   degree gravity coefficients of this model do not include the permanent 
//   tide.
//
// The reference for the GL0420A gravity field is KONOPLIVETAL2013,
// published in the Journal of Geophysical Research with the DOI number
// 0.1002/jgre.20097.
//
// This file is a pair of ASCII tables: a header table and a table of
// 177240 coefficients plus a value for GM.  Definitions of the tables
// follow.
// -------------------------------------------------------

// For a gravity field model
// the assumed gravitational constant GM in kilometers cubed
// per seconds squared for the planet.  For a topography
// model, set to 1.
// gravitational constant (m^3/s^2)
data.mu = 0.4902800126160000E+13 

// The assumed reference radius of the spherical planet.
// equatorial radius (m)
data.er = 0.1738000000000000E+07

// Cnm, Snm normalized coefficients
// 1: degree (n). The degree index m of the C and S coefficients in this record
// 2: order (m).  The order index n of the C and S coefficients in this record
// 3: Cnm.        The coefficient Cmn for this spherical harmonic model
// 4: Snm.        The coefficient Smn for this spherical harmonic model
// NB: central term (n=0, m=0) added
data.coef = [
0 0  1.0000000000000000E+00  0.0000000000000000E+00
1 0  0.0000000000000000E+00  0.0000000000000000E+00
1 1  0.0000000000000000E+00  0.0000000000000000E+00
2 0 -0.9087974694316000E-04  0.0000000000000000E+00
2 1  0.4804858187034000E-11  0.8319976179256000E-09
2 2  0.3467157070685000E-04 -0.2080905319450000E-09
3 0 -0.3197483172669000E-05  0.0000000000000000E+00
3 1  0.2636797758064000E-04  0.5454528124967000E-05
3 2  0.1417154761018000E-04  0.4877983761921000E-05
3 3  0.1227503842700000E-04 -0.1774392494042000E-05
4 0  0.3234787544589000E-05  0.0000000000000000E+00
4 1 -0.6013462538980000E-05  0.1664327383234000E-05
4 2 -0.7116173124950000E-05 -0.6777040203801000E-05
4 3 -0.1350004578974000E-05 -0.1344499562042000E-04
4 4 -0.6007218421231000E-05  0.3926844078609000E-05
5 0 -0.2237895028963000E-06  0.0000000000000000E+00
5 1 -0.1011612026117000E-05 -0.4118918590128000E-05
5 2  0.4399527730258000E-05  0.1057126381069000E-05
5 3  0.4661799530086000E-06  0.8698891186531000E-05
5 4  0.2754160543604000E-05  0.6762927601539000E-07
5 5  0.3110802396520000E-05 -0.2754562706853000E-05
6 0  0.3818429731721000E-05  0.0000000000000000E+00
6 1  0.1528269259667000E-05 -0.2599593504407000E-05
6 2 -0.4397305532799000E-05 -0.2167691353650000E-05
6 3 -0.3317543579200000E-05 -0.3427424034693000E-05
6 4  0.3411544820608000E-06 -0.4057987871277000E-05
6 5  0.1454377510090000E-05 -0.1034179409900000E-04
6 6 -0.4684302102779000E-05  0.7229676026112000E-05
7 0  0.5593395521180000E-05  0.0000000000000000E+00
7 1  0.7471679448922000E-05 -0.1197372248415000E-06
7 2 -0.6501386277161000E-06  0.2411114548482000E-05
7 3  0.5994270540752000E-06  0.2357326252726000E-05
7 4 -0.8437053566645000E-06  0.7565179395171000E-06
7 5 -0.2068114534889000E-06  0.1069299864304000E-05
7 6 -0.1065341843530000E-05  0.1100465135969000E-05
7 7 -0.1820298178535000E-05 -0.1600040313298000E-05
8 0  0.2346831025052000E-05  0.0000000000000000E+00
8 1  0.4172552758326000E-08  0.1098040161291000E-05
8 2  0.3009317424280000E-05  0.1930559600363000E-05
8 3 -0.1889046873321000E-05  0.9544856234862001E-06
8 4  0.3408665044948000E-05 -0.5282366567240999E-06
8 5 -0.1248041915031000E-05  0.2918563973395000E-05
8 6 -0.1660485526106000E-05 -0.2114745802343000E-05
8 7 -0.1509638443524000E-05  0.3268877315657000E-05
8 8 -0.2485687875411000E-05  0.2116381872934000E-05
9 0 -0.3530908226176000E-05  0.0000000000000000E+00
9 1  0.1866966711820000E-05  0.8103920415300000E-07
9 2  0.1927806207769000E-05 -0.1387568154334000E-05
9 3 -0.1992407183919000E-05  0.2201757910190000E-05
9 4 -0.1884446627709000E-05 -0.1425791526555000E-05
9 5 -0.1562514670072000E-05 -0.3524685176376000E-05
9 6 -0.2127263414440000E-05 -0.3002637322559000E-05
9 7 -0.3914777590918000E-05 -0.1068148458108000E-06
9 8 -0.1312026278751000E-05 -0.2203374191835000E-05
9 9 -0.9384258636469000E-06  0.2488174834497000E-05
10 0 -0.1069297690343000E-05  0.0000000000000000E+00
10 1  0.8415984243707000E-06 -0.9540746227385000E-06
10 2  0.3572480338553000E-06 -0.2651167020141000E-06
10 3  0.4841979498210000E-06  0.6688279867555000E-06
10 4 -0.3572977017844000E-05  0.1578945238596000E-05
10 5  0.6996909768799000E-06 -0.3145796496684000E-06
10 6 -0.1273180601437000E-06 -0.2095335437909000E-05
10 7 -0.3998641877237000E-05 -0.9107313784394000E-06
10 8 -0.3559447594232000E-05  0.2848851002686000E-05
10 9 -0.4753134677431000E-05 -0.5153017437100000E-07
10 10  0.9478676858446000E-06 -0.1719399182547000E-05
11 0 -0.8852076767453000E-06  0.0000000000000000E+00
11 1 -0.1946044266300000E-07  0.6142511984240000E-06
11 2  0.6995146181006000E-06 -0.1968043258086000E-05
11 3  0.4084201422127000E-06  0.7362531201932000E-06
11 4 -0.1086773767489000E-05  0.2190865451662000E-05
11 5  0.5034365538595000E-07  0.2588024378509000E-05
11 6  0.5243013867289000E-06 -0.1367012423382000E-05
11 7 -0.8451942146091000E-07 -0.2841086074666000E-05
11 8 -0.2095281728560000E-05 -0.3828935207313000E-06
11 9 -0.2334966283179000E-05  0.2526551003639000E-06
11 10 -0.4680576295625000E-05 -0.1735236718293000E-06
11 11 -0.2888897233972000E-05 -0.1746420532514000E-05
12 0 -0.2012262985203000E-05  0.0000000000000000E+00
12 1 -0.7068834790521999E-06  0.1647781324706000E-05
12 2 -0.1052068662603000E-06  0.1507830472453000E-05
12 3  0.8556873203983000E-06 -0.4058950441226000E-05
12 4  0.8130127383744000E-06 -0.3446127546387000E-06
12 5  0.2118874848858000E-09  0.8936292416852000E-06
12 6  0.1089057335053000E-05  0.5452228537181000E-06
12 7  0.2140000678809000E-05 -0.9675565865719000E-06
12 8  0.3985413741183000E-06 -0.2206562056716000E-05
12 9 -0.1345166427685000E-05  0.1095002902435000E-05
12 10 -0.3075501868959000E-05 -0.1273915482461000E-05
12 11 -0.9818155887107001E-06 -0.3284559025985000E-06
12 12  0.3027594417216000E-06  0.1246952985192000E-05
13 0  0.2564806504871000E-06  0.0000000000000000E+00
13 1  0.1354469218737000E-05 -0.7667054415391000E-07
13 2 -0.3425230034847000E-05  0.3839758143147000E-06
13 3 -0.4333560900703000E-06 -0.1456314069147000E-05
13 4  0.7772644841020999E-06 -0.5819355163115000E-06
13 5 -0.1186340813268000E-05  0.1021334270728000E-05
13 6 -0.2768725356657000E-07  0.1384222701817000E-05
13 7 -0.1621205577355000E-06 -0.6726561991307000E-06
13 8 -0.2922937410269000E-06 -0.1210501587820000E-05
13 9 -0.1699738796792000E-06  0.5274961251588000E-06
13 10 -0.6742866345593000E-06  0.4529118824184000E-06
13 11 -0.1305702910880000E-05  0.4390357203036000E-06
13 12 -0.5743877592131000E-06 -0.1522330750609000E-05
13 13  0.2499358170397000E-05 -0.2668846271422000E-05
14 0  0.4922517471616000E-06  0.0000000000000000E+00
14 1  0.5654280075852000E-06 -0.6821039878627000E-06
14 2  0.3644193911184000E-06  0.3552088806774000E-06
14 3  0.5578953126639000E-06  0.1680017990393000E-06
14 4 -0.3905363473054000E-06 -0.2582053868316000E-05
14 5 -0.7823937930400000E-06 -0.2160110998445000E-06
14 6 -0.6096167599215000E-06  0.1862266182482000E-05
14 7 -0.5154267572861000E-06  0.1161520821766000E-05
14 8  0.3061409857730000E-06  0.4414536158129000E-06
14 9  0.8049522791867999E-07 -0.1638051790479000E-05
14 10 -0.7782069699445000E-06  0.5930153063534000E-06
14 11 -0.1928482849914000E-05  0.1937228030736000E-05
14 12 -0.1448555321791000E-05 -0.5394516128630000E-06
14 13 -0.3214111000356000E-06 -0.1017801820736000E-05
14 14 -0.6134795754837000E-06  0.1071096192049000E-05
15  0 -0.2280876443110000E-06  0.0000000000000000E+00
15 1 -0.7975322036970000E-06  0.3536148251061000E-06
15 2 -0.5401451233666000E-07  0.7446560425176000E-06
15 3 -0.1378243141496000E-05 -0.6307015436633000E-06
15 4 -0.9560616651723001E-06 -0.1323371484202000E-05
15 5  0.7737289472380001E-08 -0.8933998787755000E-06
15 6 -0.6443453275141000E-07 -0.3306804200734000E-06
15 7  0.1125286087788000E-05  0.1489404493056000E-05
15 8  0.1315099155505000E-05  0.1886577370800000E-05
15 9 -0.8522813936332999E-07 -0.1011626933079000E-05
15 10 -0.6014347713866000E-07  0.4227485504140000E-06
15 11 -0.1426286954165000E-05 -0.1502442684813000E-05
15 12 -0.1767202245449000E-05 -0.4717707839820000E-06
15 13 -0.4049233684142000E-06  0.3094938675300000E-06
15 14  0.8234553900205000E-06  0.5614534076803000E-06
15 15  0.5483855036379000E-06  0.7778845972498000E-06
16  0  0.5568468774752000E-06  0.0000000000000000E+00
16 1  0.1155901043386000E-06  0.8252562576241000E-06
16 2  0.1455232836384000E-05  0.7655536060943999E-08
16 3 -0.1942709708201000E-06  0.5233370533750000E-06
16 4  0.6859467527882000E-06  0.3124471706218000E-06
16 5  0.7634235470038000E-06 -0.6484823052482000E-06
16 6  0.7298059787988000E-06 -0.7280845064129000E-06
16 7 -0.2807029184665000E-06 -0.5803995421309000E-06
16 8  0.2371541835754000E-07  0.3200822446054000E-06
16 9 -0.7806834692216000E-06 -0.8233659779883000E-06
16 10  0.2272095517412000E-06  0.3354712725388000E-07
16 11 -0.3314584096685000E-06  0.7721785459232000E-06
16 12 -0.1294178585148000E-05  0.9158598426544000E-06
16 13 -0.1798892359374000E-06 -0.1629978993883000E-06
16 14 -0.6798623260036000E-06  0.1776289464350000E-06
16 15 -0.3647842060825000E-06 -0.1015801269714000E-05
16 16 -0.9053509576662000E-06 -0.9187685473691000E-06
17  0 -0.1033032377079000E-05  0.0000000000000000E+00
17 1  0.5020178791282999E-06  0.7625845795641000E-07
17 2 -0.2907236911258000E-06 -0.8725805383853000E-06
17 3 -0.2677866780764000E-07 -0.5022603110114000E-06
17 4  0.1285124007162000E-05  0.2037544414707000E-05
17 5  0.1906664991077000E-06 -0.6042788350217000E-06
17 6  0.7212384143486000E-06 -0.1245864177999000E-05
17 7 -0.1298780569767000E-05 -0.1556266179770000E-05
17 8 -0.2114678892364000E-06 -0.4704445669377000E-06
17 9  0.3282102231233000E-06  0.1371633648001000E-05
17 10  0.4162833451215000E-06  0.6137247377435000E-06
17 11  0.1143960995483000E-05 -0.2020180647532000E-06
17 12  0.9594798569442999E-06  0.1795612951496000E-06
17 13 -0.3971085666195000E-07 -0.2223042687912000E-06
17 14  0.4031190750696000E-06  0.3045630252523000E-06
17 15 -0.6432551793320001E-07 -0.5045760083796000E-06
17 16 -0.3169703143306000E-06 -0.2515382675329000E-06
17 17 -0.3807502808985000E-06  0.1504679948035000E-05
18  0 -0.5203202341704000E-06  0.0000000000000000E+00
18 1  0.3604173225879000E-06  0.2684021222318000E-07
18 2 -0.3166210357712000E-06 -0.7261168941812000E-06
18 3  0.9952253493596999E-06  0.4326634111994000E-06
18 4 -0.8030581863565999E-06  0.1091322900041000E-05
18 5 -0.5193034706466000E-06  0.7318890417095001E-07
18 6 -0.1701310501861000E-05  0.7339028041973000E-06
18 7 -0.2183149215383000E-06 -0.1133723290137000E-05
18 8  0.4445919007782000E-06  0.2867979845662000E-06
18 9  0.5507257609667000E-06 -0.6374049692545000E-06
18 10  0.3581952846277000E-06 -0.5501068199905000E-06
18 11  0.4212884385516000E-06 -0.1297986993575000E-05
18 12  0.8308590710889000E-06  0.2347558337168000E-06
18 13 -0.1215829909854000E-05 -0.1001742433340000E-06
18 14  0.6111081706316000E-07 -0.1132044127462000E-05
18 15  0.2432047566829000E-06 -0.1084455411480000E-05
18 16  0.8988276193729000E-06 -0.2135843601448000E-06
18 17  0.1230011283458000E-05 -0.4712620316118000E-06
18 18 -0.2096784208053000E-06 -0.2851291268971000E-06
19  0  0.2156541986527000E-06  0.0000000000000000E+00
19 1 -0.5912408328850000E-06  0.1313183580335000E-06
19 2  0.1730008803150000E-06 -0.3717843719683000E-06
19 3 -0.6319748082682000E-06  0.9766090446732001E-06
19 4 -0.9934958817012000E-06 -0.1053905009924000E-05
19 5 -0.2584454660653000E-06  0.1483255316961000E-05
19 6  0.1587014089515000E-06  0.3800674389721000E-06
19 7  0.1223449153407000E-05  0.4911476557839000E-06
19 8  0.6511983727625000E-06  0.8666896842814000E-06
19 9 -0.6538686417493000E-07 -0.4222205962172000E-06
19 10 -0.7824345241326000E-06 -0.2259817634746000E-06
19 11  0.9195582936884000E-08 -0.1752753149117000E-06
19 12 -0.1104477061732000E-06 -0.2871711348871000E-06
19 13  0.7450163211180000E-06  0.2231825813284000E-05
19 14 -0.1260519658987000E-06  0.5399069384814000E-06
19 15  0.8389689628121000E-07  0.8251658912938000E-07
19 16 -0.5516847901813000E-07  0.6894569116894000E-06
19 17 -0.1069020989687000E-05 -0.1868683496162000E-05
19 18  0.1123829488524000E-05 -0.2169384088910000E-07
19 19  0.6020654178029000E-06  0.3653005407075000E-06
20  0  0.3355639656657000E-06  0.0000000000000000E+00
20 1 -0.1970544311750000E-06 -0.3825698166416000E-06
20 2  0.8127981128393000E-06  0.3409855859632000E-08
20 3  0.6352124091652999E-06 -0.2654880587281000E-06
20 4  0.4635524537162000E-06 -0.4888512927536000E-06
20 5  0.2189830468065000E-06 -0.3031447822381000E-06
20 6 -0.1913157321342000E-06  0.3299382300724000E-06
20 7 -0.6759446332018000E-06 -0.7314837197422000E-06
20 8  0.2345663522220000E-06  0.6927162305865000E-07
20 9 -0.3846537851107000E-06  0.1098748049622000E-06
20 10  0.3259808734603000E-06  0.4889630593313000E-07
20 11  0.2453041661976000E-06  0.1129428845618000E-05
20 12  0.1311239889313000E-06 -0.9832348073589001E-06
20 13  0.8304821294612000E-06  0.6176539423643000E-06
20 14 -0.1462271730335000E-06  0.8284182286663001E-07
20 15 -0.3247107016335000E-06  0.9199044900507999E-07
20 16  0.9283494176778000E-06 -0.6115927253582000E-06
20 17  0.7932518110105000E-06 -0.1185053886137000E-05
20 18  0.8449870892086000E-06 -0.3419724055729000E-07
20 19 -0.2172297632024000E-06  0.3051657165119000E-06
20 20 -0.1352351344414000E-06 -0.3587766998843000E-06
21  0 -0.5601530462444000E-07  0.0000000000000000E+00
21 1  0.3775013455695000E-07  0.5530558346156000E-06
21 2 -0.1363840994465000E-05 -0.3909812788410000E-06
21 3  0.3452706656184000E-06 -0.9283226564866000E-06
21 4 -0.7638017431765000E-06  0.7418788912618000E-06
21 5  0.3333197511465000E-06  0.9014903567736000E-07
21 6 -0.6229513596584999E-07 -0.4021928219711000E-06
21 7 -0.3753292896714000E-06  0.6192285007283000E-06
21 8 -0.8113028506499000E-06 -0.3253119920123000E-07
21 9  0.6074582891899000E-07 -0.5416307665317000E-06
21 10  0.4792832131902000E-06 -0.5734862414382000E-07
21 11 -0.3149726227395000E-06 -0.1730808482907000E-06
21 12 -0.2937637952981000E-06  0.4039546950640000E-06
21 13 -0.2713793988633000E-06 -0.1768908824372000E-06
21 14 -0.1590871275005000E-06  0.3486757120171000E-06
21 15 -0.3768365541057000E-06  0.1926589437272000E-06
21 16  0.1135215127086000E-05 -0.2920010877587000E-06
21 17  0.8691421226965000E-06  0.1466774593013000E-05
21 18 -0.1115580975174000E-06 -0.6063956565502000E-06
21 19  0.1872114567965000E-05  0.1488887571475000E-06
21 20 -0.4320976309014000E-06  0.2544083435062000E-05
21 21 -0.3340862485891000E-06  0.3241041207384000E-06
22  0 -0.8413988579040000E-07  0.0000000000000000E+00
22 1 -0.3028743709782000E-06  0.2514722056832000E-06
22 2 -0.3629295860941000E-06 -0.9016562156873001E-07
22 3  0.5907272187266000E-06  0.6582246433504000E-06
22 4  0.3559481803407000E-06  0.7157103897436000E-07
22 5  0.4766977725268000E-06 -0.7716455848880000E-06
22 6 -0.2359559779228000E-06  0.1839132625191000E-06
22 7  0.3693224500266000E-06  0.6640294455759000E-06
22 8  0.1750145226197000E-06 -0.4071334527828000E-06
22 9  0.7384690595961000E-06  0.1188503031999000E-06
22 10 -0.3856758468806000E-06  0.6046469727144000E-06
22 11 -0.3651451890595000E-06 -0.7102521375524000E-06
22 12 -0.2246113823324000E-08  0.4020854859157000E-07
22 13 -0.3394078360335000E-06  0.2015731495971000E-06
22 14 -0.9273064013481000E-06  0.1189026435112000E-05
22 15 -0.2127227049641000E-06 -0.1768888216214000E-06
22 16 -0.6187237163547000E-06  0.4793638535719000E-06
22 17 -0.7096620869850000E-06 -0.7658497532545000E-07
22 18  0.5180168927852000E-06 -0.2667098924996000E-06
22 19 -0.4980985434826000E-06  0.3254205077780000E-06
22 20  0.6666299229910000E-06 -0.5140639026080000E-06
22 21 -0.1686489983606000E-06  0.7623282048102001E-07
22 22  0.3561538006341000E-06  0.6564485057818000E-06
23  0 -0.3854349110367000E-06  0.0000000000000000E+00
23 1  0.2835848557697000E-06 -0.8344223475116000E-06
23 2  0.4572723674444000E-06 -0.8720938592502999E-07
23 3 -0.6957906938590000E-06  0.3190769670380000E-06
23 4  0.4113653619499000E-06 -0.6001303792060000E-06
23 5 -0.2263571837275000E-06  0.7308569414644000E-06
23 6  0.4021641503315000E-06  0.9625298264374001E-07
23 7  0.4154975417177000E-06 -0.7767485136306000E-06
23 8  0.3487621828141000E-06 -0.3505156803730000E-06
23 9  0.1014261761871000E-05  0.7235518838015000E-07
23 10 -0.6990156579489000E-06  0.1724954635354000E-06
23 11  0.2962781083187000E-07  0.1583198772408000E-06
23 12  0.3164176601472000E-06 -0.4733163916690000E-06
23 13 -0.7794624164182000E-06  0.2260851609944000E-06
23 14  0.7523051472487000E-06 -0.4321317806836000E-06
23 15  0.2736392983120000E-06  0.6543447400622000E-07
23 16 -0.5725439287102000E-06  0.2636128455944000E-06
23 17 -0.3306457509363000E-06 -0.3834495762839000E-06
23 18 -0.3368105376799000E-07  0.3045842322068000E-06
23 19 -0.4341603575878000E-08 -0.6097776152564001E-07
23 20 -0.1992463321923000E-07  0.3810315106323000E-06
23 21 -0.5911838391453000E-06  0.3042060395724000E-06
23 22 -0.9859979842436000E-06 -0.4888860956633000E-06
23 23 -0.1061336543167000E-05  0.2494492524304000E-06
24  0  0.3988063935807000E-08  0.0000000000000000E+00
24 1  0.3390357860196000E-06 -0.2729051613390000E-06
24 2  0.4213862499534000E-06  0.3630492818532000E-06
24 3 -0.1046961188395000E-06 -0.9526661197659000E-06
24 4  0.5201636003779000E-06  0.1966555588630000E-06
24 5  0.4707841632169000E-07 -0.1013791448749000E-06
24 6 -0.3801504655482000E-06  0.2973064277223000E-07
24 7  0.3511066306590000E-06  0.1465854331681000E-06
24 8  0.5363245704495000E-06  0.2126544542043000E-06
24 9 -0.6108163114656000E-06 -0.7016148180387000E-07
24 10 -0.4291191401817000E-06  0.1348472116114000E-06
24 11  0.2068834379443000E-06 -0.3809201743305000E-06
24 12  0.1204887160943000E-05 -0.4164202038477000E-07
24 13  0.3326022241845000E-06 -0.3834687162913000E-06
24 14  0.8169109905090000E-06 -0.6480195821361000E-06
24 15 -0.1837410191924000E-06  0.3807267982826000E-06
24 16  0.2619255589503000E-06 -0.2137912931189000E-06
24 17  0.5849849144018000E-06  0.2515746183266000E-06
24 18 -0.9956158465452001E-06 -0.6533578630098000E-06
24 19  0.4641744930111000E-06 -0.6313564427255000E-06
24 20 -0.3492877150011000E-06 -0.1687587980847000E-06
24 21  0.2985475566919000E-06  0.1577315414713000E-06
24 22  0.1207077346808000E-06  0.7238928086069000E-06
24 23 -0.1770884902201000E-07 -0.3568828370141000E-06
24 24  0.9708490892472000E-06 -0.9445605024298000E-06
25  0 -0.2157627731919000E-06  0.0000000000000000E+00
25 1 -0.4856388040531000E-07  0.5291831101904000E-06
25 2 -0.6613672525286001E-06  0.5392093036851000E-07
25 3  0.6743632094208000E-06 -0.1457376533340000E-06
25 4 -0.5790547683489000E-06 -0.7099758064478000E-07
25 5  0.2006104078682000E-06  0.8101649725806000E-06
25 6 -0.2538814472524000E-06  0.3345107800912000E-06
25 7  0.6908628287664000E-06  0.9665421600603001E-06
25 8 -0.9987345180252999E-06  0.9957740972823000E-06
25 9 -0.3555581543462000E-06  0.9835208184021000E-07
25 10 -0.2236262252256000E-07  0.7126223738532000E-06
25 11 -0.2591679012331000E-07 -0.3992648429741000E-06
25 12  0.1279300807189000E-06  0.4432402401650000E-08
25 13  0.3179930217391000E-06  0.2737751383669000E-06
25 14 -0.6398437049510000E-06  0.6848483154801000E-06
25 15  0.1474247625978000E-06  0.3708297712713000E-07
25 16  0.2204859032084000E-06 -0.5942489239211000E-06
25 17  0.3119222474617000E-07 -0.4867913104449000E-06
25 18 -0.8456651347318000E-07  0.1324554159296000E-06
25 19 -0.8187397640482000E-06 -0.1333926039262000E-06
25 20 -0.4565000512420000E-07 -0.4007682727667000E-06
25 21  0.6825370685804000E-06 -0.2907766419210000E-06
25 22 -0.3387079524636000E-06 -0.7880830585410000E-06
25 23  0.9260105607249000E-06 -0.3588209302433000E-06
25 24  0.9225095801575000E-06 -0.3068649575323000E-07
25 25 -0.1316023825422000E-06  0.5601572278260000E-06
26  0  0.2838528820696000E-07  0.0000000000000000E+00
26 1  0.1639368116965000E-06  0.2222361980703000E-06
26 2  0.6585215084411000E-06 -0.1962642584166000E-06
26 3  0.1932742883732000E-06  0.6644729033098000E-06
26 4  0.3465876529104000E-06  0.2447410329004000E-06
26 5  0.6030235707192000E-07 -0.7765543872831000E-06
26 6 -0.5199128985489000E-06 -0.1350507808122000E-06
26 7  0.1153837174372000E-07 -0.4393241740696000E-06
26 8 -0.1142597117025000E-08  0.1521514879846000E-06
26 9  0.5845309982259000E-07  0.7008999582030000E-06
26 10 -0.3097502622239000E-06 -0.1091733750903000E-07
26 11  0.1635520672441000E-06  0.3232893707106000E-06
26 12 -0.4246431706192000E-06 -0.7900885684104000E-06
26 13  0.1321027742268000E-06  0.4266503959386000E-06
26 14 -0.1204940888223000E-06  0.8899425553788000E-07
26 15  0.4412748261233000E-07 -0.2542917180757000E-06
26 16 -0.1028847490042000E-06  0.4005610594559000E-06
26 17 -0.3585022012797000E-06  0.8403048193978000E-07
26 18  0.1051599998089000E-07  0.2997064400510000E-06
26 19 -0.1941251462081000E-06  0.2114147338231000E-06
26 20 -0.2601047035282000E-06  0.6826611589295000E-06
26 21 -0.5301682961808000E-06 -0.5377349108497000E-06
26 22 -0.9320483380382000E-06  0.8594890635593000E-06
26 23  0.1034596829783000E-06 -0.6272981075116001E-07
26 24 -0.7251353937805000E-06 -0.1170025462780000E-07
26 25  0.7446155777078000E-07 -0.3400919081544000E-07
26 26  0.1097205544593000E-06  0.4780005157972000E-06
27  0 -0.6354893248009000E-06  0.0000000000000000E+00
27 1  0.6163218215915000E-06  0.2292784085844000E-07
27 2 -0.2049874130944000E-06 -0.4292159819355000E-06
27 3  0.5601090919160001E-06  0.8739575083383000E-07
27 4 -0.4007106757634000E-06  0.3213615615995000E-06
27 5 -0.6904512953726000E-06  0.1390947408186000E-07
27 6  0.6471908888592000E-08  0.4631880228333000E-06
27 7  0.2573355113809000E-06 -0.3585578701556000E-06
27 8  0.4125817112287000E-07 -0.7588132038466000E-07
27 9 -0.6175781192962000E-06  0.1002280356046000E-06
27 10  0.6556545748341000E-07 -0.6361251808516000E-06
27 11  0.3453489721152000E-06 -0.4384934094149000E-06
27 12 -0.4400972605514000E-06 -0.5205092046095000E-06
27 13  0.2356853551500000E-06 -0.1492510951355000E-06
27 14  0.4592894589504000E-06 -0.7282010538271000E-06
27 15  0.6183221729166001E-07  0.4102767069178000E-06
27 16  0.1513989548449000E-06  0.3910547157999000E-06
27 17  0.1881276380686000E-06  0.6809328654460000E-06
27 18  0.2055169111750000E-06 -0.6787986393806000E-06
27 19  0.6839257916133999E-07 -0.1923196951657000E-06
27 20  0.3941710452714000E-06 -0.5218754795831000E-06
27 21  0.4419587257142000E-06 -0.4587604545604000E-06
27 22  0.7905973895505000E-06  0.8756126245288000E-06
27 23 -0.6487348144463000E-07 -0.6418370231332000E-06
27 24  0.7645913479971000E-06 -0.1642229728074000E-06
27 25 -0.3737194144420000E-06  0.5778007385773000E-06
27 26 -0.4489028511202000E-06 -0.7205925932200000E-06
27 27 -0.4229366485586000E-06 -0.2770413438486000E-06
28  0  0.8388583502332000E-06  0.0000000000000000E+00
28 1  0.3287342207186000E-07  0.7939168474014000E-06
28 2 -0.3379819961973000E-07  0.7104776003991000E-06
28 3 -0.3093671861418000E-06 -0.8397016660569000E-07
28 4 -0.9168663157655000E-06  0.6437135350233999E-07
28 5  0.1480457803945000E-06  0.4894870198350000E-07
28 6  0.4680854037749000E-06  0.3444993709803000E-07
28 7 -0.3764417994417000E-06  0.2630363251730000E-06
28 8 -0.1411201562191000E-06  0.3032989991205000E-07
28 9 -0.4297155126823000E-06 -0.9158050747495000E-07
28 10 -0.3481722843310000E-06 -0.9021904086896000E-06
28 11  0.1869374953010000E-06 -0.4183416475398000E-07
28 12  0.1144245872942000E-06 -0.5158232873247000E-07
28 13  0.3917634934432000E-06 -0.3461176013251000E-06
28 14  0.3618311593690000E-06 -0.2947035198933000E-06
28 15 -0.4414031897155000E-06  0.3429640695279000E-06
28 16 -0.2387373388756000E-06 -0.8449572547391000E-06
28 17 -0.7974907289108999E-07 -0.1888008981786000E-06
28 18 -0.8596666419321001E-07  0.6461396500808000E-06
28 19 -0.1629428450157000E-06 -0.3747715302553000E-07
28 20  0.2799639246857000E-06 -0.5683841634881000E-06
28 21 -0.2575960645511000E-06  0.7203188736965999E-07
28 22 -0.6204561751722000E-06 -0.9251452655116000E-07
28 23 -0.4753327891164000E-08  0.2450157630813000E-06
28 24  0.4065223994296000E-06  0.7530640937698000E-08
28 25  0.4813431046438000E-06 -0.5169273247405000E-06
28 26  0.1334139275699000E-06  0.9086903861923000E-06
28 27 -0.1596244500060000E-06  0.6720821291069000E-06
28 28  0.1338628186879000E-06 -0.4410931799354000E-08
29  0 -0.6023876889110000E-06  0.0000000000000000E+00
29 1 -0.1595924133972000E-06 -0.4383541260670000E-06
29 2 -0.2032714430035000E-06 -0.7004647663099000E-06
29 3 -0.1966887505562000E-06  0.2659326855983000E-06
29 4 -0.3026346878543000E-06  0.1473563762291000E-06
29 5  0.2196221547842000E-06  0.1690098672984000E-07
29 6 -0.1277176534865000E-06 -0.1881096967410000E-06
29 7 -0.1076152266584000E-06 -0.3852912091692000E-06
29 8  0.4441156421365000E-06 -0.2266406747212000E-06
29 9  0.6016040977626000E-07 -0.6360353182361000E-06
29 10  0.6210010355570000E-06  0.3446956857776000E-06
29 11 -0.7844581906921000E-07  0.4354572970624000E-06
29 12 -0.6437497643286000E-06 -0.4918574426522000E-06
29 13  0.3622964526223000E-06  0.3842836747983000E-06
29 14  0.1882963316523000E-07  0.8077075119820000E-06
29 15 -0.1994342966149000E-06  0.6886007689341001E-07
29 16  0.2676204339908000E-06 -0.8701820666891000E-07
29 17 -0.4044409837890000E-06 -0.3072527386670000E-06
29 18 -0.1314915476079000E-06 -0.5160209184662000E-08
29 19  0.1090493918604000E-07 -0.7610506401076000E-07
29 20 -0.6744942851516000E-08  0.3850003697296000E-06
29 21  0.6296757414853000E-07  0.2933474828555000E-06
29 22 -0.2440756453521000E-06 -0.4748914533650000E-06
29 23  0.1576666902395000E-06  0.3299029899577000E-06
29 24  0.1557495556883000E-07  0.3720485428806000E-07
29 25 -0.1393072566200000E-06  0.2249348526861000E-06
29 26  0.2643123606385000E-06 -0.3946832909232000E-06
29 27  0.2061116104045000E-06  0.1912193752487000E-06
29 28 -0.1151639627824000E-06  0.2493313735792000E-06
29 29  0.1842971488579000E-06 -0.1460423370252000E-06
30  0  0.1013269684715000E-06  0.0000000000000000E+00
30 1 -0.2944776928898000E-06 -0.4289874846914000E-08
30 2 -0.2164418250974000E-06 -0.2322850089848000E-06
30 3 -0.3616693949897000E-06  0.3514293886331000E-06
30 4 -0.6226556419774000E-07 -0.2222738608723000E-06
30 5  0.1857909612235000E-06 -0.3126434903215000E-06
30 6  0.2400591312288000E-07  0.3477830140710000E-06
30 7 -0.3448240654337000E-06 -0.3079906167355000E-06
30 8 -0.3853694977927000E-06 -0.3359065898942000E-06
30 9 -0.2676123633992000E-06  0.5051614176505000E-07
30 10 -0.1147811851686000E-06 -0.1008723733952000E-06
30 11  0.7084967611993000E-08 -0.2348245159769000E-06
30 12 -0.2738009973250000E-06  0.2386421527630000E-06
30 13  0.1114356317424000E-06  0.3914484294633000E-06
30 14  0.4997252447677000E-06 -0.2057150217614000E-06
30 15 -0.3408081130509000E-06  0.1659583069822000E-06
30 16  0.2355882502624000E-06 -0.2693549502319000E-06
30 17  0.3276919426247000E-06  0.3503311301762000E-06
30 18  0.2961882842600000E-06  0.3205144149036000E-07
30 19 -0.1617095627818000E-06  0.5729965197466000E-07
30 20 -0.1544564840154000E-06 -0.2555915261613000E-07
30 21 -0.2536387580029000E-06 -0.1951293264038000E-07
30 22 -0.1396912289862000E-07  0.3929143950029000E-06
30 23 -0.4382362337328000E-06  0.1439115758585000E-06
30 24  0.1346206180001000E-06  0.4530023166173000E-07
30 25  0.1578079696857000E-06  0.2461161798999000E-06
30 26  0.5510698001977000E-07 -0.3705444404441000E-06
30 27 -0.1221354417674000E-06  0.3390726773824000E-06
30 28 -0.1378843675090000E-06 -0.6169853198364000E-06
30 29  0.1692699302451000E-06 -0.1404535344584000E-06
30 30 -0.3241854147702000E-06  0.9583010248294000E-06
31  0  0.5429407289600000E-06  0.0000000000000000E+00
31 1  0.8308091979789000E-08 -0.4194906650510000E-06
31 2  0.2467097312025000E-07  0.1260972104999000E-06
31 3 -0.6044261649402001E-07 -0.5413155675582001E-06
31 4  0.4317787713217000E-06  0.2035344647513000E-06
31 5 -0.3994570057516000E-06 -0.1781901911617000E-06
31 6  0.2072054511470000E-06  0.1042428488342000E-06
31 7  0.3603234355187000E-06 -0.2188250378125000E-06
31 8  0.4914167928388000E-06 -0.2652298297601000E-06
31 9 -0.4118556060738000E-06 -0.1281589910389000E-06
31 10  0.7913102970036000E-06 -0.2381477681188000E-06
31 11  0.1324430806189000E-06  0.5000866567417000E-06
31 12 -0.1460144751215000E-06  0.2977386573906000E-06
31 13  0.3453642263366000E-06  0.3608495119558000E-06
31 14  0.5021849469722000E-07  0.1904895916740000E-07
31 15 -0.4042091764866000E-06 -0.1363366018217000E-07
31 16 -0.7267969456863000E-08 -0.3000111097943000E-06
31 17 -0.1497439873996000E-06 -0.1613826200828000E-07
31 18  0.2824598217287000E-06 -0.3654047547181000E-06
31 19 -0.6021189205341000E-08 -0.5144614411481000E-07
31 20 -0.3632279563801000E-07 -0.1572720107746000E-06
31 21 -0.2802218967621000E-06 -0.9610712079973000E-07
31 22  0.2987605138160000E-06 -0.1621741533045000E-07
31 23  0.1086589967556000E-05  0.6208170619963000E-06
31 24  0.1515832446669000E-06 -0.1032474505603000E-06
31 25 -0.6110639813064000E-06 -0.1392287992294000E-06
31 26 -0.3259489037787000E-06 -0.4234177699272000E-06
31 27  0.5471181590597000E-07  0.2454570060639000E-06
31 28  0.5203992208595000E-07 -0.2887009135973000E-06
31 29  0.4403847857811000E-06  0.2540518762935000E-06
31 30  0.1153652693398000E-07  0.1560921988596000E-06
31 31  0.1964888918306000E-06 -0.1928369530339000E-06
32  0 -0.3222769314156000E-06  0.0000000000000000E+00
32 1 -0.2841292850782000E-06  0.2126425709914000E-06
32 2 -0.6314624336119000E-06  0.7127057622529000E-07
32 3  0.9955748710900000E-07 -0.2514266544862000E-06
32 4  0.1716482251655000E-07 -0.1092440649131000E-06
32 5 -0.1748556369750000E-06 -0.5158290055810000E-06
32 6  0.2080852185288000E-06 -0.2757525806566000E-06
32 7 -0.1795790664238000E-06 -0.5347380006403000E-06
32 8  0.3645019136734000E-07  0.6718986698156000E-07
32 9 -0.1149946261290000E-06  0.4224077847474000E-06
32 10  0.1452687064980000E-06  0.1988161880462000E-06
32 11 -0.1224382007544000E-06 -0.1334545043191000E-06
32 12  0.3243087529875000E-06  0.4232172709716000E-07
32 13 -0.9946376713645000E-07 -0.1910900909285000E-06
32 14  0.1849957171453000E-06 -0.2994861808809000E-06
32 15 -0.3710867855502000E-06  0.2813886472051000E-06
32 16 -0.9766728349952000E-07  0.3603631692246000E-07
32 17 -0.4109601611996000E-06 -0.1505502271229000E-06
32 18  0.3958921294529000E-06  0.8567410172085000E-07
32 19  0.1559328862869000E-07  0.2623151559938000E-06
32 20  0.3643406075370000E-06 -0.4295129904125000E-06
32 21  0.3490305434791000E-06  0.1610672280862000E-06
32 22 -0.4523929928257000E-06  0.7176866903497000E-07
32 23  0.1747239030658000E-06 -0.1520797005302000E-06
32 24 -0.1154695773240000E-06  0.1108440894301000E-06
32 25 -0.1127754720691000E-06  0.2467597205377000E-06
32 26  0.5650906071907000E-06  0.6016640190836000E-07
32 27  0.1180748738099000E-06  0.4042412832603000E-06
32 28  0.4269887508678000E-06 -0.1732824718996000E-06
32 29  0.1761155204529000E-06  0.4947000872789999E-06
32 30 -0.3154787117949000E-06 -0.4122794356516000E-06
32 31  0.3430543556987000E-06 -0.2656399749322000E-06
32 32  0.1625301293721000E-06 -0.5423532277159000E-07
33  0  0.1080660913195000E-06  0.0000000000000000E+00
33 1  0.1839969464956000E-06 -0.5460221078240000E-07
33 2  0.6716235295493000E-06 -0.3327491678300000E-06
33 3  0.1018175190295000E-06  0.5823779680372000E-06
33 4  0.1452244549823000E-06  0.1533684765374000E-06
33 5  0.2677974299237000E-06  0.1134924665616000E-06
33 6 -0.2195747194527000E-06 -0.1252730120486000E-06
33 7  0.6033296765679000E-06  0.9718830681296000E-07
33 8  0.2433155201582000E-06  0.3515654147224000E-06
33 9  0.3609429661500000E-06  0.2688684083326000E-06
33 10 -0.2587268143277000E-06  0.1349242481985000E-06
33 11  0.1042398534518000E-06  0.1851026879621000E-06
33 12  0.2836614490395000E-06 -0.1020640199265000E-07
33 13 -0.3837464259266000E-06 -0.2881477316481000E-06
33 14 -0.2706573890703000E-06  0.1484209820001000E-06
33 15 -0.1816150952067000E-06  0.6781927611663000E-06
33 16  0.3840975976528000E-06  0.3059256618062000E-06
33 17  0.2760186356355000E-06 -0.3915572879768000E-06
33 18 -0.3639603646354000E-07 -0.3284045144128000E-06
33 19  0.2814061778541000E-06  0.2569405262688000E-06
33 20  0.5204681881638000E-07 -0.1355689426381000E-06
33 21 -0.6163628740752001E-06 -0.2225031282905000E-08
33 22 -0.3461071948288000E-07 -0.2631198636626000E-06
33 23  0.1106303303293000E-06  0.1069982102002000E-06
33 24 -0.2622213700781000E-06  0.2252779276755000E-06
33 25  0.3254201957310000E-06  0.3520934129204000E-06
33 26  0.3133209420218000E-06  0.3514693495383000E-06
33 27  0.6265757611672000E-07 -0.9350776550479000E-07
33 28 -0.5367603854570000E-06 -0.3955379538611000E-06
33 29 -0.1462707370774000E-06 -0.1435751396910000E-06
33 30 -0.1509023452527000E-06  0.3395907147045000E-06
33 31 -0.2606065642611000E-06  0.2878752788300000E-06
33 32 -0.5048965098689000E-06  0.3822378391585000E-06
33 33  0.1778280100330000E-07  0.6856125721813000E-06
34  0  0.1662057100881000E-07  0.0000000000000000E+00
34 1  0.2821065012875000E-06 -0.2396629569389000E-06
34 2  0.2204672190727000E-06 -0.2464868146389000E-07
34 3 -0.3543455042594000E-06 -0.1093021531004000E-06
34 4  0.1938459680358000E-06 -0.1901829081092000E-06
34 5  0.2081103961935000E-06  0.1196049277104000E-06
34 6  0.2591491255322000E-06  0.1612051392605000E-06
34 7  0.2014931148593000E-06  0.3159912221922000E-06
34 8 -0.3949672745951000E-06  0.2001950091812000E-06
34 9  0.2295088274399000E-06 -0.2046925519282000E-06
34 10  0.4512762918245000E-07 -0.5764393215266000E-06
34 11  0.1507399635983000E-06 -0.3591323248389000E-06
34 12  0.7442324464381000E-07  0.4154527639415000E-06
34 13 -0.4215464861507000E-07  0.1879622903980000E-06
34 14 -0.8440097451284000E-07 -0.1210974990548000E-06
34 15 -0.8229138442029999E-07  0.2660683250576000E-07
34 16  0.2908701747228000E-06 -0.3758669432826000E-06
34 17  0.8247280945706001E-07 -0.1915492492060000E-06
34 18 -0.2303884473931000E-06  0.1471224909289000E-06
34 19 -0.3683028633034000E-06  0.2107959259306000E-06
34 20 -0.2440743330939000E-06 -0.1475170948849000E-06
34 21  0.5249202302693000E-06 -0.1311156822515000E-06
34 22  0.6275975181862000E-06  0.4376258381380000E-07
34 23 -0.4041269597439000E-06 -0.1372984699943000E-06
34 24 -0.8046688639356000E-07 -0.1632044861028000E-06
34 25  0.8336729763418000E-07  0.3311850043852000E-06
34 26 -0.3167051106933000E-06  0.3502434208029000E-07
34 27 -0.1323711570874000E-07 -0.1541228022846000E-06
34 28 -0.1803860183999000E-06  0.3477283031865000E-06
34 29  0.1948847873969000E-06 -0.6094915043044000E-07
34 30 -0.1188716847275000E-06 -0.2414271794828000E-08
34 31  0.3071869210464000E-06  0.5665864639823000E-07
34 32 -0.4041044611496000E-07  0.6825000239826000E-07
34 33 -0.2033474190035000E-06  0.4176211612062000E-06
34 34  0.9467385555257999E-08 -0.4377439802509000E-06
35  0  0.1294157476008000E-06  0.0000000000000000E+00
35 1  0.3086554057424000E-06  0.4722425561689000E-06
35 2 -0.3380260814217000E-06  0.2135759617116000E-06
35 3  0.5052216591629000E-07  0.4762158688309000E-06
35 4  0.2953196810897000E-06 -0.5835591872962000E-06
35 5  0.1019876452789000E-06  0.2022960468139000E-06
35 6 -0.1351139339724000E-06 -0.4573451747716000E-09
35 7 -0.6500062860928000E-08 -0.4507388512864000E-07
35 8  0.6944767111511000E-07  0.4525499206393000E-06
35 9  0.4419138439251000E-06  0.4311313873240000E-07
35 10 -0.4056977743847000E-06 -0.1775731126454000E-06
35 11 -0.3819307015718000E-06  0.1565534095206000E-06
35 12  0.1765795704764000E-06  0.5631540661941000E-07
35 13 -0.3945372738357000E-06 -0.1501915148804000E-06
35 14  0.2866344225008000E-06 -0.2197314919280000E-06
35 15  0.9199886374130000E-07 -0.2931118546423000E-06
35 16  0.2257683983226000E-06  0.4104276699029000E-07
35 17  0.2850589140451000E-06 -0.2566741332079000E-06
35 18 -0.2720255876116000E-06  0.2674261291879000E-06
35 19 -0.4399570707013000E-07  0.1316070127109000E-06
35 20 -0.8596947299686000E-07  0.1614662378837000E-06
35 21  0.5087173003036000E-06  0.1034046695893000E-06
35 22 -0.1871290752328000E-06 -0.5428231080430000E-06
35 23 -0.8658970071531000E-07 -0.3800389909263000E-06
35 24 -0.7476326494822999E-08 -0.1654954803130000E-06
35 25  0.1220324194469000E-07  0.7244749364589000E-09
35 26 -0.2178573461946000E-06 -0.5672950853835000E-06
35 27  0.1127423988124000E-06 -0.6820739107709999E-07
35 28  0.1777234921579000E-06  0.2009755585839000E-06
35 29  0.5295296682553000E-06 -0.8619395687554000E-07
35 30  0.1130184488466000E-06  0.4749787111831000E-06
35 31  0.3097813576985000E-06  0.3156521700849000E-06
35 32 -0.4087286956893000E-06  0.2151636006437000E-06
35 33  0.3073158493664000E-06 -0.1825931087577000E-06
35 34  0.3403341225282000E-06 -0.1478563254306000E-06
35 35 -0.6203465367110001E-07  0.2346813020154000E-06
36  0  0.1673689648373000E-06  0.0000000000000000E+00
36 1 -0.2874990207039000E-06  0.4891904405879000E-06
36 2  0.2366933637332000E-06 -0.1250204736626000E-06
36 3  0.6775034470379000E-06 -0.3721195619645000E-06
36 4 -0.7529493180867001E-07 -0.1308103539562000E-06
36 5 -0.9191920388602000E-08  0.7947916369256000E-07
36 6 -0.3023342973414000E-06  0.1748516634832000E-06
36 7 -0.5141299669464000E-07  0.1442140190434000E-06
36 8 -0.1097192204138000E-08  0.2914127532593000E-06
36 9 -0.1782998611710000E-06 -0.2609773456435000E-06
36 10  0.2938405121821000E-07  0.1117885726865000E-06
36 11  0.1520358618908000E-06  0.5338182756985000E-07
36 12 -0.2117682800021000E-06  0.1617625406345000E-06
36 13 -0.4275959692146000E-06 -0.7612540524276000E-07
36 14  0.7665341420425000E-07 -0.2262910406902000E-06
36 15  0.8665017525518999E-07 -0.1293843982025000E-06
36 16 -0.1613036831417000E-06  0.5457583177682000E-06
36 17 -0.4966626453679000E-06 -0.8876957928123999E-07
36 18 -0.3715362907562000E-07  0.1494799881344000E-06
36 19  0.2861278529271000E-06  0.3612922191606000E-06
36 20 -0.3135114383898000E-06 -0.1742385289436000E-06
36 21  0.4529494367976000E-06 -0.8836926553301000E-07
36 22 -0.8908459947884000E-07  0.1771966212856000E-06
36 23 -0.3182623972626000E-06  0.3556647642344000E-06
36 24  0.4077468165361000E-07  0.9768754807902000E-07
36 25 -0.2646954431562000E-06  0.3414040422845000E-06
36 26  0.8482090126931000E-07  0.5010121731535000E-07
36 27  0.2931225927176000E-06  0.5411312577409000E-06
36 28  0.6808541758678000E-07  0.3116155013078000E-06
36 29 -0.1402865056566000E-06  0.1494371278060000E-06
36 30 -0.1591722792849000E-06  0.1584789606670000E-06
36 31 -0.2119292166904000E-06 -0.3523752100757000E-06
36 32 -0.4629857225876000E-07 -0.2546942708344000E-06
36 33  0.4747888892858000E-06 -0.3681571008868000E-06
36 34 -0.7739158333956999E-07  0.1870020723069000E-06
36 35  0.3162587380234000E-06  0.4571367597214000E-06
36 36  0.2179356273081000E-07  0.2223990789572000E-06
37  0  0.2240647334974000E-06  0.0000000000000000E+00
37 1  0.2418028356733000E-07  0.1054031046883000E-06
37 2 -0.2491243738867000E-06 -0.3779770198660000E-06
37 3 -0.2507622284932000E-06  0.3088987226366000E-06
37 4 -0.3481450750509000E-07  0.5109716406451000E-07
37 5  0.2735378907738000E-06  0.4585339182382000E-06
37 6  0.4355515766902000E-07 -0.1609026504381000E-06
37 7  0.4417718893396000E-06 -0.9969575611141999E-07
37 8 -0.8507668574815000E-07 -0.2517327889946000E-06
37 9 -0.2030296383037000E-06 -0.3347031496565000E-06
37 10  0.8216238404566000E-06 -0.8995288706368000E-07
37 11  0.4091565227312000E-07 -0.1326563156505000E-06
37 12 -0.1244300441056000E-06 -0.1881044582672000E-06
37 13  0.3683091580552000E-07  0.1984146254150000E-06
37 14  0.1921277843642000E-06 -0.4076638093940000E-06
37 15  0.9017654413976000E-07  0.1633031174484000E-06
37 16 -0.1090977799904000E-06  0.3396008102229000E-06
37 17  0.9346521416586000E-07 -0.5714670208079000E-06
37 18  0.1690089998646000E-06  0.4166700755465000E-06
37 19 -0.1975035536043000E-06 -0.2745538630297000E-06
37 20 -0.2318080362582000E-06 -0.1144708894763000E-07
37 21 -0.2041025043978000E-06 -0.4258265732490000E-07
37 22  0.1616340076143000E-07 -0.5243150210186000E-06
37 23  0.2982959634251000E-06  0.4711544408025000E-06
37 24 -0.1714601478945000E-06  0.1126724023083000E-07
37 25 -0.1236437019861000E-06  0.6041610962161001E-07
37 26  0.7375511556537000E-07 -0.1609511601845000E-06
37 27 -0.2266902357234000E-06 -0.3625039467565000E-06
37 28 -0.1788913798745000E-06 -0.4795676722201000E-06
37 29 -0.1115342006756000E-06  0.6815083402399000E-07
37 30 -0.1223527550615000E-06 -0.1523230040136000E-06
37 31 -0.4051039791689000E-07  0.1954208533464000E-06
37 32  0.2210687133452000E-06  0.4124765419974000E-06
37 33  0.1211831918908000E-06  0.2276657683262000E-06
37 34 -0.7494538247979000E-07  0.2918933263722000E-06
37 35  0.3891092936861000E-06  0.1944193194218000E-06
37 36 -0.4645266169684000E-06 -0.1883179026008000E-06
37 37  0.1995524225508000E-06 -0.1140187265913000E-06
38  0  0.4577514360914000E-07  0.0000000000000000E+00
38 1  0.3687995786231000E-07  0.1351248767157000E-06
38 2  0.1327241724532000E-07  0.1956462376072000E-07
38 3 -0.9281060956166000E-07  0.3099833641618000E-06
38 4 -0.5437013765685000E-07  0.2323502053701000E-06
38 5  0.1917500708513000E-06 -0.1000679224796000E-06
38 6  0.4860792451979000E-07  0.2472764121795000E-06
38 7 -0.4463917450865000E-06 -0.4856977854710000E-07
38 8 -0.5542620291098000E-06 -0.4577466595574000E-07
38 9  0.1652814710751000E-06 -0.9083463784574000E-07
38 10  0.1816029955377000E-06  0.4010250655020000E-07
38 11 -0.1322737658996000E-06 -0.5345145328556000E-07
38 12 -0.9611900804580999E-07  0.2141913998438000E-06
38 13 -0.8253773514485001E-07 -0.3283015249755000E-06
38 14  0.8834669350723000E-08  0.1448058692394000E-07
38 15 -0.2938369700484000E-07  0.6511474456669000E-06
38 16  0.3725807117261000E-07 -0.6670327195435000E-07
38 17 -0.4985186630010000E-07 -0.3028301288657000E-06
38 18  0.2743859486018000E-06 -0.6850745538814000E-07
38 19  0.4664537388060000E-06  0.1514304113572000E-06
38 20 -0.2772952175970000E-06  0.1545246231948000E-06
38 21  0.8212569982602000E-07 -0.2711607753457000E-06
38 22 -0.1170430577169000E-06  0.2620462653887000E-06
38 23  0.2061821310336000E-07  0.3162562276376000E-06
38 24  0.7259057271002000E-07 -0.3699510488257000E-06
38 25 -0.5323652253610000E-08  0.2295514540245000E-07
38 26 -0.5653639163521000E-07 -0.3534179589869000E-07
38 27  0.1062331489729000E-06 -0.5970079492566001E-07
38 28  0.2986093234413000E-06  0.1918062434772000E-06
38 29  0.4531367992843000E-07  0.6911527811838000E-07
38 30 -0.4723437654706000E-06 -0.8606665394255000E-08
38 31 -0.6654246026210000E-07  0.2905990012792000E-06
38 32  0.1060058517171000E-06  0.7759788721449999E-07
38 33 -0.1800171803951000E-06 -0.8493862956832001E-07
38 34 -0.1291858730644000E-06 -0.3026654550570000E-06
38 35 -0.5063020197406000E-07 -0.1890935546128000E-06
38 36 -0.3826483319981000E-06  0.2238594150141000E-06
38 37 -0.1664994456532000E-07  0.3153700816992000E-07
38 38 -0.3203381833349000E-06 -0.3033743155962000E-07
39  0 -0.3342836557411000E-06  0.0000000000000000E+00
39 1 -0.1686580591345000E-06 -0.1532990079493000E-06
39 2 -0.1567737308023000E-06 -0.4837597403830000E-07
39 3  0.2371806342143000E-06 -0.3035560232371000E-07
39 4  0.2285139022052000E-07 -0.8435502782087000E-07
39 5 -0.5891641240365000E-08 -0.2264002107462000E-06
39 6  0.1711362958520000E-06 -0.2248847208757000E-06
39 7 -0.6937178950819000E-07  0.1193604688573000E-06
39 8  0.1844409085279000E-06 -0.3147316790741000E-07
39 9 -0.2365603550232000E-07 -0.1390618602086000E-06
39 10 -0.2471394389520000E-06  0.4506526729977000E-07
39 11 -0.2707452249783000E-07  0.2043461722099000E-06
39 12 -0.1167796082095000E-06  0.1627912766958000E-06
39 13  0.1338417167606000E-06  0.1609697196562000E-06
39 14  0.2994093206887000E-06  0.2446929476028000E-06
39 15 -0.7799899068498001E-07 -0.4256603363517000E-06
39 16  0.2304214528162000E-06 -0.4600849241716000E-06
39 17 -0.2439679884163000E-06 -0.1932554909689000E-06
39 18  0.8992165068900999E-07  0.2494061364420000E-06
39 19  0.5203746393232000E-07 -0.2369916361243000E-06
39 20 -0.4820663535491000E-06 -0.7935279605810000E-07
39 21  0.2370104615819000E-06  0.3342695536506000E-07
39 22  0.1532577031817000E-07  0.2824824633646000E-06
39 23  0.3974162246441000E-06  0.5438086877496000E-09
39 24 -0.3114634249608000E-06 -0.3002452583965000E-06
39 25 -0.1642581755315000E-06  0.2157846327737000E-06
39 26  0.8290505295817000E-07 -0.2189558300068000E-06
39 27  0.1441842022333000E-06 -0.8474717685574000E-07
39 28 -0.2407048994230000E-07  0.3635740691436000E-06
39 29 -0.4989864715398000E-07 -0.6578408681804000E-08
39 30  0.1047184701498000E-06 -0.2935025642958000E-06
39 31  0.2867187529296000E-06  0.1920178173094000E-06
39 32  0.3930712350784000E-06 -0.3146963062954000E-08
39 33 -0.2743552386687000E-06 -0.4255120748000000E-08
39 34  0.9443371467064000E-07 -0.1813330955903000E-06
39 35  0.1683232861237000E-06  0.5339805493249000E-06
39 36 -0.3761917093707000E-06  0.4775585449228000E-06
39 37  0.2460984946528000E-06 -0.2769864561055000E-06
39 38 -0.2777034189401000E-06  0.1385293791941000E-06
39 39  0.2165239649380000E-06 -0.1028490402687000E-06
40  0  0.3060250455150000E-07  0.0000000000000000E+00
40 1  0.5298528157970000E-06  0.1077024602300000E-06
40 2 -0.8664029779225000E-07  0.2315032045950000E-06
40 3  0.2473926775120000E-06  0.2165898057138000E-06
40 4 -0.2754106309673000E-06 -0.7992507389762000E-08
40 5 -0.1045194219647000E-06 -0.1910396198266000E-06
40 6 -0.1208697204473000E-06  0.2066136265206000E-06
40 7 -0.2991632964282000E-06 -0.5474776897548000E-07
40 8  0.1158228987420000E-06  0.4598139618760000E-08
40 9 -0.6103879299798000E-07 -0.1655512933745000E-06
40 10  0.1660504278119000E-07  0.2367562772445000E-07
40 11  0.1937705831824000E-07 -0.1919157218001000E-06
40 12  0.1169905553491000E-06 -0.6138591653780000E-07
40 13  0.4872930883421000E-07  0.1101274993514000E-06
40 14 -0.1190373336725000E-07  0.1442257180264000E-06
40 15 -0.1374218469626000E-06 -0.4236497099721000E-06
40 16 -0.1432279587414000E-06 -0.2130245622709000E-06
40 17  0.4485944196320000E-07  0.1887401182973000E-06
40 18 -0.1669342738374000E-06  0.2291634520378000E-06
40 19  0.6314421173719000E-07  0.2498222849621000E-06
40 20 -0.3481290806475000E-07 -0.1888809328288000E-06
40 21  0.3909791326420000E-06 -0.4051582066020000E-07
40 22 -0.1234960454567000E-06 -0.8905575456118000E-07
40 23  0.1394752008886000E-07 -0.6611263618171000E-07
40 24  0.1663888382644000E-06  0.5313362775537000E-07
40 25  0.2787500396705000E-06  0.6972233121727000E-07
40 26 -0.2858054682937000E-06 -0.3669571313198000E-07
40 27 -0.6909769774603000E-07 -0.7597450210569000E-07
40 28 -0.1975547573161000E-06  0.2548841128868000E-06
40 29 -0.1933459947072000E-06 -0.4595943895482000E-07
40 30 -0.6681128574466001E-07 -0.1688060637316000E-06
40 31 -0.2680981735740000E-06 -0.1123294821205000E-06
40 32 -0.3693457491032000E-06 -0.2167669098440000E-06
40 33 -0.5709367398493000E-06 -0.2685095415163000E-06
40 34  0.2145597636417000E-06  0.9898524924157000E-07
40 35 -0.2139764676849000E-06  0.1663489302936000E-06
40 36 -0.9731856109241001E-07 -0.1411799193078000E-06
40 37 -0.1617606729184000E-06  0.8762140907439000E-07
40 38  0.8323217482372000E-07  0.1608258094403000E-06
40 39  0.1060354644455000E-06  0.2570982357160000E-06
40 40 -0.7714477291953000E-08  0.1034047462217000E-07
41  0  0.2820816880742000E-06  0.0000000000000000E+00
41 1 -0.8051566020687000E-07  0.3114556832036000E-07
41 2  0.1118371116933000E-06 -0.1921653533209000E-06
41 3 -0.2985406835907000E-06 -0.1380051221048000E-06
41 4  0.6591634779866999E-07 -0.1917803397595000E-06
41 5  0.3645141182656000E-06 -0.9671623418005000E-07
41 6 -0.5084977864704000E-07  0.6805106498553001E-07
41 7  0.1386277471033000E-06  0.2255086966791000E-06
41 8 -0.1689423139053000E-06 -0.1548137510421000E-06
41 9 -0.9201634506420000E-07 -0.6730847711392000E-07
41 10  0.6029371858965000E-07  0.2498205155906000E-06
41 11  0.2553494703808000E-06  0.2183738154263000E-06
41 12 -0.1546670766856000E-06 -0.3225416884803000E-06
41 13  0.1452620308696000E-07  0.2622885753604000E-07
41 14 -0.2801686070453000E-06  0.2132801751935000E-06
41 15 -0.1758376990562000E-06  0.1497323276250000E-06
41 16  0.4878086946072000E-06  0.1895816358161000E-06
41 17 -0.1133729678413000E-06  0.2619402216857000E-06
41 18 -0.8966226469935001E-08  0.2548915666594000E-08
41 19 -0.1081817891018000E-06 -0.3163795320917000E-06
41 20 -0.2812839213243000E-07 -0.6555689048486000E-07
41 21 -0.8813299545944000E-07  0.5014549708318000E-07
41 22  0.7974991050885999E-07 -0.1995591535219000E-06
41 23  0.5157025081192000E-07  0.1125414854347000E-06
41 24 -0.1078429560224000E-06 -0.3174997628157000E-08
41 25 -0.1945319026338000E-06 -0.1414045701781000E-06
41 26  0.4623240636101000E-07 -0.4204317823042000E-07
41 27  0.3933369496247000E-06 -0.2762180453479000E-06
41 28  0.2928940395012000E-06  0.1334532194938000E-06
41 29  0.1316415910711000E-06 -0.4470520632947000E-06
41 30 -0.1353248048123000E-06 -0.5507125323772000E-07
41 31  0.1134682687780000E-06 -0.6143268658194999E-07
41 32  0.2529517776118000E-07 -0.1352018968977000E-06
41 33 -0.3234363499423000E-07 -0.2559795581699000E-07
41 34  0.2468335384690000E-06  0.1918883727222000E-06
41 35 -0.6180943708714000E-07  0.8413032380200000E-07
41 36  0.1621229096275000E-06  0.7868442660695000E-08
41 37  0.9690977856588999E-07 -0.8596788790362000E-07
41 38 -0.8122090229163000E-07 -0.1210298423278000E-06
41 39  0.2240952490842000E-06 -0.7271476788959000E-07
41 40 -0.9589914700622000E-08 -0.1886000895469000E-06
41 41  0.2814519544431000E-07  0.3164566503141000E-06
42  0  0.1558327511683000E-06  0.0000000000000000E+00
42 1 -0.2102595866413000E-06 -0.1320612641752000E-06
42 2 -0.2783846160847000E-06 -0.3117926196525000E-06
42 3  0.1985878048534000E-06 -0.2165323071085000E-06
42 4  0.3801340667745000E-08  0.1866046248561000E-06
42 5 -0.2901264452359000E-06  0.5074060930631000E-07
42 6 -0.1370909328049000E-06  0.1151779221913000E-06
42 7  0.1302672301760000E-07  0.6116769538936000E-07
42 8 -0.3129649000757000E-07 -0.5010326203470000E-07
42 9  0.6469749656013000E-07 -0.2760972590954000E-07
42 10  0.3908306215499000E-06  0.3530138824814000E-07
42 11 -0.7585410597549000E-07 -0.3997854870686000E-07
42 12  0.1038778826825000E-06 -0.4808557811339000E-07
42 13 -0.9846980844403000E-07 -0.2133886400130000E-06
42 14 -0.7944264385693001E-07  0.1460603066719000E-06
42 15  0.9451039327492000E-07 -0.2043742995550000E-06
42 16 -0.5710078780692000E-07 -0.3210696627448000E-06
42 17  0.1729547162949000E-06 -0.1841828492099000E-06
42 18  0.6852890808859000E-07 -0.1421322727101000E-06
42 19  0.1111853671823000E-06  0.5400220354043000E-07
42 20 -0.3528653715119000E-07  0.2144162340802000E-06
42 21  0.8426802484302000E-07  0.1103392699498000E-06
42 22 -0.3043609508349000E-06 -0.9472064668902000E-07
42 23  0.9493889299313000E-07  0.3012161448765000E-06
42 24  0.1987014670232000E-07 -0.1865284229646000E-06
42 25  0.1515255688332000E-06  0.1172050580809000E-06
42 26  0.1027266843785000E-06 -0.2071940923867000E-07
42 27  0.1285202355761000E-07  0.5317227386425000E-07
42 28 -0.4664549097754000E-07 -0.1024806080910000E-06
42 29 -0.1465318333343000E-06 -0.3885362481899000E-06
42 30  0.4053272158394000E-08  0.6983682551810000E-07
42 31 -0.1629709690357000E-06  0.4807672725794000E-06
42 32 -0.2631582609061000E-06 -0.2791285063717000E-06
42 33  0.4805835188581000E-08 -0.1146541649359000E-06
42 34  0.1637641008683000E-06  0.8235104442779000E-07
42 35  0.2386094016290000E-06 -0.2239620776996000E-06
42 36  0.4152975601476000E-07 -0.8973022348082000E-07
42 37 -0.1747135321494000E-06  0.3798756662557000E-06
42 38 -0.5022621752632000E-07  0.1460882429781000E-06
42 39  0.6546440383346999E-07 -0.4062484704774000E-06
42 40  0.7778193740175000E-07  0.2534251823478000E-06
42 41  0.9002465196290001E-07 -0.1146875641632000E-06
42 42  0.1704472194029000E-06 -0.1781541993289000E-06
43  0 -0.1209650447520000E-06  0.0000000000000000E+00
43 1  0.9937199344703999E-07 -0.2393912209967000E-06
43 2  0.1872198107089000E-06 -0.3214837850512000E-06
43 3 -0.7664379616518000E-07  0.1433050914419000E-06
43 4  0.1355468779154000E-06 -0.3942407544114000E-07
43 5  0.1404547166374000E-06  0.1211291825884000E-06
43 6  0.2259454631933000E-06  0.1153910282689000E-06
43 7 -0.1013610114519000E-06 -0.2259745877997000E-06
43 8 -0.2023567379947000E-06 -0.1672400609020000E-06
43 9  0.1685980571866000E-06  0.1013059702157000E-07
43 10 -0.2118167442846000E-06  0.3030073729696000E-06
43 11 -0.3320308950015000E-06 -0.2787568491937000E-07
43 12 -0.9905551874305000E-07 -0.3750001236805000E-07
43 13  0.5359190289319000E-07 -0.1508085465454000E-06
43 14  0.8494400226723000E-07 -0.1369577411001000E-07
43 15  0.2257526600386000E-06 -0.2621562823126000E-06
43 16 -0.2142395024919000E-06 -0.3140626428603000E-07
43 17 -0.5542355365925000E-06  0.3245498973776000E-06
43 18 -0.2858664130527000E-06 -0.2112206004283000E-06
43 19  0.3870228434463000E-06  0.1163208541349000E-06
43 20  0.6988487759666000E-07 -0.3157902506540000E-07
43 21 -0.2303213916309000E-06 -0.3472126729261000E-06
43 22 -0.2687360203940000E-06 -0.1161523548703000E-06
43 23  0.3736875361938000E-06  0.2824922646612000E-06
43 24 -0.1117561612790000E-06 -0.1228945996786000E-06
43 25  0.2066849938040000E-06 -0.1704320319833000E-06
43 26 -0.7457281534336000E-07  0.2859289730180000E-06
43 27  0.7966550203677000E-07 -0.2824813467383000E-07
43 28 -0.1772378809405000E-06  0.8402306946759000E-07
43 29 -0.1757035746423000E-06  0.3767352902203000E-07
43 30 -0.2687345120915000E-06  0.1391927840733000E-06
43 31  0.1589370621058000E-06 -0.1332738194187000E-06
43 32  0.1799847898869000E-07  0.1196825080455000E-06
43 33  0.1065164889630000E-06  0.1887055835771000E-06
43 34  0.1951439288556000E-06  0.1667889570340000E-06
43 35 -0.9787882091334000E-07 -0.3496083582045000E-06
43 36 -0.9597076778599000E-07  0.1867354626077000E-06
43 37  0.1943858542735000E-06  0.9526372940425000E-07
43 38  0.1043116550169000E-06 -0.1454310809004000E-06
43 39  0.2670172867732000E-06  0.1197808661225000E-07
43 40 -0.1612643413564000E-06  0.1380196207226000E-06
43 41 -0.2422003549432000E-06  0.1350209977220000E-06
43 42  0.7168388683806000E-07  0.2024312664824000E-06
43 43  0.2130079345320000E-08 -0.7116767771385000E-07
44  0  0.2954542292189000E-08  0.0000000000000000E+00
44 1  0.1215144854977000E-06 -0.1175042610323000E-06
44 2 -0.2568992889678000E-07  0.2185316180147000E-06
44 3  0.4516737051407000E-06 -0.5097203684243000E-07
44 4 -0.3091974727967000E-06 -0.1702181695092000E-06
44 5  0.8664095392087000E-07 -0.1362128254626000E-06
44 6 -0.2013580590936000E-06 -0.1967383401208000E-06
44 7  0.4373512613406000E-07 -0.1446052295049000E-06
44 8  0.5396632759552000E-07  0.1422856203448000E-06
44 9 -0.7932445641667000E-07  0.2686434367339000E-06
44 10 -0.2105150743402000E-06 -0.3169275350467000E-06
44 11  0.2856894260827000E-06 -0.4127099885613000E-07
44 12 -0.1787948954662000E-07  0.1269712888329000E-06
44 13  0.6239137434982000E-07  0.1407569644904000E-06
44 14 -0.1820923420498000E-06  0.1397487624996000E-06
44 15  0.6445671220967000E-07  0.1343665404025000E-06
44 16 -0.1665055353813000E-06  0.5062881535370000E-06
44 17 -0.1595894225303000E-07 -0.2159816763910000E-07
44 18  0.1849937865156000E-06 -0.4843042747270000E-07
44 19 -0.3269216106609000E-06  0.7241811497733000E-07
44 20 -0.2391062667127000E-06 -0.2041368161884000E-06
44 21  0.7267203801333001E-07 -0.3275622500613000E-07
44 22  0.1044298606024000E-07  0.1567867961876000E-06
44 23  0.1050599996553000E-06  0.4368441497215000E-07
44 24  0.1007109390873000E-06 -0.1690738148339000E-06
44 25 -0.1755571537434000E-06  0.5920335835888000E-07
44 26 -0.2220062523251000E-06 -0.1101947891735000E-06
44 27 -0.1133731708187000E-06  0.1184561157401000E-06
44 28  0.1398581875779000E-06 -0.5095966025065000E-07
44 29  0.4969610001756000E-07 -0.4265873354933000E-08
44 30  0.2914857745550000E-06 -0.2674843190947000E-06
44 31  0.9710776209359000E-07 -0.4892688813799000E-07
44 32 -0.3317036900901000E-07  0.2489963783105000E-06
44 33 -0.3664895204529000E-06 -0.2567417030006000E-06
44 34 -0.3847176762557000E-07 -0.1722416130992000E-06
44 35 -0.8259965295178000E-07 -0.5413807110452000E-07
44 36  0.3112229332043000E-06  0.1932932601472000E-07
44 37  0.2357800894954000E-06 -0.1661761050882000E-06
44 38 -0.1939571076163000E-06 -0.1464857172105000E-07
44 39 -0.9532787557280000E-07  0.4883465294308000E-07
44 40 -0.9081331694020000E-07  0.1318366247453000E-06
44 41  0.2912292878650000E-06 -0.1305939995667000E-06
44 42 -0.1128058926020000E-06 -0.1821197640907000E-06
44 43 -0.1746907902352000E-06 -0.3266321287996000E-06
44 44  0.2909880098474000E-07 -0.2418156907067000E-07
45  0  0.1115975276415000E-06  0.0000000000000000E+00
45 1 -0.9977305076564000E-07  0.2523289769811000E-06
45 2  0.1784683882140000E-06  0.1470200246451000E-06
45 3 -0.1525272303482000E-06  0.1182240610077000E-06
45 4  0.6339629871833000E-07 -0.4595793582338000E-07
45 5 -0.4608273874028000E-07  0.4540117327841000E-06
45 6 -0.2304765627539000E-06  0.3873313966360000E-07
45 7  0.1306088682878000E-06  0.9953311978441001E-07
45 8 -0.1248626669169000E-06  0.1509246201410000E-06
45 9  0.2819568315636000E-06 -0.2227565415486000E-08
45 10 -0.1178508681889000E-06  0.1563891568266000E-06
45 11  0.1666183669120000E-06  0.4623097613070000E-07
45 12 -0.1490271900688000E-06 -0.8927820757674001E-07
45 13 -0.9600501036463000E-07 -0.3073256393633000E-06
45 14  0.1296912540155000E-06  0.1620992583394000E-06
45 15 -0.2469707891560000E-07 -0.6364231913371000E-07
45 16 -0.1631197869653000E-06 -0.1454154107139000E-06
45 17  0.2073324403483000E-08 -0.8858185913966000E-08
45 18 -0.2550107644190000E-06 -0.2829384184596000E-06
45 19  0.2743815650835000E-06  0.1451892829310000E-06
45 20  0.1376954103586000E-06  0.2315077488505000E-06
45 21  0.1475364784639000E-06 -0.2100064680618000E-07
45 22  0.1552337330882000E-06 -0.6175607645278000E-07
45 23  0.1993483264646000E-06 -0.3183851067477000E-07
45 24  0.8041841010140000E-07 -0.1757787752479000E-07
45 25 -0.4101473991312000E-06 -0.6904320446478001E-07
45 26 -0.1161796761770000E-06 -0.4404295972735000E-07
45 27  0.8823785276608000E-07  0.2358963177560000E-07
45 28 -0.3208174871519000E-07 -0.4987909772993000E-08
45 29  0.9650966626378000E-07 -0.7404088425798000E-07
45 30  0.2178879233093000E-07 -0.1231682264177000E-07
45 31 -0.1279884870479000E-06 -0.7420977151163000E-08
45 32 -0.4280358391157000E-07 -0.6371061412265000E-07
45 33  0.1077330931006000E-06  0.8957276431009000E-07
45 34  0.8107712646748000E-07  0.1850821803482000E-06
45 35  0.2308731746989000E-06  0.8133570090779000E-07
45 36 -0.2179650781658000E-06  0.2082069477858000E-06
45 37  0.6363496201876000E-07 -0.1206519072701000E-07
45 38 -0.1458030118742000E-06  0.8058403640944000E-07
45 39 -0.3050250078346000E-06 -0.7429855102671000E-07
45 40  0.1240940869604000E-06  0.1487711337243000E-06
45 41 -0.8238464332948000E-07 -0.1847784671859000E-07
45 42 -0.2142708467285000E-06  0.1378342220200000E-06
45 43  0.1821479526581000E-06 -0.1963245401803000E-06
45 44  0.3974684186737000E-08  0.1245073409159000E-06
45 45 -0.3086615199930000E-07  0.5816145406159000E-07
46  0 -0.3344757643322000E-06  0.0000000000000000E+00
46 1 -0.9195141516366000E-07 -0.8845329401885000E-07
46 2 -0.6665369555507000E-07  0.2579955137564000E-07
46 3 -0.1282969242263000E-06 -0.3043329425679000E-06
46 4  0.8734407299745000E-07  0.2129221365255000E-06
46 5 -0.1288100504991000E-06 -0.1754656693396000E-06
46 6  0.6403763466874001E-07 -0.9658559044386001E-07
46 7  0.1441678214286000E-06 -0.3348356347557000E-06
46 8  0.1604625281101000E-06  0.5302102733563000E-07
46 9 -0.8238233817064000E-07 -0.4196195333741000E-06
46 10  0.2624706828764000E-08  0.4628254040960000E-07
46 11 -0.2564595476440000E-06  0.2039407117853000E-06
46 12 -0.1243362448284000E-06 -0.1756340694682000E-06
46 13  0.1660847546151000E-06 -0.1840867645433000E-07
46 14  0.1104898272775000E-06 -0.1733557923877000E-06
46 15 -0.1064676629245000E-06 -0.1732255187423000E-06
46 16  0.1870580069417000E-06  0.1390317915942000E-06
46 17  0.1249036849490000E-06  0.6278722632131000E-07
46 18 -0.2029179302020000E-06  0.2179256407722000E-06
46 19  0.4172476261797000E-07  0.3315514108580000E-06
46 20  0.5769487826828000E-07  0.5924549002204000E-07
46 21  0.1073079425880000E-06  0.1451568110474000E-06
46 22 -0.1816848561897000E-08 -0.2480079846010000E-06
46 23  0.1598092018680000E-06  0.2709255546135000E-06
46 24 -0.4172501606199000E-06  0.5228208769788000E-08
46 25 -0.2946028464912000E-07 -0.5835637687824000E-07
46 26  0.9124557139266000E-07 -0.1350201331752000E-06
46 27 -0.1460418171835000E-06 -0.3551046380833000E-08
46 28  0.6818471282444000E-07 -0.1574415407513000E-07
46 29  0.8307889622800001E-07  0.1075460532595000E-06
46 30  0.1102341621238000E-06 -0.1290734887742000E-06
46 31  0.3876725431970000E-07  0.2731556908187000E-08
46 32  0.3577147198297000E-06  0.4374218806817000E-07
46 33 -0.2115188957529000E-06 -0.6907732923579000E-07
46 34  0.1151615752167000E-06  0.2545747081840000E-06
46 35 -0.2192877740680000E-06 -0.7639356071365999E-07
46 36 -0.6356953432754000E-07  0.1902377507272000E-06
46 37 -0.3181043199864000E-07 -0.5762599366109000E-07
46 38 -0.2388306566411000E-06  0.1713509332688000E-06
46 39 -0.7967950721113001E-08 -0.2201947165547000E-06
46 40  0.2617663975058000E-07  0.3381390718149000E-06
46 41 -0.2055750944734000E-06 -0.1305548344854000E-06
46 42  0.8907498893970000E-07 -0.6899113380669000E-09
46 43 -0.4217584625217000E-07 -0.1777529752618000E-07
46 44  0.2113767016250000E-06 -0.5342514832853000E-07
46 45  0.2110100906136000E-06 -0.2832916314222000E-06
46 46  0.3816797250054000E-07 -0.1317497233499000E-06
47  0  0.1576622429568000E-06  0.0000000000000000E+00
47 1  0.3006122230146000E-07  0.5296975174075000E-07
47 2  0.1273533069841000E-06 -0.1571190429384000E-07
47 3  0.1748788343321000E-06  0.1794255750241000E-06
47 4 -0.4938512913330000E-07 -0.5954298748079000E-07
47 5 -0.1112163971859000E-06 -0.6134478851458000E-07
47 6 -0.7109413124618000E-07 -0.8815609859799000E-07
47 7 -0.1891625146442000E-06 -0.4464040772159000E-07
47 8 -0.1274074358122000E-06 -0.2049558872838000E-07
47 9 -0.7266628963267000E-07  0.2066044177508000E-06
47 10  0.2594887350331000E-07  0.4091303604451000E-06
47 11  0.3852318078971000E-07 -0.8112092642347000E-07
47 12  0.1982617660580000E-06  0.7406889465685000E-07
47 13 -0.6708567578062000E-07  0.7623835961595000E-07
47 14 -0.3560371225618000E-07 -0.1175857673581000E-06
47 15  0.4019466168789000E-07  0.3505603595131000E-06
47 16  0.1321478403889000E-06  0.2972644082668000E-06
47 17 -0.1821736329663000E-06 -0.2448123539648000E-06
47 18  0.7853791679460000E-07  0.8571806263955000E-07
47 19  0.1960217436506000E-06  0.2708170693314000E-07
47 20 -0.1408421370913000E-06 -0.9766901218881000E-08
47 21 -0.6652926195382000E-08 -0.9029167458125000E-07
47 22  0.3537171132005000E-07  0.1245770511484000E-07
47 23 -0.1619986694369000E-06  0.2400955892976000E-06
47 24  0.4164557854710000E-07 -0.2889247799648000E-07
47 25  0.4731667674623000E-08 -0.2659748726464000E-07
47 26  0.5687351127674000E-07 -0.1911298611606000E-07
47 27 -0.6343496070528000E-07 -0.2192980437518000E-07
47 28  0.1668665856742000E-07 -0.1839546099943000E-06
47 29 -0.1051032985131000E-06 -0.1031065132092000E-07
47 30 -0.5815773265517000E-07 -0.5169179920872000E-07
47 31  0.6386016094446999E-07 -0.2218680104747000E-06
47 32  0.5255391494607000E-07 -0.1253151747965000E-06
47 33 -0.4595699164890000E-06 -0.1422460123369000E-06
47 34  0.1062076233282000E-07 -0.2475720303903000E-06
47 35 -0.5250094044689000E-07  0.2399813837437000E-08
47 36  0.1084052626030000E-06 -0.1985935084862000E-07
47 37 -0.2188715936695000E-06 -0.1686981840409000E-06
47 38  0.7285764902637000E-07 -0.1420528625656000E-06
47 39  0.2418964638640000E-06 -0.4510313019923000E-07
47 40 -0.1599278847094000E-06  0.1915646568889000E-06
47 41 -0.1538471936459000E-06 -0.2123212219991000E-06
47 42  0.1705944066743000E-07  0.8516358104266000E-07
47 43 -0.5311548097908000E-07  0.7729771089836000E-07
47 44  0.1798845076029000E-06 -0.2592139970366000E-06
47 45  0.7922586358138001E-07  0.1815648985039000E-06
47 46  0.1165293275162000E-06  0.8573164680432000E-07
47 47  0.7097057736945000E-08  0.1585032300695000E-06
48  0  0.1838527952048000E-07  0.0000000000000000E+00
48 1  0.1647344782342000E-06 -0.8195995015824000E-07
48 2 -0.5239654143003000E-07 -0.2897499012625000E-07
48 3 -0.1300896153502000E-06  0.1023889836473000E-07
48 4  0.1038464609837000E-06 -0.2384550492698000E-07
48 5  0.1721024375531000E-08 -0.1412266561985000E-06
48 6  0.9674601601065000E-07  0.5529850348063000E-08
48 7  0.2013551514042000E-06 -0.1628942035875000E-07
48 8  0.6697060820372001E-07  0.1359193020300000E-07
48 9 -0.3268662310904000E-07 -0.1497463876962000E-06
48 10  0.1575372320410000E-06 -0.1716960754173000E-08
48 11  0.8012358284318000E-07 -0.1935766306138000E-06
48 12 -0.2246010887216000E-06  0.1862808439843000E-06
48 13  0.1257370958556000E-06  0.1693410205135000E-06
48 14 -0.4649543692482000E-07 -0.4893188302199000E-07
48 15  0.6948106534355000E-07  0.1617289345851000E-06
48 16 -0.2273558014961000E-06  0.1804715738755000E-07
48 17  0.3419778399923000E-07  0.1803002150669000E-06
48 18  0.2100297346246000E-06  0.1481417691546000E-06
48 19 -0.1732011767250000E-06 -0.1280683506679000E-06
48 20 -0.9377096093547000E-07 -0.1408210354748000E-06
48 21 -0.3052723445454000E-07 -0.4233387783681000E-07
48 22 -0.1482102480180000E-06 -0.1257261922355000E-06
48 23  0.8954513925110001E-07  0.7706643526398999E-07
48 24  0.1610750459837000E-06 -0.2233842338803000E-06
48 25  0.2720821174970000E-06  0.1374151333590000E-06
48 26 -0.3180946910237000E-07 -0.9390077795673000E-07
48 27 -0.2304760231500000E-07 -0.1205831983661000E-06
48 28  0.2469925286463000E-06  0.1066893086918000E-06
48 29  0.2590725939352000E-07 -0.7685255084080000E-07
48 30  0.1933873929698000E-06  0.5418141181615000E-07
48 31  0.8232794121086000E-07  0.7865811760779000E-07
48 32 -0.1594610708531000E-06  0.8520509739641000E-07
48 33 -0.9458962565452001E-07 -0.3734318370962000E-06
48 34  0.7932345259224000E-07  0.1974418090004000E-06
48 35  0.9696106641542000E-07  0.1941854483555000E-06
48 36  0.1577825412379000E-06 -0.1551576016574000E-07
48 37  0.1706995508054000E-06  0.2347964479553000E-06
48 38  0.3451970617088000E-06 -0.1686731645370000E-06
48 39 -0.2244603186705000E-06  0.1370910259226000E-06
48 40 -0.1198378601749000E-06  0.9682400179526000E-08
48 41  0.1492546128385000E-06 -0.3047392718905000E-07
48 42  0.8022865293781999E-07  0.4140393823084000E-07
48 43 -0.5841420525525000E-07 -0.4712569962911000E-07
48 44 -0.1387625003413000E-06 -0.6280270891109000E-07
48 45 -0.9864515354099000E-08  0.1692946064412000E-06
48 46 -0.1360804814353000E-06 -0.2388767434428000E-06
48 47 -0.4904919258170000E-07 -0.1387854865947000E-07
48 48  0.1168355840734000E-06 -0.8152981185560000E-07
49  0  0.3205188462758000E-08  0.0000000000000000E+00
49 1 -0.8937443339273999E-07  0.1839947220972000E-06
49 2 -0.1129406237379000E-06 -0.1133215761173000E-06
49 3  0.7990451640743000E-07  0.1908687706632000E-06
49 4 -0.1757019456729000E-06  0.2220011893843000E-07
49 5 -0.8497880108746000E-09 -0.1592396237037000E-07
49 6 -0.7065205439454001E-07  0.9409724450240000E-07
49 7 -0.5544382730321000E-07  0.1197196759746000E-06
49 8 -0.3068355205153000E-06  0.1032247771153000E-06
49 9  0.5209252684587000E-07  0.1358890785967000E-06
49 10 -0.1441483476297000E-06  0.1425022295097000E-06
49 11 -0.1622000351969000E-07 -0.1348775138673000E-06
49 12 -0.3236516198335000E-07  0.1151073134271000E-06
49 13 -0.2399692744464000E-06 -0.6261844516407999E-07
49 14  0.7653793326199001E-07 -0.3881242748201000E-07
49 15 -0.8369007209097000E-07  0.9699654269549000E-07
49 16  0.9427776739602000E-07  0.7941421339269000E-07
49 17  0.2061648460564000E-06  0.8612770541969001E-07
49 18 -0.1380011273942000E-06  0.1718972836668000E-06
49 19 -0.7048601274935000E-07 -0.7187512541043000E-07
49 20 -0.7114399403860999E-07 -0.7640536744653000E-07
49 21 -0.8999747376897000E-07  0.3437911471493000E-06
49 22 -0.2010780705995000E-06 -0.4698800272498000E-07
49 23  0.3778426542837000E-07 -0.7950502322751001E-07
49 24  0.8388238391257000E-07  0.1626585497839000E-07
49 25 -0.3734948589542000E-06  0.1845605192654000E-06
49 26  0.2361992502291000E-07  0.3225173463319000E-07
49 27  0.7635584851133000E-07  0.2271915082682000E-06
49 28  0.2790250475798000E-07 -0.3072451405659000E-07
49 29 -0.8927503441324001E-07 -0.1823025648347000E-06
49 30  0.2111341724060000E-06  0.2564059594006000E-06
49 31 -0.6019208960809999E-07  0.1977558751231000E-06
49 32 -0.4799128421578000E-07  0.7021615246407000E-07
49 33  0.3920488042089000E-07  0.1073384892639000E-06
49 34  0.1626469703944000E-06  0.1134455155855000E-06
49 35  0.1115032670859000E-06  0.2296853399640000E-06
49 36 -0.1378986033484000E-06 -0.6591180611188000E-07
49 37 -0.2010527256064000E-06 -0.1481157994150000E-06
49 38 -0.3369789707132000E-07 -0.3487930718300000E-06
49 39 -0.1819866803611000E-06 -0.3355809439617000E-07
49 40  0.6591820448599000E-07 -0.1391666642521000E-07
49 41  0.1193268130118000E-06 -0.3075896713143000E-06
49 42  0.7716942848464000E-09 -0.1517187892194000E-06
49 43 -0.1085995505773000E-06 -0.1184205402290000E-06
49 44  0.1818875973805000E-06  0.1906292227879000E-06
49 45  0.3386071430335000E-07 -0.1553227816409000E-09
49 46  0.1203477018249000E-06 -0.5235847520849000E-07
49 47  0.6897024867617000E-07  0.2018935881657000E-06
49 48  0.6956831347332000E-07 -0.8485123671507000E-07
49 49 -0.1088360011472000E-06 -0.4368203011342000E-07
50  0  0.6347352560900000E-08  0.0000000000000000E+00
50 1 -0.4722423896537000E-07 -0.1148424658476000E-06
50 2  0.8506854424218000E-07  0.3878930110236000E-07
50 3  0.1072507914146000E-06  0.5292524738317000E-07
50 4  0.4434818535397000E-07 -0.6432879456213999E-07
50 5 -0.2632962157317000E-06 -0.1788106183421000E-08
50 6  0.3659626349145000E-06 -0.6097627676983000E-07
50 7  0.2080527518645000E-06  0.3308984957207000E-07
50 8  0.1745792605623000E-06 -0.1265156365699000E-06
50 9  0.5914405642412000E-07 -0.2291340963909000E-07
50 10  0.9019918318016000E-07  0.1481568161252000E-07
50 11 -0.4702121662285000E-07 -0.1011167261451000E-06
50 12 -0.5250085638065000E-07  0.9658807903148000E-08
50 13  0.1225404907720000E-06 -0.2090527669412000E-09
50 14  0.1381545238068000E-06  0.7044638694125000E-07
50 15 -0.2015209396856000E-06  0.4934232567975000E-07
50 16  0.3522939311576000E-07 -0.5091610916593000E-08
50 17 -0.1122557518001000E-06 -0.2145780083277000E-06
50 18 -0.8785564397701000E-07 -0.1495307111405000E-06
50 19  0.8973008291801000E-07 -0.1598955618989000E-06
50 20 -0.1577989422556000E-06 -0.6337812544891000E-07
50 21  0.4866128717254000E-07 -0.6117679486968000E-08
50 22  0.2010125477157000E-06 -0.1773953535431000E-07
50 23  0.8732213202445000E-07 -0.9339331440683000E-07
50 24  0.1387504263862000E-06 -0.1051044258056000E-06
50 25  0.1285814649153000E-06  0.4894121982063000E-07
50 26  0.8705080244270000E-07  0.9177702651023001E-07
50 27  0.5816056110946000E-07  0.8556082394439000E-07
50 28 -0.3049037660856000E-07 -0.1915378028547000E-06
50 29 -0.5934814712966000E-07 -0.8892727309072001E-07
50 30 -0.1073794557538000E-06  0.5816658617567000E-07
50 31 -0.2502299345394000E-06 -0.1535441299133000E-06
50 32  0.1114105651124000E-06  0.1785572774791000E-07
50 33 -0.9919312007066000E-07  0.6979002473408000E-07
50 34 -0.6729522317007000E-07 -0.6430715934412999E-07
50 35  0.5340485471202000E-08  0.9841840631587000E-07
50 36 -0.1492991351999000E-06 -0.4464009231123000E-07
50 37  0.2293312504569000E-06  0.7481832609202000E-07
50 38  0.1636679788241000E-06  0.1930463371650000E-06
50 39 -0.1213349138276000E-08  0.6599221424591000E-07
50 40  0.1989450262689000E-06 -0.1222739949718000E-06
50 41  0.5101904174992000E-07  0.1897215377012000E-07
50 42 -0.4174864262903000E-07  0.6612071677904000E-07
50 43  0.2043286159439000E-06  0.2614562726292000E-06
50 44  0.1967590469752000E-06  0.1851814023056000E-06
50 45 -0.2702937483703000E-06  0.3547117099325000E-08
50 46 -0.3077685688309000E-06  0.1006776959492000E-07
50 47 -0.5417698241566000E-08  0.5205205249249000E-07
50 48  0.1196922434390000E-06 -0.3697563252182000E-06
50 49 -0.2463158220725000E-07  0.1629537715955000E-06
50 50  0.2851711671521000E-06  0.5792202769423000E-07
51  0  0.2302493144694000E-07  0.0000000000000000E+00
51 1  0.2541023184232000E-07 -0.5099678963213000E-07
51 2 -0.1882453036736000E-06 -0.2565505853233000E-06
51 3 -0.6435946727608000E-07  0.2298070203350000E-06
51 4  0.2047701223005000E-07  0.8965885927101001E-07
51 5  0.1012608862559000E-06 -0.1167367298673000E-06
51 6  0.8814148703571000E-07 -0.1816425561455000E-06
51 7 -0.8855780260734000E-07  0.1235124712039000E-06
51 8 -0.1406030479632000E-06  0.2599387837251000E-06
51 9  0.2947867762998000E-06  0.1745067314020000E-07
51 10  0.8921662775402999E-07 -0.1209621576844000E-07
51 11  0.1862764363330000E-06 -0.6651134063752000E-07
51 12  0.9400812355940000E-07 -0.1012328108148000E-06
51 13 -0.3170360894494000E-06 -0.1592954590070000E-06
51 14 -0.3964887839509000E-08  0.9911454813734000E-07
51 15 -0.1614857518366000E-06  0.3628964218941000E-06
51 16  0.8974974897707001E-07 -0.1891422537035000E-06
51 17 -0.1373356838995000E-06 -0.4034487284542000E-07
51 18 -0.5502163786957000E-08  0.1580502101745000E-06
51 19  0.1444151564821000E-06  0.2281673428278000E-06
51 20 -0.4156062451726000E-07  0.1291491197751000E-06
51 21  0.2489522114745000E-06 -0.1485087801775000E-06
51 22  0.6664978757950000E-07  0.7542384540072001E-07
51 23 -0.4172158846194000E-08 -0.2048445616385000E-06
51 24 -0.2400897351369000E-07  0.5884538451358000E-08
51 25  0.1273901002731000E-06  0.2769454637471000E-08
51 26 -0.3258030113369000E-07 -0.3768182930540000E-07
51 27 -0.1466548342752000E-06 -0.2976052726249000E-06
51 28  0.1297238001755000E-06 -0.8656344910180000E-09
51 29  0.8366014712676999E-07  0.1193256786872000E-06
51 30  0.1371082800874000E-06  0.2489952167577000E-06
51 31 -0.1396888682352000E-06 -0.7075324542263000E-07
51 32 -0.1025583425080000E-06  0.5925913429911000E-07
51 33 -0.2026757918717000E-06 -0.1050597545469000E-06
51 34  0.1844451509130000E-06  0.5319279153268000E-07
51 35 -0.3287494927479000E-08  0.1520894608601000E-06
51 36  0.6880699840683000E-07 -0.1619308086583000E-06
51 37 -0.3024343908560000E-07 -0.1756715112544000E-06
51 38 -0.5926334441541000E-07 -0.6315465030123000E-07
51 39  0.8228034463879000E-07 -0.3893820977103000E-07
51 40  0.6362190905233000E-08 -0.6415703684052000E-07
51 41 -0.1374040239560000E-06  0.1120334338747000E-06
51 42 -0.5159148688851000E-08 -0.6460652381458000E-07
51 43  0.5663079547225000E-08  0.1672782651203000E-06
51 44 -0.2896230836160000E-06 -0.2210310004454000E-06
51 45 -0.1768821333482000E-06 -0.3488616686207000E-07
51 46  0.1853278408512000E-06  0.6741072074320001E-07
51 47  0.1181358967388000E-06  0.9780199301331000E-07
51 48  0.1565195296068000E-07 -0.1830188493425000E-06
51 49  0.5847730686206000E-07  0.2444085290812000E-06
51 50  0.2682846359437000E-07 -0.2119581578216000E-06
51 51 -0.1184315151974000E-06  0.1762062702605000E-06
52  0  0.2086343723902000E-06  0.0000000000000000E+00
52 1 -0.8835758841682000E-08 -0.3400991909344000E-07
52 2 -0.1716491087654000E-07  0.2082608216292000E-06
52 3 -0.5954550589345000E-07  0.2001202449338000E-07
52 4  0.5414085767877000E-07 -0.1853401244282000E-06
52 5  0.1471672488833000E-06  0.2037158397048000E-06
52 6  0.3967824397329000E-07  0.1724179141620000E-07
52 7  0.4978781498104000E-08  0.8276921147923000E-07
52 8  0.1225558171512000E-06 -0.2463947522420000E-07
52 9 -0.5210024530307000E-07 -0.1481565554907000E-06
52 10 -0.7229342555270000E-07  0.1270614337629000E-06
52 11 -0.1630140985112000E-06 -0.2702136910737000E-06
52 12 -0.6557732752633000E-07  0.3192025317357000E-06
52 13  0.1965867422349000E-06  0.1215766560223000E-06
52 14 -0.2579906779175000E-07  0.2202261995339000E-06
52 15 -0.1201082379461000E-06 -0.2076497759144000E-06
52 16  0.1795288561658000E-06 -0.1033154208428000E-06
52 17  0.1231516152217000E-07  0.1375208215918000E-06
52 18  0.1519599651844000E-06  0.1707775821667000E-07
52 19  0.3025969616422000E-07 -0.3782496585179000E-07
52 20 -0.1027810016421000E-06 -0.2149071305483000E-06
52 21  0.9004054510218000E-08 -0.1031610811938000E-06
52 22 -0.4788144148574000E-07  0.3584770229215000E-08
52 23 -0.1447079720319000E-06 -0.9697045821131001E-07
52 24 -0.7930594420542000E-07  0.1749402862307000E-06
52 25  0.1351736045033000E-06 -0.4955074290920000E-07
52 26 -0.2072238614387000E-06  0.1237612836578000E-06
52 27  0.2789708323495000E-07 -0.7295362945581000E-07
52 28 -0.2211214934324000E-06  0.3950109566936000E-07
52 29  0.1204374981557000E-07  0.1302517899750000E-07
52 30  0.4926154608432000E-07  0.1581583973407000E-06
52 31 -0.5994985752453000E-07  0.4005961673450000E-07
52 32  0.1124884630975000E-06 -0.6025079524162000E-07
52 33 -0.5140370246584000E-07  0.6560643396692000E-07
52 34  0.5809538487580000E-07  0.1329619706312000E-06
52 35 -0.5430660628196000E-07  0.6684533960231000E-07
52 36 -0.4533829518097000E-08 -0.1560854030652000E-06
52 37 -0.1380794152570000E-06 -0.5179731549414000E-07
52 38 -0.1145086617620000E-07 -0.3590232702627000E-07
52 39  0.1737458885059000E-07 -0.1857047054983000E-07
52 40  0.2347659352340000E-06  0.8506509275991000E-07
52 41  0.6590910527251999E-07  0.5901575232445000E-07
52 42  0.3814930341585000E-07  0.8589413211427000E-07
52 43 -0.1129548977057000E-07 -0.6044396638258000E-07
52 44 -0.1063189308675000E-06 -0.2171373331404000E-06
52 45  0.2275845609200000E-06  0.1507118232947000E-06
52 46 -0.1307767841760000E-06  0.3100328713237000E-07
52 47  0.8701762942570999E-07 -0.4728190869919000E-07
52 48 -0.1514246532950000E-06 -0.1610059689229000E-06
52 49 -0.1336727914776000E-06  0.1245658571478000E-06
52 50 -0.7967794245384999E-08  0.1747010060955000E-07
52 51 -0.3165733847252000E-06  0.1333496997163000E-06
52 52  0.1289455117802000E-07  0.4077962892355000E-07
53  0  0.3706041863464000E-07  0.0000000000000000E+00
53 1 -0.1464628942656000E-06  0.2899074194054000E-07
53 2 -0.2334538643657000E-06 -0.2393153711902000E-06
53 3  0.3184301943948000E-07  0.8295151099879000E-07
53 4  0.8146404644250001E-07 -0.1440953615950000E-06
53 5 -0.1008309922514000E-06  0.6893151176631000E-08
53 6  0.2524768944008000E-08  0.4467920654377000E-07
53 7 -0.6117262827722999E-07 -0.1648895183038000E-06
53 8 -0.2100245571880000E-06  0.6502245857845000E-07
53 9  0.1107278666532000E-06 -0.1388399914861000E-08
53 10  0.7778430530875001E-07  0.2113204085540000E-06
53 11  0.3314591201663000E-07 -0.3451506411519000E-07
53 12  0.2295855899675000E-06  0.7984284986621999E-07
53 13 -0.8961307803253000E-07 -0.1032956998067000E-06
53 14  0.1401152069771000E-06 -0.1194775154485000E-06
53 15  0.9064593638071001E-07  0.3884001800590000E-07
53 16 -0.1306514081003000E-06  0.1484415145230000E-06
53 17  0.6779631800626001E-07  0.2723906351148000E-08
53 18 -0.1261824871131000E-06  0.6668480231032000E-07
53 19  0.1017199740532000E-06 -0.3136710675923000E-06
53 20 -0.4807398369392000E-07  0.5831514665675000E-08
53 21  0.1470942873482000E-06  0.6598200188144000E-07
53 22 -0.1419538413917000E-06 -0.3214618548326000E-08
53 23  0.9481578729176000E-07 -0.8050945311249000E-07
53 24  0.9279295428357999E-07 -0.1131848538836000E-06
53 25  0.3143297619615000E-07 -0.1908477624611000E-06
53 26 -0.1218937353428000E-06  0.1653173907514000E-06
53 27  0.4616951949534000E-08 -0.2665067160323000E-07
53 28  0.5789032418530000E-07  0.9004608410154000E-07
53 29 -0.1286371437143000E-07  0.7548851298541001E-07
53 30 -0.1307500378720000E-06 -0.2399868777915000E-06
53 31 -0.9081612894868000E-07  0.2121543203936000E-06
53 32  0.8963315623153000E-07  0.2247718952268000E-07
53 33 -0.4060482986127000E-07  0.7909962229381001E-07
53 34  0.1551509546360000E-06 -0.5399886755767000E-07
53 35 -0.1444491076241000E-06 -0.3358328167234000E-07
53 36 -0.3681465234209000E-07  0.3173426474802000E-07
53 37  0.1049611002171000E-06  0.1537846889258000E-06
53 38  0.6898108508569000E-07  0.5444542316809000E-08
53 39  0.2475094065623000E-06 -0.4628468807636000E-07
53 40 -0.9856884654248000E-07  0.3028273993198000E-06
53 41 -0.1287697963050000E-06  0.7391692710509000E-08
53 42  0.1210874655658000E-06 -0.9719818114478000E-07
53 43 -0.3827001553541000E-07 -0.1139219498148000E-06
53 44  0.4358152192872000E-07  0.9248349816429000E-07
53 45  0.3433451862555000E-07  0.1574421199236000E-06
53 46 -0.6123208444805000E-07 -0.4097094441059000E-07
53 47 -0.4152767283726000E-07 -0.3899738294405000E-07
53 48 -0.1062170720312000E-06  0.4451850490170000E-08
53 49  0.8007506143941000E-07  0.1881699215652000E-06
53 50  0.2269861100501000E-06 -0.3673520680292000E-07
53 51 -0.5318988460324000E-07 -0.5326785480131000E-07
53 52  0.1004402913070000E-06 -0.2298957597778000E-06
53 53 -0.1137306062180000E-06  0.2854613755038000E-09
54  0 -0.2156345519369000E-06  0.0000000000000000E+00
54 1 -0.2573348225626000E-06 -0.1980623097836000E-06
54 2  0.1775328135102000E-06  0.7887064189429000E-07
54 3  0.1576028167027000E-06  0.1020970474696000E-06
54 4 -0.3767104591355000E-07  0.1338370864539000E-06
54 5  0.3342623737889000E-07  0.2854338165631000E-06
54 6  0.1913415063098000E-06  0.1478898543195000E-06
54 7 -0.1849646806608000E-07 -0.1626370620601000E-08
54 8  0.3971747351266000E-07 -0.1140801829168000E-07
54 9  0.1335254576088000E-07  0.2442836002389000E-07
54 10 -0.1234628929432000E-06  0.2924006849381000E-07
54 11 -0.6156933330973999E-07 -0.1861855199656000E-06
54 12  0.9432555790577000E-07  0.1321234736317000E-06
54 13 -0.1744393606512000E-06  0.1716859178586000E-06
54 14  0.1792711704371000E-06  0.3114046070770000E-07
54 15  0.6751090955277000E-07  0.2296912338403000E-07
54 16 -0.1234544057945000E-06 -0.8264387979958000E-07
54 17 -0.7794427076888000E-08  0.4781231113488000E-07
54 18  0.4110512808505000E-07 -0.1630491100469000E-06
54 19 -0.5513402123209000E-08  0.1098779612405000E-06
54 20 -0.2474504417975000E-06  0.1569459354394000E-06
54 21  0.1261794254057000E-06  0.6248964098479000E-07
54 22  0.2836703649771000E-07 -0.1250946101397000E-06
54 23  0.1777665643850000E-07 -0.8454235718599000E-08
54 24 -0.1846198635902000E-06  0.1588370188535000E-08
54 25  0.7816803853466999E-07 -0.3198876918436000E-07
54 26 -0.6996170245954000E-07 -0.9924659712164000E-07
54 27 -0.2202122188923000E-07  0.8728922565242000E-08
54 28 -0.1752793794474000E-06 -0.5142439589399000E-07
54 29  0.3224954865192000E-06 -0.1125426772389000E-06
54 30 -0.8402769074407000E-08  0.5072151232515000E-07
54 31  0.1592858953299000E-06  0.6250483648737000E-07
54 32  0.1665351121940000E-06  0.3243318162433000E-07
54 33 -0.1914795196738000E-06 -0.1168520874585000E-06
54 34 -0.2932608637589000E-07 -0.5134361791548000E-07
54 35 -0.5926769402548000E-07  0.1242381669429000E-06
54 36 -0.2814509334524000E-07  0.2210867426592000E-06
54 37 -0.3781687181315000E-07 -0.1420577929073000E-07
54 38  0.2772560162252000E-06 -0.1521344204318000E-06
54 39 -0.7862991517851000E-07 -0.1151942894985000E-06
54 40 -0.1756886247865000E-06 -0.1239180060130000E-06
54 41  0.2504112994977000E-07 -0.1033633910966000E-06
54 42  0.5952708410917000E-08 -0.5961286740032000E-07
54 43 -0.4217827590004000E-07  0.7438977337859000E-07
54 44 -0.6869136883906000E-07  0.1483043892250000E-06
54 45 -0.5047265281536000E-07 -0.7220362878364000E-07
54 46  0.4787268359614000E-07 -0.3137585583023000E-06
54 47 -0.2969241475817000E-07 -0.1193144465846000E-06
54 48 -0.1805999029295000E-06 -0.2201143167075000E-08
54 49  0.1606544105945000E-07  0.1722973950220000E-06
54 50 -0.6757757671266001E-07 -0.1275637504310000E-06
54 51 -0.2880564723141000E-06  0.3022246554676000E-07
54 52  0.2863615282771000E-08  0.3486723742129000E-07
54 53 -0.1199884276517000E-06  0.3107728589831000E-07
54 54  0.2347077787671000E-07  0.1876468685740000E-06
55  0 -0.1186868220569000E-06  0.0000000000000000E+00
55 1 -0.7218380604131000E-07  0.1617546839319000E-06
55 2 -0.7059318480445999E-07  0.4893019571726000E-08
55 3  0.7158485607362000E-07  0.7289977723148001E-07
55 4 -0.7775838536914000E-07 -0.2257388925817000E-06
55 5 -0.1113370613198000E-06 -0.1294691709147000E-06
55 6 -0.2249659129646000E-06  0.6359494068473999E-07
55 7 -0.2320044013540000E-07 -0.4340128702607000E-07
55 8  0.2412284494807000E-07  0.4195972595934000E-06
55 9  0.1378958711503000E-06  0.1241224483707000E-07
55 10 -0.4351653745735000E-07 -0.4528472430251000E-07
55 11  0.7876111004160000E-08 -0.1151860133140000E-06
55 12 -0.2216566684173000E-08  0.6724969894910000E-08
55 13 -0.8933625622629999E-07 -0.3863097291128000E-07
55 14  0.3423108874290000E-07 -0.4411787899293000E-07
55 15 -0.7981718051061000E-07  0.2552167125444000E-07
55 16 -0.7741661330782000E-07 -0.1469283403964000E-06
55 17  0.9117117311980000E-08 -0.1852918000432000E-06
55 18  0.5964792737924999E-07 -0.6953332803199999E-07
55 19  0.7763790442788000E-07  0.5623939302429000E-07
55 20  0.9089695744886000E-07 -0.9994023047590000E-07
55 21  0.2274112691180000E-06 -0.2412608228628000E-06
55 22 -0.1400993799877000E-06 -0.3524794788842000E-06
55 23  0.2428096647433000E-07 -0.7573415623625999E-07
55 24 -0.4419176148354000E-07 -0.8085567781373001E-07
55 25  0.7653434381512000E-07  0.3044499336407000E-07
55 26 -0.2661453643690000E-07  0.1053715142931000E-06
55 27  0.1393853926854000E-06  0.2455875957530000E-06
55 28  0.2918008122260000E-06 -0.1059215871746000E-07
55 29 -0.1515725394420000E-06 -0.6510161655636001E-07
55 30  0.4458054402574000E-07  0.6645655387185000E-07
55 31  0.5065604207208000E-07 -0.1848799249185000E-07
55 32 -0.9155188278413000E-07 -0.1482625559070000E-06
55 33 -0.9480368408506000E-07 -0.2071034046708000E-06
55 34  0.1364211134687000E-06 -0.2452906466790000E-07
55 35 -0.1426287937647000E-06  0.8856246182847000E-07
55 36 -0.1189460013389000E-06  0.7084911353771000E-08
55 37  0.1394227149692000E-06 -0.9493281818079001E-07
55 38 -0.6345982585725001E-07  0.1118302559760000E-06
55 39 -0.2622776999613000E-06  0.1215618025246000E-06
55 40 -0.8211755456119000E-07 -0.6036654667157000E-07
55 41  0.2086589671990000E-06  0.1125083716155000E-06
55 42 -0.2598541604221000E-06  0.2058773386621000E-07
55 43  0.7029317924922000E-07 -0.7325234937112000E-07
55 44 -0.9257590855164001E-07 -0.7464257635023000E-07
55 45  0.1808187957399000E-06 -0.6153035850456999E-07
55 46 -0.3154631857608000E-08 -0.8128191904630000E-07
55 47  0.3408100542619000E-07  0.2489831985794000E-06
55 48  0.1094282843274000E-06  0.9822542459454001E-07
55 49  0.1421534250676000E-06  0.5921617804633000E-07
55 50 -0.2108081466776000E-07 -0.1549318297046000E-06
55 51  0.4689744395595000E-07 -0.9292860764735000E-07
55 52  0.3885866431344000E-07  0.9458234407800000E-07
55 53 -0.2549936419559000E-07  0.6308698987032000E-07
55 54  0.1751416844081000E-06  0.5815609245596000E-07
55 55 -0.1285037576265000E-06 -0.5058591628999000E-07
56  0  0.2059319595014000E-07  0.0000000000000000E+00
56 1  0.1063977843177000E-08 -0.2843477963351000E-07
56 2  0.6176293106375000E-07  0.6717461491082000E-07
56 3 -0.4822013637223000E-07 -0.1994985931728000E-06
56 4 -0.1192065040559000E-06 -0.2541505305313000E-06
56 5 -0.1259117033005000E-06  0.1689463303491000E-06
56 6  0.3607091964779000E-07  0.2375207739934000E-07
56 7  0.1083016325975000E-06  0.2054640467415000E-06
56 8 -0.9704210163631001E-08  0.4409925973922000E-07
56 9 -0.8353074861321000E-07 -0.2246696287252000E-06
56 10 -0.1313238620208000E-06  0.8506466813467999E-08
56 11  0.1418619103592000E-06  0.5996121982921999E-07
56 12  0.2428265819713000E-07  0.1646811086541000E-07
56 13 -0.1029006767323000E-06 -0.1872817107208000E-07
56 14  0.2964427820559000E-06  0.5685058569219000E-07
56 15 -0.8462401883484000E-07 -0.5395991844254000E-07
56 16 -0.6077847733149000E-07 -0.3385488357733000E-07
56 17  0.5072800784719000E-07  0.1380425585727000E-06
56 18 -0.4752816135656000E-07 -0.5003442280450000E-07
56 19  0.6251858554502000E-09 -0.5276588838181000E-07
56 20 -0.1741407255115000E-07  0.7043785527663000E-07
56 21 -0.1946708145700000E-06 -0.6619506749849000E-07
56 22  0.4535182626010000E-07  0.1333645625184000E-06
56 23 -0.1414879518401000E-06  0.2714189136825000E-06
56 24  0.7589494050913000E-07  0.7257393967772000E-07
56 25  0.2314803458160000E-07 -0.1421627711649000E-06
56 26  0.3263158232273000E-07 -0.6122127562405000E-07
56 27  0.1300007931702000E-06 -0.9821858535453000E-07
56 28 -0.1974561659932000E-06 -0.1721421662511000E-06
56 29 -0.1213739291821000E-06 -0.5236633324579000E-08
56 30  0.2277472198372000E-06  0.1825482268182000E-06
56 31 -0.2691225714825000E-06 -0.1125275359119000E-06
56 32 -0.5046349985014000E-07 -0.2154102736250000E-07
56 33  0.6542001048022000E-08  0.1645399743871000E-06
56 34 -0.6843555616011999E-07  0.6918944909414000E-07
56 35 -0.1084853997874000E-06 -0.6868334483563000E-07
56 36  0.6098665551658000E-07 -0.1632882569731000E-06
56 37 -0.3444727102310000E-08  0.1146036378423000E-07
56 38 -0.4984120381424000E-08  0.1394655084128000E-06
56 39  0.4750633964052000E-07  0.9787534053528001E-07
56 40  0.1076204639137000E-06 -0.5926067643899000E-08
56 41 -0.3710878382429000E-07 -0.1964862192094000E-07
56 42 -0.1956475670964000E-06  0.1507810332397000E-06
56 43  0.1942753721465000E-06  0.1379080498718000E-06
56 44  0.1349635968539000E-06  0.1135550613299000E-06
56 45  0.1069879685522000E-06 -0.5339200919486000E-07
56 46 -0.2098209337338000E-06 -0.2505821248378000E-07
56 47 -0.5235457502079000E-07  0.1024475471004000E-06
56 48 -0.1570610264108000E-06 -0.7111654581319000E-07
56 49  0.2923425576143000E-07 -0.1505349793324000E-06
56 50 -0.2089146063484000E-06  0.2949840637545000E-07
56 51 -0.1836592931376000E-07  0.2045120382877000E-06
56 52  0.6305354509909000E-07 -0.1404135194094000E-07
56 53  0.1024507578247000E-06 -0.1104880751956000E-06
56 54  0.5652199503107000E-09 -0.2123331297580000E-07
56 55 -0.1697986845243000E-06  0.2983177524631000E-07
56 56  0.1360834911030000E-06 -0.3277963155484000E-07
57  0  0.2832317497126000E-07  0.0000000000000000E+00
57 1  0.9451033949081000E-08  0.7371262633653000E-07
57 2  0.1393763738023000E-06 -0.2595168410310000E-07
57 3 -0.5497621712693000E-07 -0.1885497965190000E-06
57 4 -0.7829547701159000E-07  0.1584067514865000E-06
57 5 -0.8977232616957000E-08 -0.7061789136389000E-08
57 6  0.3354495503657000E-07  0.3729286981302000E-07
57 7 -0.1816432239552000E-06  0.1860935101436000E-07
57 8  0.1501740676181000E-06 -0.1336426725775000E-06
57 9 -0.9968544615038000E-07 -0.3219926004370000E-07
57 10  0.5746192474240000E-07  0.1903246798572000E-07
57 11  0.4731139237852000E-07 -0.1158044188715000E-06
57 12 -0.6492189146674999E-07 -0.6818765310870000E-07
57 13 -0.5697149756092000E-08 -0.1581779087296000E-06
57 14 -0.6139808813520000E-07 -0.1645155238608000E-06
57 15 -0.2070385884170000E-06 -0.3186045194675000E-07
57 16 -0.5188453796343000E-07 -0.4041530592601000E-07
57 17 -0.7891153229610000E-07  0.8200228110960000E-07
57 18  0.1492479346851000E-06 -0.1248351156075000E-06
57 19  0.1159463547486000E-06  0.1058165550331000E-06
57 20 -0.1132823119813000E-06  0.3164607987879000E-08
57 21 -0.2080755337723000E-07  0.1819517981758000E-06
57 22 -0.4669733311607000E-07  0.4347619501033000E-07
57 23  0.8252716592721000E-07  0.6192699357637000E-07
57 24  0.1127325117764000E-06 -0.1214471006992000E-06
57 25 -0.3907036991146000E-07 -0.6368889271409999E-07
57 26  0.1469870459292000E-07  0.1047089170594000E-06
57 27 -0.1487841025593000E-06  0.4082546140083000E-07
57 28 -0.2991326252298000E-07 -0.1298933036287000E-06
57 29  0.6668179127350000E-07  0.1543728941366000E-06
57 30 -0.1731719004656000E-07 -0.6371814282931000E-07
57 31 -0.1440581956328000E-06 -0.6325044251435000E-07
57 32  0.1834811372801000E-06 -0.9254293939810001E-07
57 33  0.5343576396612000E-07  0.4421145697692000E-07
57 34 -0.4605141987878000E-07  0.6134246408990000E-08
57 35 -0.3356068535058000E-07  0.2217957305213000E-07
57 36 -0.3552766241197000E-07 -0.6579361658295999E-07
57 37 -0.7082517582005000E-08  0.9094807795560999E-08
57 38  0.2774048689385000E-07 -0.1606528370955000E-06
57 39 -0.1237901839455000E-06  0.4128168121951000E-07
57 40 -0.2311225203986000E-06 -0.1604674174499000E-06
57 41 -0.6815674224621999E-07 -0.4101497521551000E-07
57 42  0.2437842827707000E-07 -0.1385086534107000E-06
57 43  0.7486817139977000E-07 -0.9722273237431000E-07
57 44 -0.2508406451542000E-06 -0.7754163790183000E-07
57 45  0.6498543988048000E-08 -0.3064836709478000E-07
57 46 -0.3287663186847000E-07 -0.1210013539994000E-06
57 47  0.4710869155309000E-07  0.7471159732759000E-07
57 48  0.5150560826129000E-07  0.7149445752700000E-08
57 49  0.2539391550483000E-06 -0.5891449087201000E-07
57 50 -0.2281380237074000E-06  0.1254290342096000E-06
57 51 -0.9631315008682999E-07 -0.7222662250753000E-07
57 52 -0.9422490831369001E-07 -0.2891579140063000E-06
57 53 -0.7131853960292000E-07 -0.2451622938867000E-07
57 54 -0.3813140538396000E-07  0.6604198899258000E-08
57 55 -0.3605192260105000E-07  0.1534314337409000E-06
57 56  0.1097329920729000E-06  0.7198294264660000E-07
57 57 -0.3803115196389000E-07  0.2315894709935000E-06
58  0  0.8512737152099000E-07  0.0000000000000000E+00
58 1  0.1372243039910000E-06 -0.1771362858198000E-06
58 2  0.6292688142883000E-07 -0.2328165088118000E-06
58 3 -0.1163785891825000E-06  0.7001422706515000E-07
58 4  0.1589941232373000E-06 -0.1409465422435000E-07
58 5  0.1995645648927000E-06  0.9300943062049000E-07
58 6 -0.3664893256888000E-07  0.1001413335273000E-06
58 7  0.1396052861856000E-06 -0.8534245828083001E-07
58 8 -0.1888136577432000E-06 -0.1459001979058000E-06
58 9  0.1509490383274000E-07 -0.1502305703476000E-06
58 10 -0.9707191119458000E-08  0.4991256097993000E-07
58 11 -0.3407607262501000E-07 -0.1700687949046000E-07
58 12 -0.3470871106297000E-07  0.8275376941092001E-07
58 13 -0.2045094391027000E-06  0.1061022083891000E-06
58 14  0.4922328848647000E-07  0.2612240653133000E-06
58 15 -0.3870728215974000E-07 -0.1412806902529000E-06
58 16  0.5877890171441000E-07 -0.2358841166186000E-07
58 17 -0.1019339400464000E-06 -0.3343614078462000E-07
58 18  0.1516740733810000E-06 -0.2784369708895000E-07
58 19 -0.1288423770662000E-06  0.5785551143759000E-07
58 20 -0.4619872395285000E-07  0.7048935326844000E-07
58 21 -0.2477623174394000E-08 -0.1896642865842000E-07
58 22  0.1008792693428000E-06 -0.1148145488890000E-06
58 23 -0.5198879258244000E-07 -0.2583320624024000E-07
58 24 -0.9868549168462000E-07 -0.2091089657148000E-06
58 25 -0.7982391335639999E-07  0.1776180906512000E-06
58 26  0.1030505928119000E-06  0.1121196036932000E-06
58 27 -0.3528762800520000E-07 -0.6692884577335000E-07
58 28  0.6606398975165000E-08 -0.1486999154466000E-07
58 29 -0.4237578948552000E-07  0.7918426172453000E-08
58 30 -0.2092613963864000E-07  0.6510972676814000E-07
58 31  0.3675663717727000E-07  0.4995062866629000E-07
58 32 -0.2773810144349000E-07 -0.1065490607916000E-06
58 33 -0.4056131801447000E-07 -0.4437902309616000E-08
58 34 -0.5190228906372000E-07 -0.7520534611190000E-07
58 35  0.4449613968315000E-07 -0.4365333913912000E-07
58 36  0.4468730323680000E-07  0.1156803723568000E-06
58 37  0.1726568354146000E-06 -0.2489399014014000E-07
58 38  0.3933681919340000E-08 -0.4343513032483000E-07
58 39  0.4883246028410000E-07  0.1872073478906000E-06
58 40 -0.4394864779898000E-07 -0.2074786122244000E-07
58 41  0.1058859994251000E-08  0.3817607446770000E-07
58 42  0.8744813203678000E-07  0.2083489335898000E-06
58 43 -0.1254945370924000E-06 -0.1426700649986000E-06
58 44  0.5861857754838000E-07 -0.3833323601489000E-08
58 45  0.2740861389125000E-06  0.1962314189255000E-06
58 46  0.3569460737521000E-07 -0.7267753448747000E-07
58 47  0.3716662057821000E-07  0.5540616390604000E-07
58 48  0.5449663081235000E-07 -0.2163872956109000E-06
58 49 -0.3371316852187000E-08 -0.2077023434568000E-06
58 50  0.4058783372882000E-08  0.8006624249783000E-07
58 51  0.7510061962578000E-07 -0.1521187447024000E-06
58 52  0.9045495962112000E-07  0.5805722638015000E-07
58 53  0.1726638969883000E-06  0.1409975974399000E-06
58 54 -0.4463720099873000E-07  0.1065480338441000E-07
58 55 -0.5213019424001000E-07  0.1267953432674000E-06
58 56 -0.1012868579181000E-06 -0.1731492491235000E-06
58 57 -0.1963271517303000E-06 -0.1504960099406000E-06
58 58  0.7079604413128000E-07 -0.3775375024288000E-07
59  0  0.8267950888578000E-07  0.0000000000000000E+00
59 1 -0.2066229257823000E-06 -0.2424083966403000E-07
59 2 -0.9410936283904999E-07  0.1155404152034000E-06
59 3 -0.8245920913554000E-07  0.3914891512934000E-07
59 4  0.5901910015423000E-07 -0.2326280463303000E-07
59 5 -0.2813096447707000E-06 -0.5056189259948000E-08
59 6  0.3180270005082000E-07 -0.5985436664651000E-07
59 7 -0.2208953917524000E-06  0.5952672302133000E-07
59 8  0.1405004581827000E-06  0.2250129953399000E-06
59 9  0.1697241931090000E-07  0.1292943567822000E-06
59 10 -0.8750918684316000E-07  0.9114163684095000E-08
59 11  0.1188873225644000E-06  0.3896076536028000E-07
59 12 -0.2047367823852000E-06  0.4986070094085000E-07
59 13 -0.9861477792013000E-07 -0.1293358240257000E-06
59 14  0.1613002614852000E-06 -0.4523045884925000E-07
59 15 -0.1834765194677000E-06 -0.1996267858392000E-06
59 16  0.1246495923671000E-06  0.1712366037837000E-06
59 17 -0.2588473029582000E-07  0.1748172023296000E-06
59 18  0.1206626897957000E-07 -0.3036480351408000E-07
59 19  0.2631198300892000E-07 -0.4705748450989000E-07
59 20 -0.3066816472310000E-07  0.5011618844074000E-07
59 21  0.7576630832130999E-07  0.1361004050555000E-06
59 22  0.1218575852163000E-07 -0.1537300124443000E-06
59 23 -0.2351880296443000E-07  0.2797314124297000E-07
59 24 -0.6413555311649000E-07  0.1869214672378000E-06
59 25  0.5522094511987000E-07 -0.7982052513800000E-08
59 26  0.1279187148495000E-07 -0.9086537816550000E-07
59 27  0.6052240176476000E-08  0.6602839746777000E-07
59 28 -0.4232115650325000E-07  0.1931780655741000E-07
59 29 -0.7406788504037001E-07  0.1256445862311000E-06
59 30  0.4858766602661000E-07 -0.1725834700637000E-06
59 31 -0.1672296021566000E-06  0.1281206059756000E-07
59 32 -0.5564951221294000E-07  0.3756390200845000E-07
59 33  0.2839517753423000E-06  0.5871004649867000E-07
59 34  0.1973877451508000E-07  0.3840688441861000E-07
59 35  0.7446294133876000E-07  0.1856610006281000E-08
59 36  0.1083543828493000E-06  0.2757186496862000E-06
59 37 -0.1885582633591000E-06 -0.1917535540610000E-06
59 38 -0.2026297151866000E-07  0.8655989112195000E-07
59 39 -0.7356300431252000E-07  0.8118308353103000E-07
59 40 -0.1298276310945000E-06 -0.2311098854851000E-06
59 41  0.1315726736844000E-06  0.2906360019207000E-08
59 42  0.4577090308277000E-07 -0.3006762139400000E-07
59 43  0.9529630387170000E-07  0.4158525788214000E-07
59 44  0.1630469616023000E-06  0.5208586022422000E-08
59 45 -0.3839133413167000E-07  0.1464812173176000E-06
59 46 -0.1627403763482000E-06 -0.2028182636981000E-06
59 47  0.3538372669608000E-08  0.7358116992938999E-07
59 48  0.3858136587779000E-07 -0.8649792630173000E-07
59 49  0.1836034082156000E-07  0.1422660266383000E-06
59 50 -0.1919148465684000E-06  0.9799044030249000E-07
59 51  0.1305940780930000E-06 -0.2712465385931000E-07
59 52  0.6216801135427000E-08  0.2220714525211000E-07
59 53 -0.1045065304667000E-06 -0.1229594294599000E-06
59 54  0.6158531042622000E-07  0.3806449973453000E-07
59 55  0.1541853053743000E-06 -0.1797583136359000E-07
59 56  0.7893499129814000E-07 -0.5581574533533000E-07
59 57  0.3582734338967000E-07  0.1374846800279000E-07
59 58  0.1846352432683000E-06 -0.6300489788541000E-07
59 59  0.9338195826129000E-07  0.7910327629815000E-07
60  0  0.2039878886334000E-08  0.0000000000000000E+00
60 1  0.6767748297436000E-07 -0.3637937231723000E-07
60 2  0.1688296622996000E-06 -0.7500030808752000E-07
60 3  0.3086474736983000E-07  0.6407576814471000E-07
60 4  0.4262349156173000E-07 -0.5790580186318000E-07
60 5  0.8461996459388000E-07  0.1703245803818000E-06
60 6 -0.3750207411398000E-07  0.3624282600187000E-07
60 7  0.9983848860719000E-07 -0.9772704706855000E-07
60 8 -0.8008582793113001E-07 -0.2699607247536000E-06
60 9 -0.1265012705310000E-06 -0.3041309321351000E-06
60 10  0.5240354843663000E-07 -0.2816538017944000E-07
60 11 -0.2396869395318000E-06 -0.1148787493511000E-06
60 12 -0.7677388826617001E-07 -0.1186865619009000E-06
60 13  0.8817147087109001E-07 -0.7572629297116000E-07
60 14  0.4374755819443000E-07  0.1307702218034000E-06
60 15  0.2608160365959000E-07  0.1451042094300000E-06
60 16  0.1488592498907000E-07  0.1133202277287000E-07
60 17 -0.1516181388744000E-06 -0.7536602634011000E-07
60 18  0.1764168653025000E-06 -0.2150502720912000E-07
60 19  0.5581830767735000E-08 -0.3173166730548000E-07
60 20  0.5501719729648000E-07 -0.1244961699774000E-07
60 21 -0.1535318001167000E-06  0.3929477383326000E-07
60 22 -0.6733122443683001E-07  0.9908259895738000E-08
60 23  0.1483412218364000E-07  0.1160945624576000E-06
60 24 -0.1719015416684000E-07 -0.6701114135547999E-07
60 25  0.1823838203360000E-07 -0.1182173290144000E-06
60 26 -0.5790470976524000E-07 -0.2189001552475000E-07
60 27 -0.1150474972170000E-06 -0.1452729123698000E-06
60 28 -0.6502121026801000E-07 -0.6840570589764999E-07
60 29  0.1246633381401000E-08  0.5772350106714000E-07
60 30  0.6439109557352000E-07  0.4321108358553000E-07
60 31 -0.6997162730635000E-07  0.8560586837082000E-07
60 32  0.6161392202918000E-08  0.6836105638262001E-07
60 33  0.5662400878369000E-07 -0.1418872635520000E-06
60 34 -0.8235074774411000E-07  0.3596895990805000E-07
60 35  0.4442510839071000E-07  0.6641077781677001E-07
60 36 -0.2498759715187000E-07 -0.1114344034154000E-06
60 37 -0.1342526875269000E-06 -0.1237854087550000E-06
60 38 -0.7025446328322000E-07 -0.4926680478754000E-07
60 39 -0.5799470169240000E-07 -0.7326879157298001E-07
60 40  0.2933491578933000E-07  0.3021365546147000E-07
60 41  0.1509338965223000E-06  0.1021103126273000E-07
60 42 -0.1015071944083000E-06  0.3056113254026000E-07
60 43 -0.9261545548924001E-07 -0.1066460994888000E-07
60 44 -0.7133511894388000E-07  0.1114033330630000E-06
60 45 -0.2177308261894000E-06 -0.4896427706641000E-07
60 46 -0.1572133191365000E-07 -0.4400800566084000E-07
60 47  0.1822275455981000E-07  0.2611874982270000E-07
60 48  0.7221411990652000E-07 -0.3730807066039000E-08
60 49 -0.1592617868804000E-07  0.1277761211871000E-06
60 50 -0.6407039499311000E-07 -0.8396101988219000E-07
60 51  0.4693117452304000E-07 -0.7563206886484000E-07
60 52 -0.1270349731060000E-06 -0.6802571985207000E-07
60 53 -0.1138616721449000E-06 -0.2480746858232000E-07
60 54  0.1733779904805000E-06  0.6077033588006000E-07
60 55 -0.5423687741958000E-07 -0.5679194486188000E-07
60 56 -0.1970798962013000E-06  0.2373910771738000E-07
60 57 -0.1713650557938000E-06 -0.3879991192106000E-07
60 58  0.1923533977873000E-07  0.6562974864358000E-07
60 59 -0.1539615072596000E-06 -0.5384648877047000E-07
60 60 -0.1359965088551000E-06 -0.1107419717404000E-07
61  0  0.1063001430732000E-06  0.0000000000000000E+00
61 1  0.3203878825311000E-07  0.9042573349128000E-07
61 2  0.4724128841562000E-07  0.1688935277622000E-06
61 3 -0.1363701790591000E-07  0.4314708025550000E-07
61 4  0.7009137642144000E-08 -0.6719257282490000E-08
61 5 -0.1372732301667000E-06 -0.3633699349527000E-07
61 6  0.1794431876970000E-06 -0.9761142278257000E-07
61 7 -0.4536515201624000E-07  0.1969357336799000E-06
61 8 -0.3146379076755000E-07  0.8479777984923000E-07
61 9  0.6346099431193000E-07  0.1500682660763000E-06
61 10 -0.6719788613599000E-07 -0.8733020302618000E-07
61 11  0.1153160118456000E-06  0.1076518085057000E-07
61 12  0.5177016905562000E-07  0.9112488941573999E-07
61 13 -0.4254999409310000E-07 -0.4416140931132000E-07
61 14 -0.1214499274643000E-07  0.9128207195613000E-07
61 15 -0.6486123013965001E-07 -0.8815391038582999E-07
61 16  0.1258485764829000E-06 -0.1462786518249000E-06
61 17  0.2560345873799000E-07  0.4988255211400000E-07
61 18 -0.6117035665156000E-07 -0.1399334868739000E-06
61 19 -0.6262608015319000E-07  0.1409127020098000E-06
61 20 -0.2494945948505000E-06  0.1354697850690000E-06
61 21  0.3850999370587000E-07  0.3840630696895000E-08
61 22 -0.1405963987513000E-06  0.2471621738418000E-07
61 23  0.7459640187964000E-07  0.7411930354442999E-07
61 24  0.2952667900557000E-07 -0.1803432665433000E-06
61 25 -0.2086307798660000E-08  0.1583662016293000E-06
61 26 -0.2457398427285000E-07 -0.3359868867634000E-07
61 27  0.2770402384455000E-06  0.3511531983108000E-07
61 28 -0.7942949729582000E-07  0.9974992697280000E-07
61 29  0.8793472541109001E-07 -0.1838137393066000E-07
61 30  0.1607591762125000E-06 -0.1143471484455000E-06
61 31 -0.2585393686107000E-07  0.1892241080599000E-08
61 32  0.6929768731690001E-07 -0.1587510398010000E-06
61 33 -0.4147978925099000E-07  0.4138071793731000E-07
61 34 -0.1478161143041000E-07  0.1369564095579000E-06
61 35 -0.2042766582841000E-06 -0.1550780649970000E-06
61 36  0.9185287194022000E-08  0.6343345105544000E-07
61 37  0.2334283666107000E-07  0.8998721121831001E-07
61 38  0.7659688905478000E-07 -0.2712016427007000E-07
61 39  0.6698962575119000E-07  0.5102493324958000E-07
61 40 -0.7456766484930000E-07  0.7062997160201000E-07
61 41  0.9769011854088000E-07  0.1511796894687000E-06
61 42 -0.2468085743238000E-06 -0.9045387211102000E-08
61 43  0.1222104987343000E-06  0.4583071264555000E-07
61 44  0.7646817285647999E-07 -0.7832562274966000E-07
61 45 -0.5212940550126000E-07 -0.1450883436350000E-07
61 46 -0.1994280752182000E-08  0.1134794674722000E-06
61 47 -0.3160334559909000E-07  0.6864042191202000E-07
61 48  0.6414373373961000E-07  0.8848327982569000E-08
61 49  0.9001921367855000E-08 -0.1582707492808000E-06
61 50  0.6932906833441000E-07 -0.1100440581223000E-06
61 51  0.3860174140666000E-07  0.1135103274270000E-06
61 52  0.6195866081502999E-07 -0.2719389129223000E-07
61 53  0.2421085474258000E-08  0.1705415295846000E-06
61 54 -0.2745262353519000E-07 -0.1177445396758000E-06
61 55 -0.1715137577361000E-06 -0.1193627447461000E-06
61 56  0.1010995531666000E-06 -0.7061436410661000E-07
61 57  0.9028293371840001E-07 -0.1148035308507000E-06
61 58 -0.9316750240021000E-07  0.1440758040601000E-06
61 59  0.5571044627685000E-07 -0.3712321227163000E-07
61 60 -0.3768239336495000E-07  0.4812561546384000E-07
61 61  0.1972035664022000E-06  0.4625698366498000E-07
62  0  0.8984258113918999E-07  0.0000000000000000E+00
62 1  0.1250128135363000E-06  0.6888689390266001E-07
62 2 -0.2738288600821000E-07 -0.9326671172280001E-08
62 3  0.1127273580115000E-07 -0.9114217725649000E-07
62 4 -0.3523506628106000E-07  0.7413186880741001E-07
62 5  0.8757309143404000E-07 -0.3962486557524000E-07
62 6 -0.6104304563138000E-07  0.7623236730596000E-07
62 7 -0.2693561941827000E-07 -0.2035551084619000E-06
62 8 -0.7938094947197999E-07 -0.2817707350859000E-07
62 9 -0.2313083101864000E-07  0.4957145250359000E-07
62 10  0.1653270448725000E-06 -0.3400289081779000E-07
62 11  0.1137735499757000E-06  0.1798922503525000E-06
62 12 -0.1224461786751000E-06 -0.8157611000148000E-07
62 13  0.2078266427540000E-06 -0.2124406197819000E-07
62 14 -0.1277939798364000E-07 -0.4374418630527000E-08
62 15 -0.8422619241805000E-08 -0.1869652147869000E-06
62 16  0.6277485619755000E-07  0.1264966964560000E-06
62 17 -0.5731822803796000E-07  0.1874489656706000E-07
62 18  0.9895240689234000E-07  0.8241840437218000E-07
62 19 -0.8489513527527000E-07  0.4452106230303000E-07
62 20  0.4902268469000000E-07 -0.1025791169205000E-06
62 21  0.2384308321097000E-07 -0.1622837058415000E-07
62 22  0.2453727960546000E-07 -0.6456132883174000E-07
62 23  0.3272629004282000E-08  0.6726340171459000E-07
62 24  0.6317821287030000E-08 -0.8586366671310000E-07
62 25  0.5670100411377000E-07  0.1694440106509000E-07
62 26  0.4907787617242000E-07  0.6349719285394000E-07
62 27  0.1983213338972000E-07  0.6022611586831000E-07
62 28 -0.5921693605657000E-07  0.3655921702330000E-07
62 29  0.3512750255037000E-07 -0.1026287046744000E-07
62 30 -0.6433349746045000E-07  0.6059463480707000E-07
62 31 -0.2003788238493000E-06  0.9123922932374000E-07
62 32  0.1502898291883000E-06  0.1121297181934000E-06
62 33 -0.4769579396599000E-07 -0.6670721184765000E-07
62 34  0.1123589997389000E-06 -0.5510427324651000E-07
62 35 -0.6359069049042000E-07 -0.3655909883470000E-07
62 36  0.1273612867852000E-06 -0.2481249425039000E-07
62 37 -0.1016089558746000E-06 -0.9492241574652000E-07
62 38  0.9230693546397000E-07  0.4612439619221000E-07
62 39  0.4702151941350000E-07  0.2173146626393000E-06
62 40  0.1611538395677000E-07 -0.1449074002559000E-06
62 41  0.2300543382276000E-07 -0.1006577042497000E-06
62 42 -0.3566116656709000E-07 -0.1265128512100000E-07
62 43  0.2824362998502000E-07 -0.3857187765164000E-07
62 44 -0.3038047908586000E-07 -0.1005495960089000E-06
62 45 -0.3090747823148000E-07  0.8519018558943000E-07
62 46  0.2216854492719000E-07  0.1516158834264000E-06
62 47  0.7498830813314999E-07 -0.1450107742082000E-06
62 48  0.4219812836128000E-07  0.7508654127617999E-07
62 49  0.1393435217371000E-07  0.7198776300337000E-07
62 50  0.1219625240113000E-06  0.1669405638292000E-07
62 51 -0.8810062642434000E-07 -0.1189733550154000E-07
62 52 -0.9328642172116000E-07 -0.2214055810283000E-07
62 53 -0.7315348254683000E-07 -0.1257728704781000E-07
62 54 -0.3729737034507000E-08 -0.1069019147399000E-06
62 55 -0.3679311806040000E-09  0.5610078728993000E-07
62 56  0.1154995758478000E-06  0.8470956568525000E-07
62 57 -0.1255796439098000E-07  0.2035509940270000E-07
62 58 -0.7056039081667000E-07  0.7147214775773000E-07
62 59  0.3601491407476000E-07 -0.2310981747001000E-06
62 60 -0.2251190847853000E-07  0.9165491168902000E-07
62 61  0.5519128850165000E-07 -0.6675801078078001E-07
62 62 -0.9267213593279999E-07  0.8053577663818000E-07
63  0  0.5932731868004000E-07  0.0000000000000000E+00
63 1 -0.4416995233368000E-07 -0.1006821471077000E-07
63 2 -0.2835625889233000E-08  0.1378903012275000E-06
63 3  0.7478675746756000E-07  0.4042625430827000E-07
63 4 -0.9310378927579000E-07 -0.2826565694176000E-07
63 5 -0.1187857423911000E-06  0.2158314123387000E-06
63 6  0.7403394596431000E-07 -0.5448741376903000E-07
63 7 -0.9088944680459000E-07 -0.7150926202473000E-08
63 8  0.6977481315056000E-08 -0.4155358258472000E-07
63 9 -0.5905445160778000E-07 -0.9917488855275999E-07
63 10 -0.4062583505669000E-07 -0.1344838019227000E-06
63 11 -0.8057229560796000E-07  0.2107928524668000E-07
63 12  0.9919794521741000E-07 -0.7835773840921000E-07
63 13  0.2398443158625000E-07  0.7233737342126000E-09
63 14 -0.1226761838827000E-07 -0.3465339596716000E-07
63 15  0.1096924715813000E-06  0.6825714654127999E-07
63 16 -0.8655207230373000E-07  0.1749879090449000E-06
63 17 -0.3580502370695000E-08  0.1641437958507000E-06
63 18 -0.5498077004768000E-07 -0.1866730499500000E-07
63 19 -0.7502619162312000E-07  0.4118450405699000E-07
63 20 -0.4972436595668000E-07  0.1696188296139000E-07
63 21 -0.1216730664130000E-06 -0.1071758166949000E-06
63 22  0.5803504207230000E-08  0.4514368905575000E-07
63 23  0.1592850075336000E-06 -0.5177120969540000E-08
63 24 -0.8496778320768000E-07  0.2530141328224000E-07
63 25 -0.1129443304692000E-06  0.1341810790850000E-06
63 26  0.4659314748999000E-07 -0.5518533559583000E-07
63 27 -0.4549013898058000E-07 -0.1887897846214000E-06
63 28 -0.1298419909583000E-06  0.5784430469916000E-07
63 29 -0.6760780440350000E-07  0.3610063259621000E-07
63 30  0.8569620947750001E-07 -0.7046775205291000E-07
63 31 -0.5756450695982000E-07  0.7320829525568000E-08
63 32  0.3594701034447000E-07 -0.7440980526128999E-07
63 33 -0.1532150710777000E-07 -0.8478151056997000E-07
63 34  0.6759561566717000E-07 -0.2624296558534000E-07
63 35 -0.1237978415167000E-06 -0.2422867006696000E-07
63 36  0.1088890516870000E-06  0.6352600123277000E-07
63 37 -0.3138138327637000E-07  0.1605359166638000E-06
63 38  0.1365801904879000E-07  0.5237459952744000E-07
63 39  0.3169812568538000E-07  0.9014166518192999E-08
63 40 -0.2500411991109000E-07 -0.1027471879577000E-06
63 41  0.1123497812840000E-06  0.7452730310797001E-08
63 42  0.5116435854182000E-07 -0.3659712544476000E-07
63 43 -0.4992863609175000E-07  0.3899900924031000E-07
63 44 -0.5780975175326000E-07  0.9871638473624000E-07
63 45 -0.2823210330449000E-07  0.1493712736402000E-06
63 46 -0.7045940546809000E-07 -0.6038519626115999E-07
63 47 -0.3894541704480000E-07 -0.9595146905804000E-07
63 48  0.5857143604951000E-07  0.1283951378190000E-06
63 49 -0.1000156826560000E-06 -0.2059413013788000E-07
63 50 -0.8133894330246000E-07 -0.2512621806903000E-07
63 51 -0.4210552893554000E-07  0.1572152917068000E-07
63 52  0.7116002784130001E-07 -0.1231464187337000E-06
63 53  0.1186808980519000E-06  0.5312297977456000E-07
63 54  0.7483668530095000E-07 -0.2365574260616000E-08
63 55 -0.1160562974479000E-06 -0.8323085148768999E-07
63 56  0.6228978023057000E-07 -0.1515100661099000E-07
63 57 -0.3465464304568000E-07  0.3085672102091000E-07
63 58 -0.2670521099008000E-07 -0.1259734235363000E-06
63 59 -0.1300066298793000E-07 -0.4597681450077000E-07
63 60 -0.8847787697283000E-07  0.3950840254726000E-07
63 61  0.2054781805541000E-07 -0.1061728076268000E-07
63 62 -0.1101627219815000E-06 -0.1519380988415000E-07
63 63 -0.9597059813784000E-07 -0.6630723673719000E-07
64  0  0.1156810949222000E-06  0.0000000000000000E+00
64 1  0.1939266441774000E-07  0.2762920164577000E-07
64 2  0.1427622161463000E-06 -0.4539399544902000E-07
64 3 -0.1043548514504000E-06 -0.1628979840018000E-06
64 4 -0.7504112341720000E-07  0.6791666437165000E-07
64 5  0.9451988713366000E-07 -0.7302123177856000E-07
64 6  0.1616025415854000E-07 -0.5746504455561000E-07
64 7  0.1314990423668000E-06 -0.1225986294354000E-06
64 8 -0.4801147542969000E-07 -0.1267875039316000E-07
64 9  0.1268627789171000E-06 -0.1607343889417000E-07
64 10 -0.2251262639785000E-07  0.2419493972302000E-06
64 11  0.7720854222834000E-07  0.1282484246696000E-06
64 12 -0.7491154903115001E-08  0.5365976113117000E-07
64 13  0.5891907132679000E-07  0.1077456573632000E-06
64 14  0.4026109443212000E-07 -0.1451356732632000E-07
64 15 -0.6440228527928000E-07 -0.1149476501313000E-06
64 16  0.3802658416561000E-07 -0.3488099553559000E-07
64 17  0.8205788123755000E-08 -0.2707842977726000E-06
64 18 -0.9140911703771000E-07  0.2552846538819000E-07
64 19  0.7373792203995000E-08 -0.8662073676257000E-07
64 20  0.1805727822357000E-07 -0.2943560593285000E-07
64 21 -0.5400804905050000E-07  0.5641011002596000E-07
64 22  0.1554736157813000E-06  0.6855512983153001E-07
64 23 -0.6864238887828000E-07  0.5347335053106000E-07
64 24  0.6631562433189000E-08  0.6328529639982999E-07
64 25 -0.3358122678687000E-07  0.4094313745984000E-07
64 26  0.1602792011759000E-06 -0.1907743024433000E-07
64 27 -0.9119085250415000E-07  0.4601139305241000E-07
64 28 -0.7732645465825000E-08  0.3179723300526000E-07
64 29 -0.2806458248869000E-08  0.1652804793470000E-07
64 30  0.1322771398285000E-06 -0.1222158577757000E-06
64 31 -0.6661797463670000E-07 -0.1627108801635000E-07
64 32  0.6126991998978000E-07 -0.1335205925751000E-07
64 33 -0.1385158874295000E-06 -0.1528840525505000E-06
64 34 -0.8910671229812000E-07 -0.3667055161815000E-07
64 35  0.9085218967278000E-07 -0.1130714919538000E-06
64 36 -0.1588438629835000E-07  0.1096162347218000E-06
64 37  0.2005677696815000E-07 -0.3108357128122000E-07
64 38 -0.1216664566160000E-06  0.5071473680131000E-07
64 39 -0.6082374429144000E-07 -0.8291820193112999E-07
64 40  0.5451632523472000E-10 -0.7143380704443000E-08
64 41 -0.1056645732962000E-06  0.3589130272526000E-07
64 42 -0.2337884061312000E-07  0.3264188305534000E-07
64 43 -0.1494572091333000E-06  0.9244911265062999E-07
64 44 -0.7342296957326000E-07 -0.1145911882199000E-06
64 45 -0.2282335086011000E-07 -0.8961866521628000E-07
64 46  0.6131006576845000E-07 -0.4222665944164000E-07
64 47  0.5094983835355000E-07  0.4118292643935000E-07
64 48  0.3897497372775000E-10  0.1519953601593000E-06
64 49 -0.1088387183433000E-06 -0.1600772761891000E-07
64 50 -0.2663879707749000E-07  0.3672375528280000E-08
64 51 -0.1134281349442000E-07 -0.3069310699505000E-07
64 52  0.1344841173195000E-06 -0.2782286066513000E-07
64 53  0.3181127622483000E-07 -0.1068191460905000E-06
64 54 -0.1017967916158000E-06 -0.2958965304120000E-07
64 55  0.7713496170795000E-07 -0.7300777273679000E-07
64 56  0.6614580025111999E-07  0.7789829539973000E-07
64 57 -0.3730026354391000E-07 -0.5816194807083000E-07
64 58  0.5557909247298000E-07  0.6995087849096000E-07
64 59  0.1642106172434000E-06 -0.3331425032542000E-07
64 60  0.1219978526319000E-06 -0.3270536653847000E-07
64 61 -0.2323430091269000E-07  0.2064415674720000E-06
64 62  0.1381185005996000E-06  0.9313934122477000E-07
64 63 -0.8975797203260000E-07 -0.2400172633819000E-07
64 64  0.1198110881790000E-06  0.8284535181889000E-07
65  0  0.3723271630328000E-07  0.0000000000000000E+00
65 1 -0.1162849458620000E-06 -0.7804700362768000E-07
65 2  0.2446752135856000E-07  0.1103802282531000E-06
65 3  0.2065302188773000E-06  0.9151888651443000E-07
65 4  0.1255434030571000E-06  0.2295155170682000E-07
65 5  0.9833001681021999E-07  0.3168499553183000E-07
65 6  0.2863074319975000E-07 -0.2270627599932000E-07
65 7 -0.4187827720162000E-07  0.1134899542252000E-06
65 8  0.8059725335649000E-07  0.1176986155304000E-06
65 9  0.1162552478157000E-06  0.2286645508430000E-07
65 10 -0.3123023242507000E-07 -0.1439351087858000E-06
65 11 -0.7815185285784001E-07 -0.2243292433271000E-06
65 12 -0.5044455397738000E-07  0.3376789502599000E-07
65 13 -0.5476116560276000E-07 -0.1164991425442000E-06
65 14 -0.4087322635560000E-07 -0.1439695843581000E-06
65 15 -0.4301158583656000E-07 -0.5187044809127000E-07
65 16  0.5501788327369000E-07 -0.1360573481819000E-07
65 17  0.5513686227044000E-07  0.7814040811607000E-07
65 18 -0.4494913995334000E-07  0.8280410429472000E-07
65 19  0.9765139503697001E-07 -0.7858036378390001E-08
65 20  0.5615403447867000E-07  0.9596861566473000E-07
65 21 -0.4236720294803000E-08 -0.1941612239147000E-07
65 22  0.9224651741257000E-07  0.7089921506550000E-07
65 23 -0.9149604201865001E-07 -0.1027342681107000E-06
65 24  0.2255999173936000E-07 -0.4368561747449000E-07
65 25  0.6406587924098000E-07 -0.5875619639657000E-07
65 26 -0.4175021735364000E-07  0.7385602032484000E-08
65 27 -0.2696484296549000E-07 -0.1195325604251000E-06
65 28  0.1359319884502000E-06  0.1882979760555000E-07
65 29 -0.9621649232074999E-07 -0.1353756299055000E-07
65 30  0.5893309617320000E-07 -0.1479254084260000E-06
65 31  0.4674169407317000E-07  0.2645722407194000E-07
65 32  0.1494646769288000E-06  0.3812374377276000E-07
65 33 -0.1188129270634000E-06 -0.6438935771178000E-08
65 34  0.6712985623953000E-07  0.1309423559154000E-06
65 35  0.3821575930961000E-07  0.1077848989802000E-06
65 36  0.4574501989464000E-07  0.1196248267069000E-06
65 37  0.1132503205879000E-06 -0.1351551736568000E-06
65 38 -0.9125808545373001E-07 -0.7004018715803000E-07
65 39  0.4063814188567000E-07 -0.1770575072223000E-06
65 40  0.6257861568955000E-07  0.5991027888976000E-07
65 41 -0.9352007275579999E-08  0.5296120515365000E-08
65 42 -0.4539974709712000E-07  0.6354872785807000E-07
65 43 -0.1376039753224000E-06  0.3955527135394000E-07
65 44  0.2971416736004000E-07  0.4497525963472000E-07
65 45 -0.2178694382992000E-07  0.8714816001765999E-07
65 46  0.9794567936777999E-07  0.8308582432982000E-07
65 47  0.1226801517826000E-06 -0.7135709216827000E-07
65 48  0.5229991229813000E-07 -0.5250591706960000E-07
65 49 -0.5474993957459000E-08 -0.9598587609852000E-07
65 50  0.1686352431484000E-07 -0.6523654034132999E-07
65 51  0.1491740860035000E-06 -0.7647051326984000E-08
65 52  0.6120959565030001E-07  0.8679559563299000E-07
65 53  0.2959253090717000E-07  0.1310727327922000E-06
65 54 -0.4322475274481000E-07  0.6694223723902000E-07
65 55  0.8585164123383000E-07 -0.3387046939074000E-07
65 56 -0.9713864550377000E-08  0.1119231651959000E-06
65 57  0.3656112925059000E-07  0.3091572072804000E-07
65 58  0.4365178667041000E-08  0.1852674072409000E-07
65 59  0.4098206785578000E-07  0.2853234846694000E-07
65 60 -0.1491461776461000E-06 -0.6477362027024000E-07
65 61 -0.8257791874568000E-07 -0.1934374913464000E-07
65 62  0.4941120466607000E-07 -0.1504758749401000E-06
65 63  0.3247511935493000E-07  0.2628688130883000E-07
65 64  0.1811715931328000E-06 -0.1661851015877000E-06
65 65 -0.5754080513108000E-07 -0.7968322477270000E-07
66  0  0.7100695992462001E-07  0.0000000000000000E+00
66 1  0.2749835230498000E-07  0.1338891430298000E-06
66 2 -0.9024584307383000E-08 -0.4736113007391000E-07
66 3 -0.2068524669684000E-06 -0.3641821579217000E-07
66 4 -0.3536936644900000E-07 -0.5030642890567000E-07
66 5 -0.3008885776418000E-07 -0.1119487902448000E-08
66 6 -0.6516946919202000E-07 -0.1229670022769000E-07
66 7  0.1592278058955000E-07 -0.3018095668098000E-07
66 8  0.2847133424208000E-07 -0.1515334927683000E-06
66 9 -0.2098056097362000E-07 -0.6527305228452000E-07
66 10 -0.2856863061545000E-07  0.6383226709820000E-07
66 11 -0.5305493651138000E-07  0.2409143502909000E-06
66 12  0.9884722578403000E-07  0.5811216460947000E-07
66 13 -0.5599252435551000E-08 -0.4811479763054000E-07
66 14 -0.2834755417938000E-07  0.6371450150121000E-07
66 15 -0.3359888763020000E-07 -0.7339593390599000E-07
66 16  0.4101110705929000E-07  0.7928199020602000E-07
66 17 -0.5342676091324000E-07  0.1208949316589000E-06
66 18  0.7206103609249000E-07 -0.1000670428414000E-06
66 19 -0.2717220733245000E-07  0.2788456387711000E-08
66 20  0.6781929316494000E-08  0.1245486330085000E-06
66 21 -0.2774616127910000E-07 -0.2072943254074000E-07
66 22 -0.4725813406610000E-07 -0.3289447169972000E-08
66 23  0.3988198128943000E-07  0.1211374708197000E-06
66 24  0.1588124636253000E-06  0.9797880889078000E-07
66 25 -0.3359049008225000E-07  0.7424974108114001E-07
66 26  0.6066392283907001E-07 -0.8281017969711001E-08
66 27 -0.9410622932955001E-07 -0.5814460146220000E-07
66 28 -0.7659588275267000E-07  0.1133193650936000E-06
66 29  0.3216054887612000E-07 -0.4292220951473000E-07
66 30  0.8399760622718999E-07 -0.1177752820537000E-06
66 31 -0.1247719929483000E-06  0.2058168390834000E-06
66 32 -0.5644290145905000E-07 -0.4602819250966000E-07
66 33  0.8024670014845000E-07 -0.3750509790480000E-07
66 34  0.7624082156847000E-10 -0.6237572749021000E-07
66 35  0.1210255033897000E-07 -0.6353103438978000E-07
66 36  0.8038143000386000E-07  0.9744949222762000E-08
66 37  0.3813998131653000E-07  0.5315907599985000E-07
66 38 -0.9717196876494000E-07 -0.1871255378548000E-07
66 39  0.1228785847613000E-06  0.1473675281884000E-06
66 40  0.2219876761347000E-07  0.2054114852389000E-06
66 41  0.3575722840208000E-08 -0.7795463193610000E-08
66 42  0.1203649550496000E-06 -0.3721780659234000E-07
66 43 -0.5413091722267000E-07  0.2059642957140000E-07
66 44  0.1407265293405000E-06  0.6829474955531999E-07
66 45 -0.3006031935590000E-07  0.2766717268970000E-07
66 46  0.7633369043337000E-07 -0.4176789416890000E-07
66 47 -0.1461905757857000E-06 -0.1551304862508000E-07
66 48  0.3771133820968000E-08 -0.2486666314501000E-07
66 49 -0.5741613122079000E-07  0.2630364154948000E-07
66 50 -0.2996181263743000E-07 -0.1602299818393000E-08
66 51 -0.4224641481612000E-07 -0.1935375720176000E-08
66 52 -0.9137682242930999E-07 -0.2948427861963000E-08
66 53 -0.4687880595072000E-07 -0.9312436270584000E-07
66 54 -0.3793051559801000E-07 -0.8261115327732000E-07
66 55 -0.1155173642746000E-06 -0.1073833602016000E-06
66 56  0.4280491812058000E-07 -0.1809866596284000E-07
66 57 -0.4918241262711000E-07 -0.1173343384606000E-06
66 58 -0.6364260547874000E-07  0.3478226570377000E-07
66 59  0.4926928541704000E-07 -0.3738383729997000E-08
66 60 -0.1311493877424000E-06 -0.1195694252045000E-06
66 61 -0.3601128664622000E-07  0.2048022960738000E-07
66 62  0.4536822098358000E-08  0.4546056700574000E-10
66 63 -0.8672638942287999E-07 -0.2022956788861000E-07
66 64 -0.8250077175242000E-07  0.2089155826876000E-06
66 65 -0.1397259362981000E-06  0.4626383356380000E-07
66 66 -0.1065846531831000E-06  0.7262066879203999E-07
67  0 -0.2547783235020000E-06  0.0000000000000000E+00
67 1 -0.4891591970828000E-07 -0.1031985774789000E-06
67 2  0.6624090026700000E-07 -0.1385765857253000E-06
67 3  0.1410671596795000E-06 -0.8581821169840000E-08
67 4 -0.5158365232343000E-07  0.4510933233542000E-07
67 5 -0.1290892732488000E-06  0.7417956758102000E-07
67 6 -0.3455111452427000E-07  0.2660275992161000E-07
67 7 -0.4644013363618000E-07  0.4476422461853000E-07
67 8 -0.3595167822576000E-07  0.1089901522198000E-06
67 9 -0.1059048373591000E-06  0.9546525612274000E-07
67 10 -0.5433520634248000E-07  0.3031917895225000E-07
67 11  0.6149486434016001E-07 -0.1234266024156000E-06
67 12 -0.1918345320587000E-07 -0.6639515986446000E-07
67 13  0.4132478469780000E-07 -0.1596965411305000E-06
67 14 -0.4632373814715000E-07 -0.1060685983727000E-06
67 15 -0.5693472724062000E-07  0.2993887303048000E-07
67 16  0.6618305413601000E-07  0.8764075108448000E-07
67 17  0.3556254791084000E-07 -0.6940821213074000E-07
67 18  0.2541365227060000E-07  0.1064756094872000E-06
67 19 -0.5566429712495000E-07  0.1207426552449000E-06
67 20 -0.3873415018750000E-07  0.3079951961116000E-07
67 21 -0.7343317707115000E-07  0.4784137372654000E-07
67 22  0.1410300499474000E-06  0.7179339536275000E-07
67 23  0.8024596382812000E-07 -0.2097205690136000E-06
67 24  0.3744021504629000E-07  0.7711028275857000E-07
67 25 -0.1890309894704000E-06  0.1135293197437000E-06
67 26  0.9137991199127999E-07 -0.1060538717937000E-06
67 27  0.6672290649062000E-07  0.1991214119846000E-07
67 28  0.4612347273357000E-07 -0.6169989468122000E-07
67 29  0.7104459456118000E-07 -0.9907414453614000E-07
67 30 -0.1329315851021000E-06  0.5563223467299000E-07
67 31 -0.8560700173019000E-08  0.4308941500621000E-07
67 32  0.1036443904382000E-06 -0.4066844700780000E-07
67 33 -0.7037937754810000E-07  0.8930412063104000E-07
67 34 -0.6270127401588000E-07  0.1056075426805000E-06
67 35  0.3188885764678000E-07 -0.3031932962727000E-07
67 36 -0.9375421513791001E-07 -0.1626873463373000E-07
67 37 -0.6477481755738001E-07 -0.9277843104174000E-07
67 38  0.4756022725998000E-07  0.4672682669567000E-07
67 39  0.5354463878961000E-07 -0.1454424693736000E-07
67 40 -0.1175048367147000E-06 -0.9827981754542000E-07
67 41 -0.5874979829602000E-08 -0.6649480645511000E-08
67 42  0.4642445599645000E-07  0.1339154906670000E-06
67 43 -0.3785373854202000E-07 -0.4276895159679000E-08
67 44  0.5775754809778000E-07  0.6762831551301000E-08
67 45  0.6231380569072000E-08 -0.2008420943010000E-06
67 46 -0.5202125742412000E-07  0.4672242374523000E-08
67 47 -0.1313086503897000E-06 -0.5580278771846000E-07
67 48 -0.2182029309342000E-07  0.6928541608023000E-07
67 49 -0.2881437166443000E-07  0.9523365350118000E-07
67 50 -0.7725408762317000E-07 -0.3917459967619000E-07
67 51  0.6925755993122000E-08  0.2040849269688000E-07
67 52  0.5966783594206000E-07 -0.2772089094029000E-08
67 53  0.1056925943189000E-06  0.9848431763723000E-07
67 54 -0.1189321252726000E-07  0.3421339311977000E-07
67 55  0.1175188136387000E-06  0.6726789174910000E-07
67 56  0.1974577113794000E-06 -0.5198729055201000E-07
67 57 -0.1710909088621000E-06 -0.3660164959635000E-07
67 58  0.4357791021466000E-07  0.4545262959001000E-07
67 59  0.2192616706366000E-07 -0.5667794950390000E-07
67 60 -0.1365723588701000E-07  0.1918807983436000E-07
67 61  0.8916631570772001E-07  0.1211801190824000E-06
67 62  0.1216260653123000E-06 -0.2764688780513000E-07
67 63 -0.4180520810403000E-07  0.1121615772766000E-06
67 64  0.1485129906845000E-06  0.4552859210394000E-07
67 65 -0.3671389735473000E-07 -0.2005473019612000E-06
67 66  0.8215007491074000E-07 -0.5060608164301000E-07
67 67 -0.6055644038295000E-07 -0.2816779401525000E-07
68  0  0.7792606140960999E-07  0.0000000000000000E+00
68 1  0.2185330393772000E-08 -0.1341118880553000E-07
68 2 -0.1463294620341000E-07  0.1750017858700000E-07
68 3  0.2839102008580000E-07 -0.1402974951239000E-07
68 4 -0.4722992343492000E-07  0.2569005711963000E-07
68 5  0.1234277504085000E-06  0.5193956774042000E-07
68 6 -0.2086077088500000E-07 -0.2300814876211000E-06
68 7  0.3951129740966000E-10 -0.1044950160259000E-06
68 8 -0.2998835268499000E-07  0.6771856664063000E-09
68 9  0.1249367220930000E-06  0.5141062241740000E-07
68 10  0.2479640780496000E-07  0.1073185153506000E-06
68 11 -0.6663145683427000E-07  0.4458704064408000E-07
68 12  0.7625482128534000E-07 -0.7856480961625000E-07
68 13 -0.3754336411325000E-08 -0.5815308564783000E-07
68 14 -0.2461166857445000E-07  0.5107371798172000E-07
68 15  0.1223441091398000E-06  0.1654863539390000E-06
68 16 -0.4249752518752000E-07 -0.4357718964388000E-07
68 17 -0.8293267284386000E-07 -0.1203620750686000E-07
68 18  0.8246910913583000E-08 -0.2289282755064000E-07
68 19  0.6239001954540000E-07 -0.6406540795676000E-07
68 20  0.2357824578488000E-07  0.4314281041923000E-07
68 21  0.1302828869663000E-06 -0.3432416262064000E-07
68 22  0.8393602740261000E-07 -0.1322062801973000E-06
68 23 -0.1016070709435000E-06  0.3996087785985000E-07
68 24 -0.5464706679228000E-07  0.5314308038200000E-07
68 25  0.1009101716571000E-06 -0.9523606024909000E-07
68 26  0.1498391822733000E-06 -0.1135385923400000E-06
68 27 -0.1815014724440000E-06 -0.9895181928738001E-07
68 28  0.1106558391203000E-06 -0.1212558973172000E-06
68 29 -0.6974604168338000E-07  0.1250000042378000E-06
68 30 -0.2627818878706000E-07  0.6618803831914000E-08
68 31  0.6341489888723000E-07  0.5771651450236000E-07
68 32  0.9902818121521999E-07  0.5873708630406000E-07
68 33 -0.7522267756291000E-07 -0.1935696692696000E-07
68 34  0.6325871175752000E-07 -0.9848577949026000E-07
68 35  0.1192732919770000E-06 -0.2711638869143000E-07
68 36 -0.6376774614525000E-07  0.4383822005464000E-07
68 37  0.5035573146129000E-07  0.4143441149503000E-07
68 38 -0.1614235403207000E-06  0.8765106843703000E-07
68 39 -0.5127036460553000E-07 -0.8037344877008000E-07
68 40  0.2278004823414000E-07 -0.4763231484538000E-07
68 41  0.8935827281012000E-08  0.7938497550560000E-07
68 42  0.3289040781065000E-07 -0.6068681947731000E-07
68 43 -0.2370647638143000E-07 -0.1527222362178000E-07
68 44  0.4144919797862000E-07  0.2756110499170000E-07
68 45 -0.1140910794136000E-06  0.4100465868497000E-07
68 46 -0.1965549304874000E-06  0.9617495218307000E-07
68 47  0.1387736164451000E-08 -0.1183435273651000E-06
68 48 -0.1926514359756000E-07  0.8239253554927000E-07
68 49 -0.6170731752910000E-07 -0.8149997986416000E-07
68 50  0.8985827130715000E-07 -0.7791733778671000E-07
68 51  0.1155564080264000E-06 -0.1381011259045000E-06
68 52 -0.1466851379686000E-07 -0.3894889999439000E-07
68 53 -0.6552347983960000E-07  0.6656808669436000E-07
68 54 -0.4483818460347000E-07 -0.6978553586742000E-08
68 55  0.2804762442775000E-07 -0.4132571852300000E-07
68 56 -0.7908340698175000E-07  0.2762393553974000E-07
68 57 -0.4904452534116000E-07  0.9208305488973000E-07
68 58  0.3535639599274000E-07  0.4847272513847000E-07
68 59 -0.5596071464488000E-07 -0.3421100383570000E-07
68 60  0.9749214225840000E-07 -0.1951192842035000E-07
68 61  0.1579457322832000E-07 -0.6270827774705001E-07
68 62 -0.4654171205676000E-07 -0.1119373027776000E-06
68 63 -0.2864620968822000E-07 -0.5740117601808000E-07
68 64  0.9022252121703000E-09 -0.7307292748393000E-07
68 65 -0.1568871932866000E-06  0.6754362984592000E-07
68 66 -0.3527968490964000E-07  0.7152699300267000E-07
68 67  0.7500317066334000E-07  0.5042392012294000E-08
68 68  0.9603996199979000E-07  0.5475826454937000E-08
69  0 -0.1435305518724000E-06  0.0000000000000000E+00
69 1 -0.3711703891127000E-07  0.1520555993931000E-07
69 2  0.1153124357951000E-06  0.1251589576648000E-06
69 3 -0.3219913783621000E-07  0.2007506543105000E-07
69 4  0.4209999504049000E-07 -0.3123985679122000E-07
69 5 -0.1499609442404000E-06 -0.5568257684050000E-08
69 6  0.9270721133105000E-07 -0.1012802543974000E-06
69 7  0.6420786721200000E-08  0.2185729520967000E-06
69 8 -0.1926836458855000E-07  0.5788004669234000E-07
69 9 -0.3279670967221000E-07 -0.5898629104318000E-07
69 10 -0.7566542438862000E-07 -0.1115144647444000E-06
69 11  0.1106557566163000E-06 -0.9395717303038001E-07
69 12  0.1403718891227000E-07  0.4945081990580000E-07
69 13 -0.9437630790898000E-07  0.3741632177489000E-07
69 14  0.7366315696492999E-07  0.1841285921375000E-06
69 15  0.6605180282173001E-07  0.1734252820603000E-07
69 16 -0.6344071815208999E-07 -0.3868370853335000E-07
69 17  0.2849568192387000E-07  0.3927135572723000E-07
69 18  0.3494686249465000E-07  0.7424458155334000E-07
69 19  0.9609995538202999E-07  0.8741609649256001E-07
69 20  0.1702735687260000E-06 -0.8203921638617000E-07
69 21 -0.1681749691241000E-06 -0.8407644268940000E-07
69 22 -0.3626352030591000E-07  0.1332136386985000E-06
69 23 -0.5506599451517000E-08 -0.3296534987386000E-07
69 24  0.7000718092682000E-07  0.1562143455124000E-07
69 25  0.3866748978893000E-07  0.1104201812227000E-07
69 26 -0.1911794559475000E-06 -0.1671872056795000E-07
69 27  0.2139216909962000E-06  0.4306510005826000E-07
69 28 -0.1567493925680000E-06  0.1600995523476000E-06
69 29 -0.5955300841905000E-07  0.4074549155851000E-07
69 30 -0.1634834796248000E-07  0.8333879872240000E-07
69 31 -0.1629287530049000E-07 -0.1327087600453000E-07
69 32  0.2041262659564000E-07 -0.5967938860994000E-07
69 33 -0.2111719224237000E-07 -0.1289839572099000E-06
69 34  0.1708367216718000E-07  0.1113599211087000E-06
69 35 -0.7386474563075000E-07  0.1283623685845000E-07
69 36 -0.3846504511090000E-07 -0.8068898800166000E-07
69 37 -0.3611358520813000E-07 -0.7154124766587000E-07
69 38 -0.1976797177943000E-07 -0.1316251723585000E-07
69 39  0.7418131830737000E-07 -0.2366671030874000E-07
69 40 -0.2664627244761000E-07  0.6738666459937000E-08
69 41  0.1433449699193000E-06  0.7972282124891001E-07
69 42 -0.1275420062463000E-06  0.3661783355340000E-08
69 43 -0.4044077843459000E-07  0.5694545173579000E-07
69 44  0.8312501891843000E-07 -0.1341264059244000E-07
69 45 -0.4574826889072000E-08 -0.3216692773720000E-07
69 46  0.7405547114909000E-07 -0.6214287666114000E-07
69 47  0.4828259470797000E-07  0.3306590339868000E-08
69 48  0.1850078649289000E-07  0.1551768730511000E-06
69 49  0.2319863017460000E-07  0.3376326406173000E-07
69 50  0.5287427294162000E-07 -0.1238489057497000E-06
69 51  0.5541524620483000E-07  0.1852261865385000E-07
69 52 -0.2336868368473000E-07 -0.4900016256948000E-07
69 53 -0.4369950891424000E-07 -0.4870149154245000E-08
69 54  0.8928728045466000E-07 -0.1323315963142000E-06
69 55 -0.2086088010525000E-06 -0.3465615169135000E-08
69 56  0.6436170116552000E-08 -0.2219626848572000E-08
69 57  0.4223072650749000E-08 -0.3236387096561000E-07
69 58  0.1576564584279000E-07 -0.1425501692588000E-06
69 59 -0.6988500709604999E-07 -0.5722864256938000E-07
69 60  0.2732131984653000E-07 -0.1965042101138000E-07
69 61 -0.3252993475624000E-07  0.6115845924949000E-07
69 62 -0.2137556182824000E-07 -0.3373244643955000E-07
69 63  0.9064441403270000E-08  0.1117804453974000E-06
69 64  0.1730455528231000E-06  0.5218921170160000E-07
69 65  0.1332890845228000E-06 -0.3972979683719000E-07
69 66 -0.3508918299575000E-07 -0.7960285291690000E-07
69 67 -0.1463759752387000E-08 -0.5401237409143000E-08
69 68 -0.1539295610280000E-06 -0.3729341790885000E-07
69 69 -0.4734747737737000E-07  0.9661002923225000E-07
70  0 -0.5965896478549000E-07  0.0000000000000000E+00
70 1  0.7636273480441001E-07  0.1583652931027000E-06
70 2 -0.1105520172851000E-06 -0.1075850001453000E-06
70 3 -0.7960933989969000E-07 -0.7259929217033000E-07
70 4 -0.9415992297242000E-07  0.2716735213801000E-07
70 5  0.4864701228840000E-07  0.6876232977405000E-07
70 6 -0.8603977895693000E-08 -0.3553249981268000E-08
70 7  0.5473278711665000E-07  0.5561532546403000E-08
70 8 -0.4625188949136000E-07 -0.1098368327168000E-06
70 9 -0.1433957796465000E-07  0.1752494278855000E-08
70 10 -0.9774484695171000E-08  0.3990438592833000E-07
70 11  0.8072019847230000E-07  0.1148041794814000E-06
70 12 -0.8297713757944999E-07  0.5969797358720000E-07
70 13  0.3892622290659000E-07 -0.8225522896394000E-07
70 14  0.4552098946187000E-07 -0.4445131389584000E-07
70 15 -0.5054337037530000E-07 -0.8231588543604000E-07
70 16 -0.3093997558997000E-08 -0.3374082932052000E-08
70 17 -0.3640523932776000E-07  0.1166872623358000E-06
70 18 -0.3324420520916000E-07 -0.4670090245819000E-07
70 19  0.4480782148644000E-07  0.3826754191632000E-07
70 20 -0.1877748841748000E-06 -0.8001278131147001E-08
70 21 -0.5315753525294000E-07 -0.2203064778474000E-07
70 22  0.1452386300125000E-07  0.8649946516805001E-08
70 23  0.6794870823330000E-07 -0.6792029648520000E-07
70 24  0.1787296759350000E-07 -0.1251233469681000E-07
70 25  0.7064369532096000E-07 -0.1921957302919000E-06
70 26  0.5725462264703000E-07 -0.4642501092641000E-07
70 27 -0.3219290439169000E-07  0.1044219503124000E-06
70 28 -0.8269471605907999E-07 -0.1158070420462000E-06
70 29  0.1188509659645000E-06 -0.5494802105825000E-07
70 30  0.8562989157004000E-07  0.7793358402411000E-07
70 31  0.1133524104930000E-07 -0.1048125865896000E-06
70 32  0.9337067918955000E-07 -0.3692939084165000E-07
70 33 -0.1237214412264000E-07  0.1008139101602000E-06
70 34  0.1022529965152000E-07  0.6278475152536000E-07
70 35 -0.6833957792438999E-07 -0.2114021164023000E-07
70 36 -0.5188586276624000E-07  0.6775479402695999E-07
70 37  0.7843389051945001E-07  0.1986889313284000E-07
70 38 -0.3872438140809000E-07  0.1733456843215000E-07
70 39  0.8986225506539000E-07 -0.1110296351260000E-06
70 40  0.8715965475292000E-07 -0.2628567721910000E-07
70 41  0.1587274968978000E-07 -0.2191775514284000E-07
70 42 -0.2673971950508000E-08 -0.1347227582063000E-06
70 43  0.3219018955075000E-07 -0.7361700655373000E-07
70 44 -0.1130253258584000E-07 -0.1003355156512000E-06
70 45 -0.2187257625861000E-08  0.2708597096857000E-07
70 46 -0.2004016460781000E-07 -0.9880548971078000E-07
70 47 -0.5103836263777000E-07  0.5547421709324000E-08
70 48 -0.3097830548771000E-07 -0.4133428991274000E-07
70 49  0.7005443444529000E-07 -0.4814879257380000E-07
70 50 -0.2165927707986000E-07 -0.1821665395977000E-07
70 51  0.1079061278179000E-06  0.5660332342445000E-07
70 52 -0.3718911913164000E-07  0.5659727801536000E-08
70 53  0.7420847948791000E-07 -0.3158851721730000E-07
70 54 -0.7876089481322000E-07 -0.3311344197544000E-07
70 55  0.4117839179957000E-07  0.8204756860370000E-07
70 56  0.1753648664460000E-06 -0.9264466800035000E-07
70 57  0.1383032558525000E-06 -0.1713266212879000E-07
70 58  0.2878790499014000E-07  0.1417666417048000E-06
70 59  0.9468939808867000E-07 -0.1622547315787000E-07
70 60  0.2133267898493000E-07 -0.8099851053787000E-07
70 61 -0.2990107596788000E-07  0.7040530147781000E-07
70 62  0.4202545572687000E-07  0.6032245467003000E-08
70 63  0.1314488026435000E-06  0.5092107595115000E-08
70 64 -0.6331485722503000E-07 -0.6049244106088000E-07
70 65 -0.2053164147165000E-06  0.9789477784611999E-07
70 66 -0.1471209280934000E-06  0.1125462935570000E-06
70 67  0.9358453207460999E-07  0.7011996471063000E-07
70 68 -0.6553988139340000E-08  0.4718840219062000E-07
70 69  0.7980147243338001E-07 -0.8519126380928000E-07
70 70 -0.5380026020106000E-07 -0.1039096909996000E-06
71  0  0.6167813887297000E-07  0.0000000000000000E+00
71 1 -0.7682886816119000E-07 -0.4376389845507000E-07
71 2  0.3745907473549000E-07  0.4991166661525000E-07
71 3  0.5830729838533000E-08 -0.1951290800357000E-07
71 4  0.3338132621579000E-08 -0.1711097300705000E-07
71 5  0.1066330850500000E-07 -0.3713666223068000E-07
71 6 -0.1719477461768000E-07  0.9831073559971000E-07
71 7 -0.4202558917956000E-07 -0.7518197471021000E-07
71 8 -0.5310196745331000E-07 -0.4646838229210000E-07
71 9  0.9093599527908000E-07  0.4445882266779000E-07
71 10  0.3592532488165000E-07  0.2654667530459000E-08
71 11  0.1472632314635000E-07 -0.7263468613088000E-07
71 12 -0.4324800698252000E-07  0.4567704819652000E-08
71 13 -0.1010898370306000E-06  0.3340153208275000E-07
71 14  0.6756111241748999E-07  0.8298989738930000E-07
71 15  0.9256190860332000E-07 -0.4342254514968000E-07
71 16  0.1674992923482000E-07 -0.7916175240061000E-08
71 17  0.7716200303645000E-08  0.1367349077881000E-06
71 18 -0.6692294838434000E-07  0.2290514347043000E-07
71 19  0.8088498993070000E-07 -0.8030547872857001E-07
71 20  0.8543125253473000E-07 -0.6920203526662000E-07
71 21 -0.3331038570104000E-07 -0.3201482877077000E-07
71 22  0.8059285833183000E-07  0.1213968186584000E-06
71 23  0.5084919370251000E-07  0.5897633517010000E-07
71 24  0.8492083029950000E-07 -0.3945764451757000E-07
71 25 -0.5424027787298000E-07  0.8692029301584000E-07
71 26 -0.5795589979749000E-07  0.2491847919622000E-07
71 27  0.2187935799307000E-07 -0.9209235118905999E-07
71 28  0.1088615254698000E-06  0.1705747916013000E-07
71 29 -0.6612206814860000E-07  0.1403002303523000E-06
71 30 -0.6421118228749000E-07 -0.3260230432743000E-07
71 31 -0.3135240323146000E-07  0.1501674216181000E-07
71 32  0.8814971272774000E-07 -0.2668319817444000E-08
71 33 -0.6686042004972001E-07  0.8594620396126000E-08
71 34 -0.6720922320583000E-08 -0.3542471561909000E-07
71 35 -0.7277776262832000E-08 -0.5021092327603000E-07
71 36  0.5864427419885000E-07  0.5892908485333000E-07
71 37 -0.2087416342061000E-07  0.2366059848646000E-07
71 38 -0.6637027442523000E-08 -0.2807989484331000E-07
71 39 -0.3319498972872000E-09  0.6773923993472000E-07
71 40 -0.1929325438740000E-06  0.4909487147009000E-07
71 41  0.2167636748320000E-07 -0.5858474337075000E-10
71 42 -0.5555652211290000E-07  0.1175806556862000E-07
71 43 -0.3359788216916000E-07  0.6913595624024000E-08
71 44  0.5498542981564000E-07  0.8552513992044001E-07
71 45  0.2135930463679000E-07  0.4373095319395000E-07
71 46  0.1110289187399000E-06  0.9311644318306000E-07
71 47  0.1111299656629000E-07 -0.2220146660828000E-08
71 48  0.1286060172256000E-06  0.1085156804288000E-07
71 49 -0.5100976981532000E-07  0.4257777057978000E-08
71 50 -0.3886488606647000E-07  0.1073488172891000E-07
71 51 -0.8186511449952000E-07 -0.8565904199953000E-07
71 52 -0.1258860900729000E-07  0.2017167036367000E-07
71 53 -0.1486576511613000E-06  0.7884243363301000E-07
71 54 -0.4072300415631000E-07  0.1157340812625000E-07
71 55  0.5900453139737000E-07  0.4468619151923000E-07
71 56 -0.8932971586739000E-07  0.6494702247113999E-07
71 57 -0.1164652704299000E-06  0.3282407229147000E-07
71 58 -0.8116931811327999E-08  0.3800892683590000E-07
71 59  0.1547859315485000E-07 -0.2055736377380000E-07
71 60 -0.1104703304869000E-07  0.3284917667989000E-07
71 61 -0.2189131040339000E-07  0.7548571353707000E-08
71 62 -0.1537698544223000E-07 -0.7740737967009000E-08
71 63 -0.3581552602359000E-07 -0.3875619580182000E-07
71 64 -0.1388830496886000E-06 -0.7827835603358999E-07
71 65  0.4655012692732000E-07 -0.1102224986606000E-07
71 66  0.1199321063961000E-06  0.8256131177428000E-07
71 67  0.1065183362390000E-06 -0.1865808449696000E-06
71 68 -0.1107867128001000E-06 -0.7625430876882000E-07
71 69 -0.6446420343192000E-07 -0.3019453215112000E-07
71 70  0.5251683188012000E-07  0.1720711507476000E-07
71 71 -0.5539495107982000E-08  0.2430080858808000E-07
72  0 -0.3216766506716000E-07  0.0000000000000000E+00
72 1  0.2403686131335000E-07 -0.1401641091107000E-07
72 2 -0.3904513723097000E-07 -0.1358653007104000E-06
72 3 -0.4006826789005000E-07  0.4034930974052000E-07
72 4 -0.7524272560589999E-07  0.7708593044814000E-07
72 5 -0.7526706415521999E-07 -0.4853409371290000E-07
72 6 -0.4746871184172000E-07 -0.7723191265267000E-07
72 7  0.4750612612435000E-07 -0.4504590354565000E-07
72 8 -0.4777430525416000E-07  0.6857281252770000E-07
72 9  0.1186293926590000E-06 -0.7092925122316000E-07
72 10 -0.6166932722159000E-07 -0.2300675471296000E-07
72 11 -0.3719264826199000E-07  0.6142352358515000E-07
72 12  0.2189114630275000E-08 -0.7485836417481000E-07
72 13  0.1620143649741000E-06 -0.3115519422524000E-07
72 14  0.9735183653670000E-07 -0.6618409135125000E-07
72 15 -0.3445234756333000E-07  0.1093968395106000E-07
72 16 -0.6224310466030000E-07  0.6941078143055000E-07
72 17 -0.1497416242206000E-06  0.7278901484509000E-07
72 18  0.3318679368632000E-07 -0.2359075806254000E-06
72 19  0.8970898062136000E-07 -0.2756008379529000E-07
72 20 -0.1082591304216000E-06 -0.1512227805989000E-06
72 21  0.4068769255054000E-07 -0.1471879546773000E-07
72 22  0.2729971817743000E-08  0.1802398543613000E-07
72 23  0.2029255679989000E-07 -0.1249107513151000E-06
72 24 -0.1656299771314000E-07  0.1671062098945000E-07
72 25 -0.2947866853250000E-07 -0.2056034289989000E-07
72 26  0.9610163352634999E-07  0.7637445077078000E-08
72 27 -0.2566361311641000E-07  0.8735368374335000E-09
72 28 -0.3154924222994000E-07 -0.8651030473222000E-07
72 29 -0.6386215753008999E-07  0.9387193723704000E-07
72 30 -0.8285995949868001E-07  0.1849529797505000E-07
72 31  0.2495434355130000E-07 -0.2386119020611000E-07
72 32  0.6500089815978000E-07 -0.5946382502775000E-08
72 33 -0.3137799340167000E-07  0.2993592763877000E-08
72 34 -0.1988120233384000E-07 -0.1736187923523000E-07
72 35 -0.8768004780812999E-07 -0.7849211127150000E-07
72 36 -0.3149235174304000E-07  0.1295195566980000E-07
72 37 -0.8868427393633001E-07  0.2127252552036000E-07
72 38 -0.1190562915701000E-06 -0.3453043010140000E-07
72 39  0.4651466408686000E-07 -0.4751125467182000E-07
72 40 -0.4089720760267000E-07 -0.2909373231938000E-07
72 41  0.8633291876008000E-07  0.1700691931276000E-07
72 42  0.8006540264716000E-08 -0.7328577796644000E-07
72 43 -0.2933361091855000E-07  0.1012382222341000E-07
72 44 -0.3563620555001000E-07 -0.1267722123189000E-07
72 45 -0.5209820453098000E-07  0.9074863808967000E-07
72 46 -0.4435392131141000E-07 -0.4762668811010000E-07
72 47  0.4403365468453000E-07  0.6128811379047001E-07
72 48  0.1936477405448000E-07 -0.1989319148309000E-07
72 49  0.5096647652507000E-07 -0.4923996192394000E-07
72 50 -0.2100072263682000E-07 -0.1296569995614000E-06
72 51  0.3579599015914000E-07 -0.6531145096557001E-07
72 52  0.1308372998111000E-06  0.5579264024146000E-07
72 53 -0.2316200372866000E-08  0.3525886914044000E-07
72 54  0.3430783568020000E-07 -0.3976736426008000E-08
72 55 -0.2740642881354000E-07  0.1135870333190000E-06
72 56 -0.3660316116583000E-07 -0.1076964394052000E-06
72 57  0.8159398377166000E-07 -0.7753101860424000E-08
72 58 -0.2813041760242000E-07 -0.4504252939871000E-07
72 59  0.3686530232995000E-09  0.1131706983547000E-07
72 60 -0.8362173116492000E-07  0.4773867179426000E-07
72 61  0.5347507784139000E-07 -0.6289230613716000E-07
72 62  0.9649889867887001E-08 -0.9024160288458000E-08
72 63 -0.6196724119546000E-08 -0.1255075560543000E-07
72 64 -0.4830081217028000E-07 -0.2008824124201000E-07
72 65  0.1454787949986000E-06  0.2792668401892000E-07
72 66 -0.2099775036428000E-07 -0.7761451765274001E-07
72 67 -0.9346827839248000E-07 -0.5940113878418000E-07
72 68  0.8301217560174000E-07  0.1497549371095000E-06
72 69  0.5626553667827000E-08  0.1064154731464000E-06
72 70  0.9660721459662000E-07 -0.1417964627719000E-07
72 71 -0.1376561388433000E-06  0.4206735867293000E-07
72 72  0.5598059775345000E-07  0.3799657419443000E-07
73  0  0.6442786448750999E-07  0.0000000000000000E+00
73 1 -0.4225292366018000E-07 -0.9079216066018999E-07
73 2  0.5399257756574000E-07  0.1055300866302000E-06
73 3 -0.9752136409805001E-07  0.2176208490181000E-07
73 4  0.6377561451644999E-07 -0.8882679368376000E-07
73 5 -0.1072556320841000E-06  0.5374698955394000E-08
73 6  0.1393957666099000E-06  0.1175711563430000E-06
73 7 -0.3715534649838000E-07  0.5373304386586000E-07
73 8  0.1366118155155000E-06  0.1150870168645000E-07
73 9 -0.1050723999159000E-06 -0.8196394258237001E-07
73 10  0.1168793538788000E-06  0.4132326988950000E-07
73 11  0.5162423406211000E-07 -0.3915867359407000E-07
73 12 -0.4024550522482000E-07  0.4507897923682000E-07
73 13 -0.2960669351455000E-08  0.1730153490628000E-07
73 14 -0.1052124497591000E-06 -0.5219651366770000E-07
73 15 -0.1383948421270000E-07 -0.1034446174951000E-06
73 16 -0.2561030620366000E-08  0.1219167947206000E-06
73 17 -0.5035819758556000E-07 -0.3892785831849000E-07
73 18  0.1625112991859000E-06  0.3212933069082000E-07
73 19  0.1127095619047000E-07 -0.5506936598256000E-07
73 20 -0.1104148478522000E-07  0.3349147773234000E-07
73 21  0.5983773335941000E-07  0.1200183651045000E-06
73 22 -0.5007126229956000E-07 -0.6014226540753000E-07
73 23  0.1391305567126000E-06  0.4439445798814000E-07
73 24 -0.5545798722570000E-07  0.1330334730715000E-06
73 25 -0.1756718657983000E-07 -0.9197449745101999E-07
73 26 -0.6590981262753000E-07  0.1540204396319000E-06
73 27 -0.7162257246667000E-07  0.2948432126173000E-07
73 28  0.2161229728554000E-09  0.6516872400648000E-07
73 29 -0.1482616335290000E-06 -0.4139735367161000E-07
73 30  0.4610982037587000E-07 -0.9400275779960001E-07
73 31  0.9103938940548000E-07 -0.3696162544113000E-07
73 32  0.5862037992039000E-08  0.3024018608543000E-07
73 33 -0.9219570856243000E-07  0.9244835542837000E-07
73 34 -0.1816494434044000E-07  0.1102300010418000E-06
73 35 -0.4731963715432000E-08  0.3948439060947000E-07
73 36 -0.2017672076544000E-07  0.3248522149047000E-07
73 37  0.1339901626916000E-06 -0.8863863368525000E-09
73 38  0.2654021340161000E-07  0.2819606491556000E-07
73 39  0.4599970260388000E-07 -0.1899492397809000E-07
73 40  0.8393275757861001E-08 -0.3659069746318000E-07
73 41  0.4258388079582000E-08  0.3613944147567000E-07
73 42 -0.1282657721681000E-06  0.1736512916134000E-07
73 43  0.9740633052734000E-07  0.3209086960054000E-07
73 44  0.1470371125558000E-07  0.5200769940022000E-07
73 45 -0.1797923328940000E-07 -0.7406421973386000E-07
73 46  0.4266395912052000E-08 -0.3360884371020000E-07
73 47 -0.6207942983740000E-07  0.1941710961846000E-07
73 48 -0.3389851710142000E-07  0.9691883024669000E-07
73 49  0.1237000729612000E-06 -0.1076470430581000E-06
73 50 -0.6533396355932000E-07  0.5281250292377000E-07
73 51 -0.1628713400786000E-07  0.2441785631967000E-07
73 52  0.3179827457920000E-07  0.7603535969487000E-08
73 53 -0.1344791082926000E-06  0.3681456663376000E-07
73 54  0.1497510259309000E-07 -0.6996536859290000E-07
73 55 -0.2380147588309000E-07 -0.6157317835491000E-07
73 56  0.2749864557619000E-07 -0.2591724836176000E-07
73 57  0.7751568253101999E-08  0.1225098168827000E-07
73 58 -0.3157084917364000E-07  0.2279290393842000E-07
73 59  0.1665316903583000E-07 -0.3535583699112000E-07
73 60  0.3822890815339000E-07 -0.9914075721879000E-08
73 61  0.4374459039562000E-07 -0.4298666253123000E-07
73 62  0.1397846178736000E-07  0.2621546057630000E-07
73 63  0.6858662448311000E-07 -0.5485859369639000E-07
73 64  0.4960643024290000E-08  0.9467612465974001E-07
73 65  0.1207303231461000E-06  0.1187995817534000E-07
73 66  0.2002611437159000E-07 -0.3393514244148000E-07
73 67  0.5041611511557000E-07 -0.1052835617818000E-07
73 68  0.3703782664150000E-07  0.4881251254418000E-08
73 69  0.1738822148942000E-07 -0.1024224105913000E-06
73 70 -0.6041563072695000E-07 -0.1151920371787000E-06
73 71 -0.4391877590940000E-07  0.5549102519054000E-08
73 72  0.4847057625415000E-07 -0.1578425979935000E-07
73 73 -0.8978620157562000E-07  0.2099479711882000E-07
74  0 -0.4491005360017000E-08  0.0000000000000000E+00
74 1 -0.4404589078240000E-07 -0.7912287426042000E-08
74 2 -0.1192522107479000E-06  0.5759599152041000E-07
74 3  0.5971956074956000E-07  0.2216547544330000E-07
74 4 -0.5406496012569000E-08 -0.2296311822803000E-07
74 5  0.6661613120616999E-07  0.1361885584193000E-07
74 6 -0.4173977803158000E-07  0.2301227359558000E-07
74 7  0.5884179440506000E-08 -0.6189189439522000E-07
74 8 -0.1497219086442000E-06 -0.6083133888153000E-07
74 9  0.4166625826062000E-07  0.3620504326626000E-07
74 10 -0.1574971122651000E-07  0.1992536533610000E-07
74 11 -0.1119496861783000E-06 -0.2476471482472000E-09
74 12 -0.3281615177390000E-07 -0.1573994664297000E-06
74 13  0.1155269041477000E-06 -0.1074650332539000E-06
74 14  0.2465915629728000E-07 -0.5386590007240000E-07
74 15  0.8127251993603000E-07  0.3303694271250000E-07
74 16  0.2548480495187000E-08 -0.2526586807991000E-07
74 17  0.5496222593185000E-07  0.1049583734107000E-06
74 18  0.5422218418642000E-07 -0.9458655874584000E-07
74 19 -0.8157468716590000E-07  0.4748872708610000E-07
74 20 -0.1024250669593000E-06 -0.1750869887507000E-07
74 21  0.3598963461683000E-07  0.5030275944315000E-07
74 22 -0.2763205552720000E-07 -0.4222232296162000E-07
74 23 -0.1730549334116000E-07 -0.6761185264275000E-08
74 24 -0.5352580439658000E-07 -0.8309996504997000E-07
74 25 -0.1010076898555000E-06 -0.1944384381051000E-07
74 26 -0.1737606814678000E-07  0.6318341401727001E-07
74 27 -0.3727940173955000E-07 -0.8962199741832000E-07
74 28 -0.6985614005115000E-07 -0.4335259880522000E-07
74 29 -0.2622251168622000E-08  0.6769663774239000E-07
74 30  0.7803883722639000E-07  0.3902284654276000E-07
74 31 -0.4002581775040000E-07  0.8770273085479000E-07
74 32 -0.6015361104737000E-07  0.2976151747749000E-07
74 33 -0.3237243396710000E-07 -0.3474026471433000E-07
74 34  0.2634377461990000E-07 -0.4768401927122000E-07
74 35  0.4872922800691000E-07 -0.4195394963597000E-07
74 36  0.4771228809080000E-07  0.5463413788613000E-07
74 37 -0.2100597959628000E-07 -0.2307335548726000E-07
74 38 -0.8520265604262001E-07  0.3961727838925000E-07
74 39 -0.1162329205962000E-07  0.1878759655292000E-08
74 40 -0.2144687729751000E-07 -0.3829329571396000E-07
74 41  0.3196211797696000E-07  0.3646793995807000E-07
74 42 -0.1599720710816000E-08  0.5819623570598000E-07
74 43  0.3071672197956000E-07  0.3609435598923000E-07
74 44  0.5550407512737000E-07 -0.4140816030280000E-07
74 45 -0.1436335411841000E-07 -0.2055532540770000E-07
74 46 -0.2676583504303000E-07  0.4937008848666000E-07
74 47 -0.8471666127034000E-08  0.7604525366778001E-07
74 48  0.2374312788959000E-07 -0.6901523717657000E-07
74 49  0.4165474183050000E-07  0.1954530723024000E-07
74 50 -0.8948578143136000E-07  0.7237633461618000E-07
74 51  0.1637049368699000E-06 -0.3703789497632000E-07
74 52 -0.6090578203233000E-07  0.3385244355387000E-07
74 53 -0.6628798979669000E-07  0.1009224549354000E-06
74 54  0.7100366110240000E-07  0.1915840229589000E-07
74 55  0.4230772213329000E-07 -0.1786515026333000E-08
74 56  0.8796167747592000E-07  0.5724300678896000E-07
74 57 -0.1417196954727000E-06  0.1122043920882000E-07
74 58 -0.2587735768978000E-09  0.5336067943293000E-07
74 59  0.7063715821262000E-07  0.8098449163020001E-08
74 60  0.3332193505447000E-07  0.4113451075597000E-07
74 61 -0.6230867133474000E-07  0.1389373409516000E-07
74 62  0.8855600812910000E-07  0.1057747391976000E-07
74 63 -0.1788971639856000E-07  0.7603437775601999E-07
74 64  0.4517124344172000E-07 -0.7992862744733000E-07
74 65 -0.5973233590029000E-07 -0.1150171801843000E-07
74 66 -0.6717104403185000E-07  0.1939481131719000E-07
74 67 -0.2835179113548000E-07 -0.6268564950289001E-07
74 68 -0.3271848297683000E-07  0.7937105173473000E-07
74 69  0.2497565238065000E-07  0.9721889868228000E-07
74 70 -0.4240024560413000E-07  0.3439427783740000E-07
74 71  0.5846034751670000E-07  0.9184324120384000E-07
74 72 -0.4594345368631000E-07  0.4205430632115000E-07
74 73  0.4940438476477000E-07  0.2665194449155000E-07
74 74  0.5870540320863000E-07 -0.3653637541452000E-07
75  0 -0.5445069350523000E-07  0.0000000000000000E+00
75 1 -0.4072947224211000E-07 -0.2708945981407000E-07
75 2  0.7387774375527001E-07  0.1244288402271000E-06
75 3 -0.4908919283001000E-07  0.5210743607984000E-07
75 4  0.7617363381444000E-07 -0.5457814174669000E-07
75 5 -0.7357511624098001E-07  0.1197921618474000E-07
75 6  0.9864208483994001E-08  0.4088399193110000E-08
75 7 -0.9597120830811999E-07 -0.7212136396308999E-07
75 8 -0.1114794874954000E-06 -0.5892183015656000E-07
75 9 -0.5658381400441000E-07 -0.2782969878915000E-07
75 10  0.6936729670675000E-07  0.7388606839260000E-07
75 11 -0.4350010553859000E-07 -0.2664930169085000E-07
75 12  0.5043672129168000E-07 -0.7895026140985000E-08
75 13  0.6765198869817000E-07  0.1452642603805000E-06
75 14 -0.2460369133765000E-07  0.6372415551793000E-07
75 15  0.3414826584266000E-07 -0.1636976011012000E-07
75 16 -0.2261266106779000E-07 -0.5881498463859000E-07
75 17 -0.1425979097716000E-06 -0.5671772140027000E-07
75 18  0.3572508901712000E-07  0.5208889948855000E-07
75 19 -0.7494969708918000E-07  0.8042322192853000E-07
75 20  0.7155898446612999E-07 -0.9884041332709000E-07
75 21 -0.5177942576211000E-07 -0.1060056467169000E-07
75 22 -0.7669932679889000E-07 -0.9304572454381000E-07
75 23  0.5071207625056000E-07  0.4845989194497000E-07
75 24 -0.8534419566467000E-08 -0.7609768907308000E-07
75 25 -0.4588566118272000E-08  0.6722959004046001E-07
75 26  0.1357596884045000E-08 -0.6781065154089000E-08
75 27  0.1253628939768000E-07 -0.1103390621796000E-06
75 28  0.1233374356523000E-06  0.6577250736417000E-07
75 29  0.2416597932656000E-07 -0.1977435055686000E-07
75 30 -0.8377108221977000E-07  0.2742872019790000E-07
75 31 -0.1325327070618000E-07 -0.1540012576409000E-07
75 32 -0.3257078315593000E-08  0.5337751545024000E-08
75 33 -0.2698821135068000E-09 -0.4535993956120000E-07
75 34 -0.1996262896008000E-07 -0.5116164893838000E-07
75 35  0.1639745865411000E-07 -0.6043750256420000E-07
75 36 -0.4817662764145000E-07 -0.9773037999209000E-07
75 37 -0.1043067255550000E-07 -0.1733785489770000E-07
75 38 -0.5179506734189000E-07 -0.6234935393221001E-07
75 39  0.6450944002672001E-07 -0.2423819487607000E-07
75 40  0.4019199124632000E-07 -0.1583522536048000E-07
75 41 -0.2688153271264000E-07  0.6309490098548000E-07
75 42  0.4119523202464000E-07 -0.6370135148949000E-07
75 43  0.1714839096560000E-07 -0.2208116255339000E-07
75 44  0.1612674755372000E-07 -0.1968615194348000E-07
75 45 -0.1517537482625000E-06 -0.3194664861265000E-07
75 46  0.9820666975138000E-08 -0.8293125659901001E-07
75 47 -0.1624748213222000E-07  0.3755303205702000E-07
75 48 -0.4605572717231000E-08 -0.4926250329298000E-09
75 49 -0.4522878172266000E-09 -0.7332456448638000E-07
75 50  0.3856382508322000E-07 -0.1523624268124000E-07
75 51  0.1805460347664000E-08  0.1096284452533000E-07
75 52 -0.2603575916039000E-07  0.2556662717541000E-07
75 53  0.7309903201841000E-08 -0.1160914471287000E-06
75 54  0.5735330834598000E-07 -0.5545576144706000E-07
75 55 -0.3144241089681000E-07  0.3878703324789000E-07
75 56 -0.9112030527916000E-07  0.4993103262254000E-07
75 57 -0.9700417501849000E-07 -0.6865132936318000E-07
75 58  0.1147152290015000E-06  0.9696275109423000E-07
75 59 -0.7614052203635999E-08 -0.4313009531725000E-07
75 60  0.2178617058725000E-07  0.8927630563679001E-07
75 61 -0.4142188676255000E-08 -0.7968967302027000E-07
75 62 -0.1705536884390000E-07  0.8729648016218001E-07
75 63 -0.1351949346136000E-06  0.5397960042873000E-07
75 64  0.6968227235058000E-08  0.2301446691233000E-07
75 65  0.1320262901415000E-07  0.1917224792757000E-06
75 66 -0.3421208465484000E-07 -0.9392944364821999E-07
75 67  0.4730518696103000E-07 -0.3080335749810000E-07
75 68  0.8181839332827000E-07  0.7623930011674000E-07
75 69  0.7249462403668000E-08 -0.1120489338298000E-08
75 70 -0.1244241462421000E-06 -0.3210422347329000E-07
75 71  0.1796154064169000E-07  0.1851874123371000E-07
75 72 -0.2678746010192000E-07 -0.1338173481457000E-06
75 73  0.2173757966529000E-07 -0.3073578383287000E-07
75 74 -0.8331894096233000E-07 -0.9657723384004001E-07
75 75  0.4173471789191000E-07  0.1533714704260000E-07
76  0 -0.6376932018993000E-07  0.0000000000000000E+00
76 1  0.1181197722557000E-06  0.8359673178689000E-07
76 2 -0.8099032897874000E-07 -0.4320774359422000E-07
76 3  0.1154449917906000E-07 -0.4912892099994000E-07
76 4  0.1365575018013000E-07 -0.9427505808911000E-07
76 5 -0.2187004177673000E-07  0.8053722552621000E-07
76 6 -0.5158992859358000E-07 -0.2800872145257000E-07
76 7 -0.5350842662223000E-07 -0.2221430710958000E-07
76 8 -0.6153867487588001E-07  0.9163310243382000E-07
76 9  0.6944866910981001E-07 -0.8212326416015000E-08
76 10 -0.5570339014020000E-07 -0.6122543712097000E-08
76 11  0.2269883819140000E-07 -0.1315468954704000E-06
76 12 -0.6716864854781000E-08 -0.2285095873788000E-07
76 13  0.4174059768216000E-07 -0.1388021782236000E-06
76 14 -0.7075068302405000E-07  0.4560264940610000E-08
76 15 -0.9548635900854000E-07  0.6855935612757000E-07
76 16 -0.1109201099081000E-06 -0.7002697360402001E-07
76 17  0.1921182371234000E-07  0.8950749791594999E-08
76 18  0.4297419680051000E-07 -0.5351770151184000E-08
76 19 -0.3275532887651000E-07 -0.9058302431827000E-09
76 20 -0.2734886952487000E-07 -0.1630257069912000E-07
76 21  0.1008539924325000E-07  0.4291684863619000E-07
76 22  0.1011920651387000E-06 -0.3808138640112000E-07
76 23  0.9770016236626000E-08  0.7832949272830000E-07
76 24  0.5253372326138000E-08  0.9262171808901000E-07
76 25 -0.4789913079898000E-07  0.1630565624028000E-07
76 26 -0.3655916462832000E-07  0.5267578788277000E-07
76 27 -0.3008832161651000E-07 -0.5653732484867000E-07
76 28 -0.2313329648333000E-07  0.5856542950194000E-07
76 29 -0.9049096789138000E-07  0.6880745258205001E-07
76 30 -0.5978484129730000E-07  0.7019734257009001E-07
76 31  0.9212169904542000E-07  0.6850020386048000E-07
76 32  0.3458233336227000E-07 -0.6354868361631000E-07
76 33 -0.3163796185502000E-08 -0.1263560023837000E-06
76 34  0.7718444293680000E-08  0.1168174050669000E-06
76 35 -0.3464155125170000E-08  0.4994996965390000E-07
76 36 -0.1173027233986000E-06  0.5752075926846000E-08
76 37  0.9530100571529999E-07  0.2269378441278000E-08
76 38  0.9108865760967001E-08  0.3820671394549000E-07
76 39 -0.4896602018253000E-08  0.5217139583888000E-07
76 40  0.3644394839293000E-07 -0.2113321948051000E-07
76 41  0.1029127383072000E-06  0.4888581004814000E-07
76 42  0.3470769122205000E-09  0.2674301711707000E-07
76 43 -0.6934243739579000E-07 -0.7238565031595000E-08
76 44 -0.2833205372973000E-07  0.3739115100399000E-07
76 45 -0.1195084768113000E-06  0.3029056313652000E-07
76 46  0.3909449393863000E-07  0.5869278666704000E-07
76 47  0.2360065182224000E-07 -0.5832611770412000E-07
76 48  0.4097357658249000E-07 -0.5707263570275000E-07
76 49 -0.9613887394503999E-07 -0.9406670787383000E-08
76 50 -0.1323983709691000E-07  0.9392719344025000E-07
76 51  0.5570661514433000E-07 -0.3115986391893000E-07
76 52 -0.5156556422413000E-08 -0.4332845232571000E-09
76 53 -0.6638951992416000E-07  0.9235380533594999E-08
76 54 -0.1902929641796000E-07  0.1505780753074000E-07
76 55  0.3524210369819000E-07 -0.7913263405114000E-09
76 56 -0.8064832993533001E-08 -0.1021980707549000E-06
76 57  0.1279143642854000E-06 -0.3771755308356000E-07
76 58  0.2552097331765000E-07  0.8813010462636000E-08
76 59 -0.7214978546547000E-07 -0.9434621594032000E-07
76 60 -0.7532318698620999E-07  0.1812609760014000E-07
76 61 -0.6879167240279000E-07  0.1506111880988000E-07
76 62 -0.6229598486588000E-07  0.8170235197069001E-07
76 63  0.1276577648580000E-06 -0.1280571053149000E-06
76 64  0.6175728093533999E-07 -0.7697645517048999E-07
76 65 -0.2919471554267000E-07 -0.9494727205279000E-07
76 66 -0.7561849956424001E-07 -0.8197266929682000E-07
76 67  0.4320154107444000E-07  0.2194088437645000E-07
76 68 -0.3769849822702000E-07 -0.4294631210706000E-07
76 69  0.3140910055584000E-07 -0.4538777012694000E-07
76 70  0.4151782778195000E-07 -0.7110435226079000E-07
76 71 -0.1681828799998000E-07  0.1964194876280000E-07
76 72  0.4914286275626000E-07 -0.4798733882788000E-07
76 73 -0.3725981761098000E-07  0.3712713453293000E-07
76 74  0.2266051341423000E-07 -0.3223536796676000E-07
76 75  0.4330744053344000E-08  0.5608677600359000E-07
76 76 -0.2305315967939000E-07  0.1007028686957000E-06
77  0  0.6958065312414999E-07  0.0000000000000000E+00
77 1  0.3783068154725000E-07 -0.2820622513487000E-07
77 2 -0.8979675279606000E-08  0.6843398330142000E-07
77 3  0.4887628067222000E-07 -0.6673893844442000E-07
77 4  0.4419835859269000E-08  0.2536860992834000E-07
77 5 -0.9142898221258000E-07  0.1610757703077000E-06
77 6  0.1880469951368000E-07 -0.4693677583581000E-07
77 7  0.8245106259683000E-07 -0.3832788554316000E-07
77 8  0.3775672527023000E-07 -0.8138927607770000E-07
77 9  0.3293153218104000E-07  0.2188385686065000E-07
77 10 -0.3191576530843000E-07 -0.3451177850266000E-07
77 11  0.7924449246657000E-07  0.8187342311654999E-07
77 12 -0.4595443147893000E-07  0.1038707375124000E-06
77 13 -0.2591516721787000E-07  0.7471495416057000E-08
77 14 -0.8863970318624001E-07  0.6504127514862999E-07
77 15  0.3044813569422000E-08 -0.6967942400258000E-07
77 16 -0.1756546631891000E-07 -0.3025860225820000E-07
77 17  0.3327407774131000E-07  0.2035000841287000E-07
77 18  0.1024670240125000E-06  0.9273718579942000E-07
77 19 -0.8058594917610000E-08 -0.1674733151127000E-06
77 20 -0.8150294862517000E-07  0.8035554068806999E-08
77 21 -0.3311756007505000E-07  0.8243847603502000E-07
77 22 -0.6811415380376999E-07 -0.7784884562385000E-07
77 23  0.5552231495873000E-08  0.9920409429822000E-07
77 24 -0.1113362083004000E-06 -0.7698901741667000E-07
77 25 -0.1005682991335000E-06 -0.1107886898414000E-06
77 26 -0.8737509092905000E-08 -0.9897879414905000E-07
77 27 -0.2653496805777000E-10 -0.4762081501223000E-08
77 28  0.1302309940160000E-06  0.1112180594182000E-07
77 29  0.5096413835889000E-08 -0.2451636770916000E-07
77 30 -0.2811961059970000E-07 -0.3986457544182000E-07
77 31  0.2642845914187000E-07 -0.2473166555843000E-07
77 32 -0.1585885911068000E-07 -0.6536113656533999E-07
77 33 -0.1032979362975000E-06  0.2835155235918000E-07
77 34 -0.1152879670320000E-07 -0.5452742847780000E-08
77 35 -0.2864588452399000E-07 -0.6507845375516001E-07
77 36  0.1298372313101000E-06  0.7633903753880001E-08
77 37  0.3997832352272000E-07  0.1046811031245000E-07
77 38  0.7399865076914000E-07  0.2594764204564000E-07
77 39 -0.4836246572749000E-08  0.4227074871407000E-07
77 40  0.6111146915457000E-07 -0.1108906617469000E-06
77 41 -0.6796698911937000E-07  0.6321462482977001E-07
77 42 -0.2497595427621000E-08 -0.3832858080949000E-07
77 43 -0.5810556966481000E-07 -0.2988879013303000E-07
77 44 -0.1120878991527000E-07  0.1101207940156000E-07
77 45 -0.5189453352590000E-07  0.1219755704516000E-07
77 46  0.1300859438258000E-06  0.1343011916557000E-07
77 47 -0.4657529956886000E-07 -0.7033549148704000E-07
77 48 -0.2611153130527000E-07  0.1213846144267000E-06
77 49  0.3749015222782000E-08  0.3200309217083000E-07
77 50  0.7466609200749000E-07 -0.6490007282905000E-07
77 51 -0.4918788205864000E-07 -0.3317072063266000E-07
77 52  0.1547145314680000E-07 -0.3212440073410000E-08
77 53  0.2483612309279000E-07 -0.4272075392191000E-07
77 54  0.1563476196741000E-07  0.7301883174101000E-07
77 55  0.7055199745489000E-07  0.1254449039495000E-06
77 56 -0.5523175822337000E-07  0.1212259856341000E-06
77 57  0.1921241342780000E-07  0.7876788037252000E-07
77 58 -0.1083732246694000E-07  0.1100873092439000E-06
77 59  0.1993507499502000E-07  0.3423613511055000E-07
77 60  0.5188131931533000E-07 -0.6250778767440000E-07
77 61  0.1497408919089000E-07 -0.5515065232377000E-07
77 62  0.6055805617893000E-07  0.6289642459144000E-07
77 63  0.4187701380457000E-07 -0.6616168778746000E-07
77 64 -0.1738104750914000E-06  0.1038008947109000E-06
77 65 -0.2856753724081000E-07  0.6930745444251000E-07
77 66  0.1594465283131000E-08  0.1309827965968000E-07
77 67  0.1558161211422000E-06 -0.2825338257930000E-08
77 68  0.3365682172949000E-08  0.2000913548000000E-08
77 69 -0.7810670700363000E-09  0.5603269807802000E-07
77 70 -0.1021260899512000E-06  0.4996883471589000E-08
77 71 -0.5494344787737000E-07  0.6909216859264000E-07
77 72  0.3454395466783000E-07  0.2504811720892000E-07
77 73 -0.4696052758663000E-07  0.6975665227259999E-07
77 74  0.7639743151159999E-08  0.6373064584534001E-07
77 75  0.1834009819330000E-07  0.1066935152091000E-06
77 76 -0.7861629751290000E-08  0.3573010279671000E-08
77 77 -0.3596428370139000E-07 -0.6724245754959000E-07
78  0  0.8660903540955000E-07  0.0000000000000000E+00
78 1 -0.9119595987075000E-07 -0.1527020436312000E-07
78 2  0.5636961691090000E-08 -0.5365568389331000E-07
78 3  0.4807265716157000E-07  0.4470054464028000E-07
78 4 -0.4054993651766000E-07  0.3559016472654000E-07
78 5  0.5844792855379000E-07  0.6171428947586000E-07
78 6  0.9845301857385000E-07 -0.5562637283682000E-07
78 7  0.2171862389718000E-07 -0.2291640425066000E-07
78 8 -0.1859665494876000E-07  0.1492240423620000E-06
78 9  0.1582962390742000E-07 -0.5367073940988000E-08
78 10  0.4140509722897000E-07 -0.9558997242082000E-08
78 11 -0.3293327878400000E-07 -0.7591196688599000E-07
78 12 -0.7037505332290000E-07 -0.3634967540580000E-07
78 13 -0.4454444607460000E-07 -0.4510384980610000E-07
78 14  0.1561942034583000E-07 -0.3279775158331000E-07
78 15 -0.6224460180377000E-08  0.5586631317491000E-07
78 16 -0.1931253729626000E-07 -0.4129546831516000E-07
78 17  0.1691402979832000E-07 -0.4800532635131000E-07
78 18 -0.8198437400848000E-08 -0.7000482909952000E-07
78 19 -0.3673208743753000E-07  0.2643793530591000E-07
78 20  0.4398839741993000E-07  0.5734646324529000E-07
78 21 -0.6672000472033001E-07  0.2217583979008000E-07
78 22  0.1646589477530000E-07 -0.7155225111447001E-07
78 23  0.5925240442042000E-08  0.1535833440983000E-07
78 24  0.1735461736275000E-07 -0.9507239843570000E-07
78 25  0.8032422569361000E-07  0.3954655269435000E-07
78 26  0.7869581096835000E-07  0.9707428743734000E-08
78 27  0.1366678797411000E-06  0.2085373084927000E-08
78 28 -0.6254433483318000E-07 -0.4658382061551000E-07
78 29 -0.2284130439734000E-07  0.8284531532924999E-07
78 30 -0.2317177555079000E-07  0.4600913285014000E-07
78 31 -0.3536883268567000E-07 -0.3698812615964000E-07
78 32 -0.2626097408639000E-07  0.1141014243154000E-08
78 33  0.1002242005681000E-07  0.2385334520592000E-07
78 34 -0.8790207137626000E-08  0.1035956931555000E-06
78 35 -0.1905276807716000E-07  0.4285612037185000E-07
78 36  0.4050381421311000E-07  0.2046393058411000E-07
78 37  0.2080867894020000E-07 -0.4103014537405000E-07
78 38 -0.4027650808726000E-07  0.9619574237731001E-07
78 39  0.1366514544884000E-07 -0.2975670891565000E-07
78 40  0.6649171375792000E-07  0.8658541002486000E-08
78 41 -0.4401391937559000E-07 -0.2709721078340000E-07
78 42  0.5196473366585000E-07 -0.4788500184627000E-08
78 43  0.3559559049088000E-07  0.7538136642976000E-07
78 44  0.2633056901670000E-07 -0.4240501129105000E-07
78 45  0.6763790766080000E-07 -0.1098578669414000E-06
78 46  0.6042240504408000E-07 -0.6945101512840000E-07
78 47 -0.1040505251265000E-06 -0.1110941084850000E-06
78 48  0.8823011991504000E-07  0.1622564068505000E-07
78 49  0.1014101202494000E-06 -0.2892840072577000E-07
78 50 -0.9013693868040999E-07  0.5011660102189000E-07
78 51 -0.5162710268806000E-07  0.1213089838684000E-06
78 52  0.1248651334393000E-07  0.2965461145738000E-08
78 53  0.3207599236790000E-07  0.2130384711510000E-07
78 54 -0.8647532649474000E-07  0.2987126880796000E-07
78 55 -0.5142436588559000E-07 -0.1743156115348000E-06
78 56 -0.8609970171257000E-07 -0.7385143207421000E-08
78 57 -0.5871976332996000E-08 -0.4188574876250000E-07
78 58  0.2439300887898000E-07 -0.6468513207099001E-07
78 59 -0.5340022492378000E-07 -0.1080612688565000E-06
78 60 -0.3414271341833000E-07 -0.2476015805202000E-07
78 61 -0.9022921275335000E-07  0.1699849292533000E-06
78 62 -0.7249558008278999E-07 -0.5793503781012000E-07
78 63 -0.4018148231679000E-07 -0.5594904790535000E-07
78 64 -0.7467672823212999E-07 -0.6271165317761000E-08
78 65  0.3869193701537000E-07 -0.8572234614066999E-07
78 66  0.2373440026872000E-07  0.1803748070537000E-07
78 67 -0.8043855878040000E-07  0.4264923974089000E-08
78 68  0.1244395538069000E-07  0.1281155101753000E-06
78 69 -0.5857647685096000E-07  0.3770375309619000E-07
78 70  0.8407779535905000E-07  0.4244346721515000E-08
78 71  0.1738611231352000E-07 -0.9445773462079000E-08
78 72  0.3360565586842000E-07 -0.7314261473778000E-07
78 73  0.2586755841003000E-07 -0.6146776932959000E-07
78 74  0.4404768444983000E-07 -0.3306626505413000E-08
78 75 -0.3202217072399000E-07 -0.5925806080737000E-07
78 76  0.2981577102492000E-07  0.5408282179390000E-07
78 77  0.1234184935080000E-07 -0.6167404486885000E-07
78 78  0.3597580694603000E-07  0.3085919474632000E-07
79  0 -0.6767658865095000E-07  0.0000000000000000E+00
79 1 -0.8226423797268000E-07  0.3625658223933000E-07
79 2  0.4971595082893000E-07  0.7378793457820000E-07
79 3  0.5047269754973000E-07 -0.3996159062675000E-07
79 4  0.2027748371851000E-08 -0.2376750481551000E-07
79 5 -0.1715363946983000E-08  0.4999749303898000E-07
79 6 -0.5101368831912000E-07 -0.1698274921634000E-08
79 7  0.4720307794207000E-07  0.5466288707731000E-07
79 8 -0.3295989381853000E-07 -0.7400435901875000E-07
79 9  0.1535131050509000E-07 -0.8081456658012000E-07
79 10 -0.1195721044696000E-06  0.3827708081860000E-07
79 11 -0.5959862971144000E-07  0.4885623342317000E-07
79 12  0.6420808729874000E-07  0.1070981688458000E-06
79 13  0.4932527407016000E-07 -0.3623114757639000E-07
79 14 -0.4028730626982000E-07  0.1492002630176000E-07
79 15  0.2086168858818000E-07 -0.1224934452407000E-06
79 16  0.1095759184581000E-07 -0.6093915142060000E-08
79 17  0.5992206075571999E-07  0.1017280333690000E-06
79 18  0.5358826980014000E-07  0.1083430378181000E-06
79 19  0.1553830823588000E-08 -0.1190054611150000E-07
79 20 -0.5264408904356000E-07  0.2731845431992000E-07
79 21 -0.3969146999465000E-07 -0.5179993401264000E-07
79 22  0.4970907506790000E-08  0.4020239732752000E-07
79 23  0.3784118615643000E-07  0.5118977580583000E-07
79 24  0.5732420922745000E-07  0.8055095021882000E-07
79 25 -0.1127061652906000E-07  0.1035017411794000E-06
79 26  0.9370922867142001E-08 -0.5085119652229000E-07
79 27  0.6073346852006000E-07  0.1571800794735000E-07
79 28 -0.6831260454719000E-07  0.8644737019539000E-07
79 29 -0.7228871643014999E-07 -0.7166141785902000E-07
79 30 -0.3628127825700000E-07 -0.1202012577031000E-06
79 31  0.9223784736776000E-07 -0.1557859263173000E-07
79 32  0.2370584516977000E-07 -0.1173235337791000E-07
79 33 -0.2957014174230000E-07  0.7205711386115000E-07
79 34 -0.2499717226883000E-07 -0.3869311575028000E-07
79 35  0.9916248498894000E-07 -0.2494655259470000E-07
79 36  0.1904238282322000E-07 -0.5980169613126000E-07
79 37  0.3615430592723000E-07  0.9668458674912001E-08
79 38  0.6446460254146000E-07  0.3013386230648000E-07
79 39 -0.7977014801170000E-07 -0.7514011422709000E-07
79 40 -0.6282754833238000E-07  0.2190578048390000E-07
79 41 -0.2165548091076000E-07  0.9458263019474000E-07
79 42 -0.2334651255116000E-07 -0.6843887292563999E-07
79 43  0.1941073316536000E-07  0.1820220456740000E-07
79 44  0.2587349010619000E-07 -0.5274751903932000E-07
79 45 -0.2517111960256000E-07 -0.2051332755920000E-07
79 46 -0.1359563014247000E-07  0.2625947577101000E-07
79 47 -0.6331809696786000E-07  0.4956266855118000E-07
79 48  0.7804966370447001E-07  0.8990960393225000E-07
79 49 -0.7765232537664000E-07  0.1781609801482000E-07
79 50  0.2146395280986000E-07 -0.6360304837581000E-07
79 51  0.5188614791747000E-07 -0.1129584918807000E-07
79 52  0.6284145441935000E-08  0.1519671503027000E-08
79 53 -0.1323165072691000E-07  0.4706108425024000E-07
79 54  0.4129935416882000E-07 -0.9534765463916000E-08
79 55  0.3002371260644000E-07  0.7023780466425000E-07
79 56  0.2427312339633000E-07  0.6172878662930001E-07
79 57  0.3636092751053000E-08  0.3269987919509000E-07
79 58  0.4300119074812000E-07 -0.4385222175385000E-07
79 59 -0.4241504664237000E-07 -0.5173825561196000E-07
79 60  0.1584232677556000E-07  0.1942413356042000E-07
79 61 -0.3589966488845000E-07  0.1079503996726000E-07
79 62  0.3074392487758000E-07 -0.1411734763170000E-06
79 63  0.5371756337407000E-07 -0.5893737448807000E-08
79 64 -0.7465100826379999E-07  0.4878310741553000E-07
79 65  0.1547703853085000E-06  0.2844584813208000E-07
79 66 -0.1789862528840000E-07 -0.7752158044195000E-07
79 67  0.8590272583607000E-07  0.2057174654589000E-08
79 68  0.4364365380674000E-07 -0.6039412933900000E-07
79 69 -0.8248714889997999E-07 -0.1354118863003000E-06
79 70  0.9651620461419000E-07 -0.8608959790848001E-07
79 71 -0.6625975866444000E-07 -0.6860465567320001E-07
79 72  0.4004164257614000E-07  0.3013932580336000E-07
79 73 -0.7931135638142000E-07  0.1119638722099000E-07
79 74 -0.1376785294999000E-07 -0.3459689788113000E-07
79 75  0.5606206274859000E-07  0.2791286363004000E-07
79 76  0.6375077565471000E-08  0.2209892895195000E-07
79 77 -0.7722562136125000E-07 -0.3330896599186000E-07
79 78 -0.2382828677741000E-08 -0.4778006554680000E-08
79 79  0.1028122470585000E-06  0.3473141789470000E-07
80  0  0.2466156530717000E-08  0.0000000000000000E+00
80 1  0.1184581155840000E-07  0.2145351821337000E-07
80 2  0.8489189664720000E-07  0.4685700526565000E-07
80 3 -0.2735502899874000E-07  0.9744437757113000E-07
80 4 -0.1621639866060000E-07  0.7905193776285000E-07
80 5 -0.3837785844818000E-07  0.2381358337288000E-07
80 6  0.3094289053067000E-07 -0.4736805099946000E-07
80 7 -0.3234174154817000E-08  0.1648441294204000E-07
80 8  0.1537098768302000E-07 -0.1821447237349000E-07
80 9  0.5993005829208000E-07  0.5530103408884000E-07
80 10 -0.6355363340644000E-07  0.7354041035973000E-07
80 11  0.4104711079114000E-07  0.2412301124548000E-07
80 12  0.1646913665857000E-07 -0.7496982391493001E-07
80 13 -0.5761420678006000E-07  0.5703829509123000E-07
80 14  0.6177951536769000E-07 -0.1244225910055000E-07
80 15 -0.6132674939597000E-07  0.6772273856115000E-08
80 16  0.2821204502577000E-07  0.6863153773895000E-07
80 17  0.6616515579080000E-07 -0.6461510846616000E-08
80 18 -0.5249228727352000E-07  0.8279649596236000E-08
80 19 -0.2961749002138000E-08 -0.1642277290210000E-07
80 20 -0.1114184441144000E-07 -0.4989141806839000E-07
80 21 -0.1604782718550000E-07  0.5499399414107000E-07
80 22  0.2124305210208000E-08  0.7539930888108000E-07
80 23  0.3794762765002000E-07 -0.1772557443968000E-07
80 24  0.8523536946991000E-07 -0.1265515982285000E-07
80 25 -0.2183672815829000E-07 -0.7856382403093000E-07
80 26  0.1026220138410000E-07 -0.6327998062115999E-07
80 27 -0.5159509529783000E-07  0.6167797889040001E-07
80 28 -0.2372382677406000E-07 -0.6184307805938000E-07
80 29  0.7375597119552000E-07  0.8073669155573999E-08
80 30  0.5155080183126000E-07  0.5728327658943000E-07
80 31 -0.5451054511228000E-07  0.4782109254667000E-07
80 32  0.5060759151166000E-07  0.9604166100755000E-08
80 33  0.6099077212483000E-07 -0.9273404227098000E-08
80 34  0.2639288212814000E-07 -0.4697582048691000E-07
80 35 -0.1060610240499000E-06  0.3092398513660000E-07
80 36 -0.2385820832876000E-07  0.1066770236142000E-08
80 37  0.2465078100997000E-07  0.2330659373409000E-07
80 38 -0.6302624075166000E-07  0.3058268615721000E-07
80 39  0.6284957189326000E-07  0.1378894614212000E-06
80 40 -0.4524932607261000E-07  0.1497194634395000E-08
80 41  0.3097463636255000E-07 -0.6106796574977000E-07
80 42  0.4745199729213000E-07 -0.4895731397505000E-08
80 43  0.4986274477618000E-07 -0.1861986741531000E-07
80 44 -0.9526877787616000E-07 -0.2538697450213000E-07
80 45  0.2344940879039000E-07  0.6002682053934000E-07
80 46  0.9277721190621000E-07 -0.8264622752504000E-07
80 47 -0.1615434245805000E-07  0.5529908638718000E-07
80 48  0.8397628747132999E-07  0.2337500197786000E-07
80 49 -0.1959457544757000E-07 -0.3747436448021000E-07
80 50  0.7495829428900999E-07 -0.2798411094363000E-07
80 51 -0.1380580306369000E-06  0.2238688490240000E-07
80 52  0.9247551668406999E-07  0.4895838032347000E-07
80 53 -0.7316932515115000E-08 -0.1555514107170000E-06
80 54  0.7815768882562000E-07 -0.7487875988123000E-09
80 55  0.2117349785984000E-07  0.6618614449504000E-07
80 56 -0.1131197749302000E-07 -0.4628742823913000E-07
80 57  0.6190069965989000E-07 -0.2260823749270000E-07
80 58  0.1606802499228000E-07 -0.8870116462969000E-08
80 59  0.4054895267983000E-07  0.8008216396732999E-07
80 60  0.1391828561778000E-06  0.1288881152154000E-07
80 61  0.2108486771618000E-07 -0.4379895944011000E-07
80 62  0.9569808408287000E-07 -0.8813331117350000E-07
80 63  0.3617270879485000E-09  0.1084140931092000E-06
80 64 -0.1008986842022000E-07  0.2455212833457000E-07
80 65  0.3157323841890000E-07  0.3439101977577000E-08
80 66 -0.7931962853679000E-07  0.4609622057198000E-07
80 67 -0.1067399821842000E-07 -0.1621426454159000E-07
80 68 -0.6338844977155000E-08  0.3745116262213000E-07
80 69 -0.2249944688740000E-07  0.9028513090041000E-07
80 70  0.6401049292187000E-07  0.5660211810655000E-07
80 71  0.2477902320607000E-07  0.7724913675195000E-07
80 72  0.4291814261666000E-07  0.4072863777068000E-07
80 73 -0.5310350684644000E-07  0.1318942771313000E-07
80 74  0.1072080635381000E-06  0.5993953612471000E-07
80 75 -0.3328344107217000E-07  0.1136018630815000E-06
80 76 -0.2537526741087000E-07 -0.2473551359420000E-07
80 77  0.7878859075209000E-08 -0.7552166340929000E-07
80 78  0.4671269709510000E-07  0.3150115288246000E-07
80 79  0.4452449330324000E-07 -0.3617112902845000E-08
80 80 -0.1105663446511000E-06  0.3865898740056000E-07
81  0  0.3299402009048000E-07  0.0000000000000000E+00
81 1  0.1039106959689000E-06 -0.9577572670909999E-08
81 2  0.3984667024208000E-07  0.2862601525114000E-07
81 3 -0.7695850823333000E-08 -0.6665058961105999E-07
81 4 -0.1007104050502000E-06  0.5853845073834000E-07
81 5 -0.6938356422041000E-07 -0.6467568418001000E-08
81 6  0.5765333488802000E-07  0.2408213023477000E-07
81 7 -0.6649523639831000E-07 -0.7066869263368999E-07
81 8  0.5809294433130000E-07  0.7503430433996000E-07
81 9 -0.2838564201915000E-07  0.5044837292178000E-07
81 10 -0.1248042624876000E-07  0.9250790373369999E-07
81 11  0.4395246357536000E-07  0.1505997487089000E-07
81 12 -0.5179312772724000E-07 -0.2618895104276000E-07
81 13  0.1945923488536000E-07 -0.8496782456180000E-07
81 14  0.3506391837311000E-07  0.3486464256660000E-07
81 15 -0.1634787583951000E-07 -0.4331353468882000E-07
81 16  0.8545882929688001E-07  0.1413401668880000E-06
81 17 -0.8811698374012000E-07  0.3068196991538000E-07
81 18  0.4949847651495000E-07 -0.1108490536149000E-06
81 19 -0.7463925815240999E-07 -0.4271681962436000E-07
81 20  0.4136468747990000E-07  0.9659888120124999E-07
81 21  0.9488358252003000E-07 -0.7095083194184000E-07
81 22 -0.4063750245798000E-07 -0.4612492526530000E-07
81 23  0.5930094437602000E-07 -0.1472235758556000E-07
81 24 -0.6923267055218000E-07 -0.6411901388490000E-08
81 25 -0.7283079452591000E-07  0.1409478138103000E-06
81 26  0.2022596825560000E-07 -0.2695203924011000E-07
81 27 -0.3349397469918000E-07  0.5043269271622000E-07
81 28  0.3949997901845000E-07  0.3668918595074000E-07
81 29 -0.2502220774928000E-08  0.6781168374046000E-08
81 30  0.2117768873782000E-08 -0.4708843482462000E-07
81 31  0.4666384449990000E-07 -0.1669220592467000E-07
81 32 -0.3646155871014000E-08  0.2287407564008000E-07
81 33 -0.6045329736933000E-07 -0.4444120693774000E-07
81 34  0.4233622303727000E-07  0.3364212618907000E-07
81 35 -0.9279999727987000E-07  0.8234115962024000E-07
81 36  0.2864891957960000E-07 -0.2118932105047000E-07
81 37 -0.2174026753507000E-07  0.2709078164852000E-07
81 38 -0.3256773675406000E-08  0.2643928662043000E-07
81 39 -0.3072521165572000E-07 -0.3671560520217000E-07
81 40 -0.6510306191952000E-07 -0.2600170523698000E-07
81 41  0.8870103938512000E-07 -0.4098307710928000E-07
81 42 -0.6635573870484000E-07 -0.5578110124345000E-07
81 43 -0.6287502096722001E-07  0.5601744142365000E-07
81 44  0.1023618346669000E-06  0.8153327513936000E-07
81 45 -0.1801889402868000E-07  0.5432421697279000E-07
81 46 -0.6156960382826000E-07 -0.3269737957708000E-07
81 47  0.5021851224932000E-08  0.4746951148263000E-07
81 48 -0.2119631467689000E-07 -0.1371898435409000E-07
81 49  0.1563358103842000E-09 -0.4370021380777000E-07
81 50  0.6967611647964000E-07  0.9346576560062000E-07
81 51  0.4035723815426000E-07  0.1018012273638000E-06
81 52  0.7299292591835999E-07 -0.3913239842079000E-08
81 53 -0.7225230148370000E-07  0.4952561430758000E-07
81 54  0.1306345199545000E-07  0.1640439064365000E-06
81 55 -0.9279445677610001E-08  0.2934638951116000E-07
81 56 -0.1768707084391000E-07 -0.7257434840096000E-07
81 57 -0.2576066970604000E-07  0.1684581581457000E-07
81 58 -0.9930598143256000E-08  0.2143472526770000E-07
81 59 -0.4251691478713000E-07 -0.1670055435786000E-07
81 60 -0.1008717092076000E-06 -0.2762175481247000E-09
81 61 -0.3267037475336000E-07 -0.2316341640993000E-07
81 62 -0.2789346526330000E-07  0.3135873424883000E-07
81 63 -0.7315486119261001E-07  0.5315677319686000E-07
81 64 -0.7461869210307000E-07 -0.7159136624732999E-07
81 65 -0.3156668187475000E-07 -0.8621806654383000E-07
81 66  0.4751889918107000E-07  0.3759770867762000E-07
81 67  0.4573410711073000E-07  0.3032995528724000E-07
81 68 -0.3214953556851000E-07  0.2536192553410000E-07
81 69 -0.7452038143259000E-07  0.5042032706079000E-07
81 70  0.4044753589758000E-07 -0.5743738546560000E-07
81 71 -0.2667947583648000E-07  0.4951946380773000E-08
81 72 -0.4166498888795000E-07 -0.1615619486498000E-08
81 73 -0.5534972876038000E-07 -0.3758621680938000E-11
81 74 -0.2580633284069000E-07 -0.2359642458953000E-07
81 75  0.7669364803458000E-09 -0.4884679329040000E-08
81 76  0.2940979350995000E-07 -0.6147832541572999E-07
81 77 -0.6245770115067000E-08  0.7915776144637000E-07
81 78 -0.5827177789124000E-07  0.6643617740551000E-08
81 79  0.2263255279683000E-07 -0.6337755866209000E-07
81 80 -0.1742505957802000E-07 -0.4884021352923000E-07
81 81 -0.2185152169726000E-07  0.4451290978247000E-07
82  0  0.3320560599666000E-07  0.0000000000000000E+00
82 1 -0.3558599917129000E-07 -0.5392507377765000E-08
82 2 -0.2738326734553000E-07  0.1010651257014000E-07
82 3 -0.1527162302538000E-06  0.1083730482627000E-06
82 4 -0.5302631798731000E-07 -0.3885522039490000E-07
82 5  0.4384491154579000E-07  0.3527471830899000E-07
82 6  0.8133754440072000E-07 -0.5748937359311000E-07
82 7  0.6826467018654000E-07 -0.3176090522833000E-08
82 8  0.9286055125894000E-07  0.1044000857895000E-06
82 9 -0.4605254289506000E-07 -0.4455774769762000E-07
82 10 -0.3309291237827000E-08  0.1593998409498000E-07
82 11 -0.4080674692961000E-07 -0.2377514386838000E-07
82 12 -0.8049491593933000E-07 -0.1061770114570000E-06
82 13  0.3514570082406000E-07  0.1036612284129000E-06
82 14 -0.6622706135628999E-07  0.9260176273657000E-07
82 15 -0.1214130919625000E-06  0.3326388311282000E-07
82 16  0.9987142485179001E-08  0.4330355923694000E-07
82 17  0.1740634877335000E-07 -0.1203906769307000E-06
82 18 -0.2290296043316000E-07  0.4930359359205000E-07
82 19  0.2392905355357000E-07  0.9790921836732000E-07
82 20  0.1058877492106000E-06 -0.1701701310191000E-07
82 21 -0.8691684805777000E-07  0.1501134690601000E-07
82 22 -0.6306341689664000E-07  0.1033957787316000E-06
82 23  0.6780158908707000E-07 -0.1916692655147000E-07
82 24 -0.2062224803085000E-08  0.9978286067031000E-07
82 25  0.1417274149526000E-07 -0.3366427348802000E-07
82 26 -0.5799995768662000E-07 -0.6056686470035000E-09
82 27  0.6631044275241000E-07 -0.1607864377908000E-07
82 28  0.1967172518570000E-07 -0.5211442773087000E-07
82 29 -0.3161164692948000E-07 -0.5553591384867000E-08
82 30 -0.1053889448419000E-08  0.6059556127911000E-07
82 31 -0.1173591457138000E-07  0.5650656699169000E-08
82 32 -0.3172040675265000E-07 -0.3725844181189000E-07
82 33  0.4810270984993000E-07 -0.2031308773198000E-07
82 34  0.1402289497017000E-07  0.3063357456998000E-07
82 35  0.3543305908326000E-07 -0.7995739887571000E-07
82 36  0.4846398700808000E-07 -0.1114524622335000E-07
82 37 -0.4371004442220000E-07 -0.3262342616815000E-07
82 38 -0.3331035223631000E-07  0.7742992903564999E-08
82 39  0.7404479273308000E-07 -0.3115229021535000E-08
82 40 -0.5394237794317000E-07 -0.3054794178726000E-07
82 41  0.3758728512074000E-07 -0.2565391160691000E-07
82 42 -0.4578506982406000E-07  0.2236749562705000E-07
82 43  0.8466837912056001E-08 -0.1034621953829000E-06
82 44 -0.1756648438245000E-07  0.5599941627096000E-08
82 45 -0.5035419713047000E-07 -0.6380511256001000E-08
82 46  0.7133059413480999E-07  0.4587565664179000E-08
82 47  0.6635990910411000E-07 -0.4295920643880000E-07
82 48 -0.1697585056407000E-07 -0.8072798923275000E-07
82 49  0.2977768342470000E-08  0.6259398426715999E-07
82 50 -0.7341186877443000E-07  0.1280020187349000E-07
82 51 -0.2476469648742000E-07 -0.2327233267196000E-07
82 52 -0.3873857295903000E-07 -0.6262696959079000E-07
82 53  0.1416397411996000E-07  0.1187686469437000E-07
82 54 -0.2046044575891000E-07 -0.1007611673064000E-07
82 55  0.1036913323765000E-07  0.1926729767529000E-07
82 56  0.1173294684405000E-08 -0.4906250532715000E-07
82 57  0.3500810280694000E-07  0.2377178431027000E-07
82 58  0.5138966965276000E-07 -0.5468383935921000E-07
82 59 -0.2494500450273000E-07  0.8800404008802000E-07
82 60  0.5795280799443000E-07  0.7406741870834000E-08
82 61 -0.1447445768513000E-07 -0.2638648667219000E-07
82 62  0.3256599029535000E-07 -0.1071338799273000E-06
82 63 -0.4048827882690000E-07 -0.1576596931792000E-07
82 64  0.6309261565964000E-07  0.2240723934982000E-08
82 65  0.6631214173327000E-07  0.1577932768749000E-07
82 66 -0.2765183031335000E-07 -0.3341734677894000E-07
82 67 -0.4127970769615000E-07 -0.7985612611180000E-08
82 68 -0.5338244964909000E-07 -0.2391298144246000E-07
82 69  0.3354075273463000E-07 -0.5301543116977000E-07
82 70  0.7329406147418000E-08  0.6310988788077000E-08
82 71  0.4874347569915000E-07 -0.2496205985401000E-07
82 72  0.3531866990888000E-07  0.6637506234480000E-07
82 73  0.7170101389935000E-08  0.3486339734597000E-07
82 74  0.8302857390764999E-07  0.7140117985497000E-08
82 75 -0.4300738119422000E-07 -0.6916098209670000E-07
82 76 -0.2617105651938000E-07  0.3511431661974000E-07
82 77 -0.2255001072065000E-07 -0.2866206454535000E-07
82 78  0.1741251369605000E-07  0.1259477839801000E-08
82 79  0.4590056443432000E-07  0.8584181025976000E-07
82 80 -0.5294391153616000E-07  0.9096044709003000E-07
82 81  0.3875301688147000E-07 -0.8379910204099999E-08
82 82  0.6087659499977000E-08 -0.4456037369374000E-07
83  0  0.6133069345154000E-08  0.0000000000000000E+00
83 1 -0.1007696640182000E-06 -0.1201458112538000E-08
83 2 -0.1294607047717000E-06 -0.1402486482776000E-07
83 3  0.2966191174862000E-07  0.1820144985174000E-07
83 4 -0.5980107514745999E-07  0.1798029365379000E-07
83 5  0.1058690965627000E-06 -0.1029055992906000E-07
83 6  0.5580464186404000E-07 -0.1293873311323000E-07
83 7 -0.5002837433881000E-07  0.1937317196869000E-07
83 8 -0.4960012214056000E-07  0.1224528435717000E-07
83 9 -0.5853069429594000E-07 -0.5785583978305000E-07
83 10  0.9025911986504999E-08  0.7502520959782000E-07
83 11  0.2637032665802000E-07  0.2241284581988000E-07
83 12 -0.4903413828546000E-08  0.2617079333480000E-07
83 13  0.1100529165246000E-07 -0.3003357992866000E-07
83 14 -0.1009825936678000E-07 -0.3253898153776000E-07
83 15  0.1108983915502000E-06 -0.9435347909564000E-07
83 16 -0.4591335499110000E-07  0.1983380779719000E-07
83 17  0.7362712895907000E-07 -0.4156767886275000E-07
83 18  0.1418254052175000E-07  0.1811004072208000E-07
83 19 -0.3450678165403000E-07  0.2021077459659000E-07
83 20  0.8751025438240000E-08 -0.3250198254302000E-08
83 21 -0.9706239074551000E-07 -0.2708422947883000E-07
83 22  0.8806318812897000E-08  0.6170333675352999E-07
83 23  0.8177787504312999E-07  0.1846163447982000E-07
83 24 -0.6238601303248000E-07 -0.4831841871365000E-07
83 25  0.1725730901421000E-07  0.3993534916481000E-07
83 26  0.1011954063265000E-06  0.9417178617427000E-08
83 27 -0.4054998573505000E-07  0.2761614993871000E-07
83 28  0.2734262245553000E-07 -0.3044038157907000E-07
83 29  0.6686840765796000E-08 -0.2671018305513000E-09
83 30 -0.5842768235237000E-07 -0.2374167309245000E-07
83 31 -0.3171276664272000E-07 -0.7060055419967000E-07
83 32 -0.3829395149056000E-07  0.9593992679828000E-07
83 33  0.8259702792626000E-08  0.2430530370152000E-07
83 34  0.3198853543641000E-07  0.4480303660369000E-08
83 35 -0.5214065160888000E-07  0.6113955409389999E-07
83 36  0.9354589983114000E-07 -0.4500194152725000E-07
83 37 -0.1174345356256000E-07  0.6874538075846000E-07
83 38  0.3104032968647000E-07 -0.2847636761891000E-07
83 39  0.1383945623688000E-07  0.3962995378380000E-07
83 40  0.7533129396933000E-09  0.1477824635881000E-07
83 41 -0.2660628588157000E-09 -0.5766150131457000E-08
83 42 -0.2100907093532000E-07  0.1032087703908000E-07
83 43  0.9080335421377999E-07  0.6838332818146000E-07
83 44 -0.2196894685544000E-07 -0.3775411095092000E-07
83 45  0.5252107327032000E-08  0.5203313952610000E-07
83 46 -0.4519611949068000E-07  0.3773075381916000E-07
83 47 -0.1806749102855000E-07 -0.5611429692354000E-07
83 48  0.8902353089618000E-07  0.1146191999546000E-06
83 49  0.2420548407456000E-07 -0.1277977510743000E-07
83 50  0.4296217195641000E-07 -0.5695887118583000E-07
83 51  0.4195181120155000E-07 -0.2039519747126000E-07
83 52  0.3307004343442000E-07 -0.2713773919793000E-07
83 53 -0.1087132485812000E-07  0.3266031720285000E-07
83 54 -0.2007782498564000E-07  0.1956040878533000E-07
83 55  0.4990485618617000E-07  0.2459967324287000E-07
83 56 -0.1299979174089000E-08  0.5735480264706000E-08
83 57  0.4173306398044000E-07  0.3032125216046000E-07
83 58  0.2176935590327000E-07  0.2475262239395000E-07
83 59  0.1617580182752000E-07 -0.8670812924397000E-07
83 60 -0.1451332716231000E-07 -0.2422926999339000E-07
83 61  0.3031508070419000E-07 -0.1291117330688000E-06
83 62  0.1384503497837000E-06  0.5449691469553000E-07
83 63 -0.2937031965112000E-07  0.6038785599040000E-07
83 64  0.2670438352489000E-07 -0.1418110311704000E-07
83 65 -0.5281939129712000E-07 -0.4480068876327000E-07
83 66 -0.1901790790418000E-08  0.9873492156706000E-08
83 67  0.9306021428043000E-08 -0.2993835810930000E-07
83 68 -0.4130388333476000E-08  0.1205764148729000E-07
83 69 -0.6766641320095000E-07  0.3009955927227000E-07
83 70 -0.2156941091050000E-07  0.4274228609395000E-07
83 71  0.5401232315038000E-08 -0.1609880924732000E-07
83 72 -0.1038649130486000E-07 -0.4669980953735000E-07
83 73 -0.6597756351910000E-08 -0.7598808218304001E-07
83 74  0.4194486863801000E-08  0.4290930922807000E-07
83 75  0.8296316259110000E-07 -0.1534425966735000E-07
83 76  0.3765415930417000E-07  0.3188002386684000E-07
83 77  0.3525478270269000E-07 -0.2565282470617000E-08
83 78 -0.4000460959517000E-07  0.8687877303422999E-07
83 79 -0.3469656686994000E-07 -0.3639427965468000E-07
83 80 -0.1056201518856000E-06 -0.1217488413944000E-06
83 81  0.3196408375621000E-07 -0.9534766596855000E-08
83 82  0.7597963022444000E-07 -0.4535237549211000E-08
83 83  0.9116739743774001E-07  0.3866267080938000E-07
84  0 -0.6977532944479000E-07  0.0000000000000000E+00
84 1 -0.3054976098251000E-07 -0.1984919573250000E-07
84 2  0.2479458671592000E-07 -0.5939696161103000E-07
84 3 -0.1234949427688000E-07  0.5231277828039000E-07
84 4  0.5102485073084000E-07 -0.4344501428041000E-07
84 5  0.6445260162010001E-07 -0.1105238006108000E-07
84 6 -0.7498756314420000E-07 -0.1364034671756000E-07
84 7 -0.4908177355976000E-08  0.9434241002103001E-07
84 8 -0.3439827670280000E-07  0.1261809453925000E-07
84 9  0.3401931111813000E-07  0.1239784654294000E-07
84 10  0.4294430794881000E-07  0.2581071697119000E-07
84 11  0.4385791532090000E-07 -0.1156483798592000E-07
84 12  0.2282975255035000E-07 -0.5734697339772000E-07
84 13  0.2924533959769000E-07  0.3364044555516000E-07
84 14  0.9844921077296000E-09 -0.4840896618705000E-07
84 15 -0.8370652838994999E-08 -0.1698728639662000E-07
84 16  0.3981645637498000E-07  0.8210293670918000E-07
84 17 -0.2560926979312000E-07 -0.1220033017968000E-06
84 18 -0.1590390403207000E-07  0.5057787667248000E-08
84 19  0.5294401437942000E-07  0.6759644729333000E-07
84 20 -0.6784158489447000E-07 -0.1395547259049000E-07
84 21 -0.5674197575941000E-07  0.9491576018017000E-08
84 22  0.8080878116578000E-07  0.1217255959277000E-07
84 23  0.1904105363714000E-07 -0.4342886827637000E-07
84 24  0.1282073714837000E-08  0.7943913459820000E-07
84 25  0.1121485312335000E-07  0.5777954496622000E-08
84 26 -0.3993234289062000E-07 -0.6394657750781000E-07
84 27  0.4987910185211000E-07 -0.6691644511560000E-07
84 28  0.5124516725828000E-07  0.4144231076156000E-07
84 29 -0.3370586313482000E-07  0.1998691254618000E-07
84 30  0.3264597824544000E-07  0.2549448546884000E-07
84 31  0.1307665336374000E-08  0.3852159247498000E-07
84 32  0.1941895910392000E-07  0.4408683329274000E-07
84 33  0.2972980714041000E-07 -0.3643703695468000E-07
84 34 -0.4494428328741000E-07  0.1275522482409000E-06
84 35 -0.3535830301257000E-07 -0.3566054712516000E-07
84 36 -0.4274599849932000E-07 -0.3789592020678000E-07
84 37 -0.6122080668633001E-07 -0.3930995031745000E-07
84 38  0.2957092615255000E-07 -0.3559163190756000E-07
84 39 -0.1040387611914000E-07 -0.2106426400018000E-07
84 40  0.3421539676858000E-07 -0.7035374934986000E-07
84 41 -0.4304840430818000E-08  0.4809454412732000E-07
84 42  0.5743258008007000E-07  0.4658613971029000E-08
84 43  0.4156331632713000E-07 -0.4330367876137000E-07
84 44 -0.9559216546579000E-07  0.4221550341220000E-08
84 45 -0.2422451051224000E-07 -0.5245858790663000E-07
84 46 -0.2924672708554000E-07  0.6050549980922000E-08
84 47  0.9336320095838001E-07 -0.3745636517285000E-07
84 48 -0.8889867563425001E-07  0.9852312018204001E-07
84 49 -0.1624966996881000E-07 -0.2573946559410000E-07
84 50 -0.3096222222099000E-08  0.7301080387543000E-08
84 51  0.1656131248027000E-07  0.9621668513618000E-07
84 52 -0.4568452791757000E-07  0.9670914806262001E-08
84 53  0.1443386611572000E-07  0.5536467498464000E-07
84 54 -0.4567270986082000E-07 -0.8640616644064999E-08
84 55 -0.5551266890337000E-07  0.6323819936418000E-08
84 56  0.1366160843288000E-07  0.1635715121293000E-08
84 57  0.6721248676176000E-08  0.3121498865134000E-07
84 58  0.5996793786571001E-07  0.1018593065635000E-07
84 59 -0.3550285894119000E-07 -0.1540857591105000E-07
84 60 -0.4436640967329000E-07  0.1686624880976000E-07
84 61  0.7125860403173000E-08  0.5796047705048000E-07
84 62 -0.6763771758588000E-07  0.6021458389085000E-07
84 63 -0.1882531254978000E-07 -0.9874037595167000E-08
84 64 -0.5495691546388000E-08 -0.4723642432099000E-07
84 65 -0.3060609680097000E-07 -0.2052232988578000E-07
84 66 -0.2140220784783000E-07  0.4012581126834000E-07
84 67 -0.1934449069023000E-07  0.6485378651934000E-07
84 68 -0.5248404836135000E-07 -0.1719296913394000E-07
84 69  0.2250684784185000E-07  0.5410892030858000E-07
84 70  0.8230288713113000E-07 -0.1141406033029000E-06
84 71  0.1319052517156000E-07 -0.8891497331897000E-07
84 72  0.1108098274113000E-07  0.6169821490590000E-07
84 73 -0.9949784726344000E-07  0.8887460804521000E-07
84 74  0.7805383868657001E-07 -0.4516089249901000E-07
84 75 -0.7537794060659999E-07 -0.1147217665099000E-06
84 76 -0.4777703529438000E-07 -0.5843101929339000E-08
84 77 -0.7805721933718000E-07  0.2127957621759000E-08
84 78 -0.8810402795710001E-07  0.1661237742629000E-07
84 79 -0.2869725017948000E-07  0.2690733075598000E-08
84 80 -0.1574164544441000E-07  0.3114725086410000E-07
84 81  0.1191023589493000E-06 -0.5031136713499000E-08
84 82 -0.8305554598464000E-07 -0.1775262413266000E-07
84 83 -0.6463360251646000E-07 -0.1435495770956000E-07
84 84 -0.3019375543853000E-07  0.1428393062299000E-07
85  0 -0.2726722140198000E-07  0.0000000000000000E+00
85 1 -0.5094028801632000E-08 -0.2086477265206000E-07
85 2 -0.4126326695437000E-07  0.7887492174622000E-07
85 3  0.3923829476372000E-07 -0.5045955159951000E-07
85 4 -0.4269766340883000E-07 -0.3283563163054000E-07
85 5  0.6918819927145000E-07 -0.4437229954133000E-07
85 6 -0.3141148092292000E-07  0.1713219401946000E-07
85 7 -0.3339562565516000E-07 -0.8838739021082000E-07
85 8  0.3771873075399000E-07  0.4806111351568000E-07
85 9 -0.3524518992928000E-08  0.9635759439723999E-08
85 10  0.4322089706777000E-07  0.8083653682622001E-07
85 11 -0.7887490750713000E-08 -0.3281841151155000E-07
85 12 -0.6353424909388000E-07  0.6980386377028000E-08
85 13  0.7323315333142000E-08 -0.2362044000367000E-07
85 14 -0.4228593492876000E-07  0.3403795146548000E-07
85 15 -0.7950946002811000E-08 -0.1518606529048000E-07
85 16 -0.1112407495799000E-07  0.2828761960694000E-07
85 17 -0.3354819647773000E-07 -0.2748972112675000E-07
85 18  0.3912396969308000E-07  0.6622308939339000E-07
85 19 -0.2702967446546000E-07 -0.1154346467698000E-07
85 20 -0.3726861449058000E-07 -0.9231011033962000E-07
85 21 -0.2848677507185000E-07  0.1330342830347000E-06
85 22  0.2097243407159000E-07 -0.2026523076511000E-07
85 23 -0.7527595550768000E-07 -0.2531515773015000E-07
85 24 -0.2050977978222000E-08  0.3954232666412000E-08
85 25 -0.1651800140348000E-09  0.1201213811937000E-07
85 26  0.2757921620645000E-07 -0.5216151279775000E-07
85 27 -0.2265799035192000E-08  0.4043587161435000E-07
85 28  0.7038735597853001E-07  0.6212184016554000E-07
85 29 -0.6119920645088999E-07 -0.1971245876545000E-07
85 30 -0.5352996838927000E-07 -0.4254653070178000E-07
85 31  0.9105078526201000E-07 -0.8295486137873001E-07
85 32  0.2622168494741000E-08  0.9296122420685000E-07
85 33 -0.4502807733320000E-07  0.8530953756273000E-08
85 34 -0.4641266162212000E-07 -0.2168027356808000E-07
85 35  0.3295086764261000E-08 -0.1355862397170000E-06
85 36 -0.7113244755646000E-08  0.3190290911769000E-07
85 37  0.7771389630369999E-07  0.1111681767688000E-06
85 38  0.6524717950707000E-07  0.1382670642318000E-08
85 39  0.6617207755004999E-07  0.4349317191516000E-07
85 40 -0.1267671619844000E-07  0.2755256593628000E-07
85 41 -0.4798943728909000E-07  0.5998869129417000E-07
85 42 -0.4757233737154000E-07 -0.3654292269786000E-07
85 43 -0.9651410848252000E-07  0.1839603273405000E-07
85 44 -0.1018557980264000E-06  0.2556905223183000E-07
85 45  0.9269849073788000E-07 -0.3118783003236000E-07
85 46  0.6987552925965000E-07 -0.3168196356420000E-07
85 47 -0.5677458891255000E-07  0.3306489968883000E-07
85 48 -0.6180837712812000E-07  0.3664171939330000E-07
85 49  0.7441446275911000E-07 -0.2708730503372000E-07
85 50 -0.1594790513353000E-07 -0.1074724528275000E-08
85 51 -0.5038710558750000E-07  0.4178562071550000E-07
85 52 -0.4108318218484000E-07 -0.6127265149192000E-07
85 53 -0.5596859175943000E-08  0.3312203424937000E-07
85 54 -0.2066416160425000E-07 -0.5989382564158000E-07
85 55  0.5402743354021000E-07 -0.2427438769135000E-07
85 56  0.3418920286981000E-07 -0.3445059524377000E-07
85 57 -0.7086884942246000E-08  0.6388304501148000E-07
85 58  0.4079656252421000E-07 -0.1636223266524000E-08
85 59 -0.5740122018479000E-07 -0.4309603167904000E-07
85 60  0.5142548490135000E-07  0.6695234017793000E-07
85 61  0.1000802675389000E-06 -0.4717586840438000E-08
85 62 -0.2465900811556000E-07 -0.6487251291161000E-07
85 63  0.3945037882286000E-07  0.1174006926196000E-07
85 64 -0.6899467564287000E-07  0.4842256141600000E-07
85 65  0.6334247692203000E-07 -0.2025280341304000E-07
85 66 -0.3020743806979000E-07 -0.4673876146126000E-07
85 67  0.1589192981765000E-07 -0.1672037384348000E-07
85 68 -0.7536066066729001E-08 -0.2197412035140000E-07
85 69  0.2656567539332000E-07 -0.7931097385936999E-08
85 70 -0.3398822727434000E-07 -0.2401196214299000E-07
85 71 -0.7234906746184000E-07  0.7917821049743999E-07
85 72  0.1688817152635000E-08  0.5381105439751000E-07
85 73 -0.3053678535231000E-08 -0.5950920552642000E-07
85 74  0.7330768788665000E-07 -0.1165375786925000E-07
85 75 -0.8051749302652999E-08  0.8200463620448000E-07
85 76 -0.1527281603361000E-07  0.1216420209229000E-06
85 77 -0.3537471141190000E-08  0.7319685864281000E-07
85 78  0.1388168694456000E-06  0.1407575181597000E-07
85 79  0.6715508967796000E-07 -0.2873188124111000E-07
85 80 -0.7351223398120000E-08 -0.3471910292881000E-07
85 81 -0.6150122321475999E-07 -0.3994258762088000E-07
85 82  0.3199662108720000E-07  0.4259769494065000E-07
85 83 -0.5153083720644000E-09 -0.3144615702188000E-07
85 84  0.6980596151208000E-07 -0.6316430639474000E-08
85 85 -0.3506586547397000E-08 -0.3115360913217000E-07
86  0  0.3718007703918000E-07  0.0000000000000000E+00
86 1 -0.4045367386924000E-07  0.3961921975126000E-07
86 2 -0.4123707407756000E-07 -0.9385407330361999E-07
86 3  0.1771927152554000E-07 -0.2652980061842000E-07
86 4  0.5828483633640000E-07  0.1898320268250000E-07
86 5  0.2838015629918000E-07  0.2742698939160000E-07
86 6 -0.4968639859623000E-07 -0.7130269655229000E-07
86 7  0.1712349814713000E-07  0.3461756017346000E-07
86 8  0.8806390092155001E-08 -0.6005755860656000E-08
86 9  0.1930434850213000E-07 -0.2223255233409000E-07
86 10 -0.4253852928506000E-07 -0.1110871118303000E-06
86 11 -0.4373286824734000E-07 -0.2194199907084000E-09
86 12  0.1247840371938000E-07  0.1034048583980000E-07
86 13 -0.1888827299213000E-07 -0.6020422681825000E-07
86 14  0.5345098840252000E-07  0.4540376865944000E-07
86 15  0.2793109304903000E-07  0.4602843414993000E-07
86 16 -0.2387215816427000E-07  0.5665352148287000E-09
86 17  0.4666475774022000E-07  0.4823108120074000E-08
86 18  0.6598556928057001E-07  0.4237521371397000E-07
86 19  0.1241427789148000E-08 -0.1131941032056000E-06
86 20 -0.7393651692778000E-08  0.7420569709008000E-07
86 21 -0.1028324761462000E-06 -0.2614609180235000E-07
86 22  0.2032584858201000E-07  0.2928915516570000E-07
86 23 -0.4856107203302000E-07  0.7413577467969000E-08
86 24  0.2798828906289000E-07 -0.5654854882570000E-07
86 25 -0.5373440202265000E-07 -0.7219116300179999E-07
86 26  0.1929360863619000E-07  0.3931968952107000E-07
86 27  0.4194386210423000E-07 -0.1069980620546000E-07
86 28 -0.7005381332711000E-07 -0.2699933781055000E-09
86 29 -0.3892509437864000E-07  0.4458790520502000E-07
86 30  0.7307411168320000E-07  0.1409705744453000E-07
86 31 -0.1374758750198000E-07  0.2039275364091000E-07
86 32 -0.6763489017450000E-07 -0.9571705820811001E-08
86 33 -0.2180619199919000E-07  0.7639674234734999E-08
86 34  0.1071531922540000E-07 -0.4080229309516000E-07
86 35 -0.2879148564048000E-07 -0.6942492195915001E-07
86 36 -0.1778262632200000E-07  0.9704323278181001E-07
86 37 -0.7059033613399000E-07  0.1685107433899000E-07
86 38 -0.7936866077973000E-08 -0.1691710764916000E-07
86 39 -0.7114079086184000E-07  0.3994496020915000E-07
86 40 -0.3047960618130000E-07 -0.5351772681894000E-07
86 41 -0.3020770769393000E-07  0.5400402353259000E-07
86 42  0.2949690369704000E-07  0.3112163392058000E-07
86 43  0.1881049758167000E-07  0.3779898449462000E-07
86 44  0.1025752052609000E-07 -0.7008716344123000E-07
86 45 -0.1729545456530000E-07 -0.8155681052203001E-08
86 46  0.4226891793750000E-07 -0.2857874749326000E-08
86 47 -0.4448932435210000E-08  0.1518265805136000E-07
86 48  0.3956860839179000E-07 -0.5796149256911000E-08
86 49 -0.6706533760939000E-08 -0.1701706970360000E-07
86 50 -0.4219829929872000E-07 -0.4071429497674000E-07
86 51  0.3172980515926000E-07 -0.1890409774486000E-07
86 52  0.4481790279617000E-07 -0.2175438323938000E-07
86 53  0.2893177873792000E-07  0.8402131163509999E-08
86 54 -0.1340656397257000E-07 -0.9699843203674000E-07
86 55  0.1594398198493000E-07  0.2630419151453000E-07
86 56 -0.4599681616145000E-07  0.5871683735045000E-07
86 57 -0.4371251296663000E-07  0.6863126283328000E-09
86 58 -0.1144850337226000E-07 -0.3046451449691000E-07
86 59 -0.4393307202011000E-07  0.4960698977258000E-07
86 60  0.3541905373059000E-08  0.2274903581022000E-07
86 61 -0.3335516200416000E-07 -0.3271352368544000E-07
86 62 -0.5550017607971000E-07 -0.1068239888114000E-06
86 63  0.8868737344814001E-08  0.3298291960122000E-07
86 64 -0.1449512623499000E-07 -0.3236229728659000E-07
86 65  0.3350747852970000E-07 -0.1020524386962000E-07
86 66 -0.2722940493556000E-07  0.7471253372229000E-07
86 67  0.1929833243287000E-07 -0.2122586462069000E-07
86 68  0.7450680574400001E-07 -0.7872653555895000E-07
86 69 -0.4344574784815000E-07  0.9127091232538000E-07
86 70 -0.1475150437170000E-07 -0.8618069067492000E-07
86 71  0.8545460532673000E-08  0.3915268511602000E-07
86 72  0.2407479246021000E-07 -0.3184881014809000E-07
86 73 -0.2180480895160000E-07 -0.8339891021160000E-08
86 74  0.1637751179979000E-07 -0.3874088270051000E-07
86 75 -0.8716752158102000E-09 -0.3250843719322000E-07
86 76  0.6418200412171001E-07 -0.9129818847789000E-07
86 77  0.2707616950214000E-07 -0.5202969548765000E-07
86 78 -0.4117423760702000E-07 -0.5808232200106000E-07
86 79 -0.4695454272635000E-07  0.4075825983356000E-07
86 80  0.1343843397661000E-07  0.1839045542392000E-07
86 81  0.1226232090667000E-08  0.6148583828720000E-07
86 82  0.5174735853706000E-07  0.6878676072525000E-07
86 83 -0.5730371936669000E-07 -0.7048489572016000E-08
86 84  0.6429654892506000E-09  0.1702914249652000E-08
86 85  0.3334442644865000E-07  0.3718495724942000E-07
86 86 -0.6491664449783000E-07  0.2497341641733000E-07
87  0 -0.6521449797075000E-07  0.0000000000000000E+00
87 1 -0.7227358107181000E-07 -0.4230398412456000E-07
87 2  0.6869391423871000E-07  0.4261126464442000E-08
87 3  0.9628599738349001E-07 -0.5422215709271000E-07
87 4 -0.5301632727686000E-07  0.3170893332214000E-07
87 5  0.2886193635796000E-07 -0.6864872987568000E-07
87 6 -0.3566640586900000E-08  0.6623976147477000E-07
87 7 -0.3560353729065000E-07 -0.8869648672812000E-07
87 8  0.4192862101806000E-07  0.3213999121787000E-07
87 9  0.3555448892888000E-07 -0.3804025377900000E-07
87 10  0.3754203309976000E-07  0.4972515563898000E-07
87 11  0.1895763046899000E-07 -0.2042271871278000E-07
87 12  0.2115179246242000E-07 -0.1004444699884000E-06
87 13  0.1072157933085000E-07  0.4459812179449000E-07
87 14  0.1273426573452000E-07  0.1699121231326000E-07
87 15  0.4092635488837000E-07  0.3267490214904000E-07
87 16  0.1039689311939000E-06  0.2976881340124000E-07
87 17 -0.2399584640671000E-07 -0.2598516304012000E-07
87 18 -0.5092620418913000E-07 -0.6991418692500000E-07
87 19  0.5040526881884000E-07  0.3677224374229000E-07
87 20 -0.3550156710994000E-07  0.7547862150980000E-08
87 21  0.7866902197508999E-07  0.4739133336869000E-07
87 22  0.2979218536940000E-07 -0.2702301907656000E-08
87 23  0.1849628362281000E-09 -0.3146733466633000E-07
87 24  0.5267258234230000E-07 -0.1923185399971000E-07
87 25 -0.2017342533282000E-07  0.4417390040191000E-07
87 26  0.8555227955122000E-08 -0.2373964846287000E-07
87 27 -0.3955225802823000E-08  0.2963308014553000E-07
87 28  0.5913273582848000E-08  0.5165822256098000E-07
87 29  0.6225900721013999E-07 -0.4159543989649000E-07
87 30  0.3280908629996000E-07 -0.1214055148527000E-06
87 31  0.1068857355602000E-07  0.5025808233115000E-07
87 32  0.3320500378482000E-07  0.4898202130993000E-07
87 33  0.7499415086455000E-08 -0.2080779169056000E-07
87 34  0.9132822423500000E-08 -0.4089115767700000E-07
87 35 -0.5769508588207000E-07 -0.3343711634156000E-07
87 36  0.3392174963510000E-08  0.5287929672147000E-07
87 37  0.5260152245536000E-07  0.1895891478140000E-07
87 38 -0.1441609932401000E-07 -0.1260359559048000E-07
87 39  0.3035647694765000E-07 -0.3642991172673000E-09
87 40  0.5451496132417000E-07 -0.5095056595055000E-07
87 41  0.1221702022452000E-07  0.2381959856436000E-07
87 42  0.1034713697103000E-07  0.3302520613828000E-07
87 43 -0.3982870931613000E-08 -0.2857134911791000E-07
87 44  0.1418888051148000E-08 -0.2653312543885000E-07
87 45  0.6149247686813000E-07  0.2080419593167000E-07
87 46  0.1771219801401000E-07  0.3673063473567000E-07
87 47  0.3098627105692000E-07  0.6674428403920000E-07
87 48  0.3689666374657000E-07 -0.3675398966388000E-07
87 49 -0.1313926473027000E-08 -0.2108773975013000E-07
87 50 -0.8582333343715001E-08 -0.1446896422205000E-07
87 51 -0.2186879228865000E-07  0.6092958095272000E-07
87 52 -0.5163808210580000E-07 -0.2843710214490000E-07
87 53 -0.3812519606815000E-07 -0.2538133793418000E-07
87 54 -0.2567360145765000E-07 -0.4758307861068000E-07
87 55  0.1277347657610000E-07  0.1346251075939000E-07
87 56 -0.5041301639343000E-08 -0.5757174048156000E-07
87 57  0.1484618424451000E-07 -0.5208806073636000E-07
87 58 -0.2847683038328000E-07 -0.1309727933057000E-07
87 59  0.3420439846413000E-07  0.2540625519631000E-08
87 60  0.3650190108920000E-07 -0.8235672233360000E-08
87 61  0.8941000733785999E-08 -0.7189673167567000E-07
87 62 -0.4964100938898000E-07  0.7950751163220001E-07
87 63 -0.1051444024965000E-07  0.8861888106182000E-07
87 64  0.2105615474853000E-07 -0.2503234889817000E-07
87 65 -0.5312196980213000E-08  0.4891841792944000E-07
87 66 -0.5819604037244000E-07  0.1375450908741000E-07
87 67  0.3113632958096000E-07 -0.1591839382770000E-07
87 68 -0.7474681784217000E-07  0.8733794123663000E-07
87 69 -0.1409568906755000E-08 -0.1246262926960000E-07
87 70  0.7570332175318999E-07 -0.6355899217142000E-07
87 71 -0.1323315180505000E-08 -0.7267369739170000E-08
87 72 -0.2082124914663000E-07  0.2973333020937000E-07
87 73  0.2527574092951000E-07  0.3782771375558000E-08
87 74 -0.9937656173897000E-08 -0.3961902031982000E-07
87 75 -0.3830922800384000E-08  0.9154025594256000E-07
87 76 -0.1323778877246000E-07  0.8177410180326000E-07
87 77  0.7776143894773999E-08  0.9855208301653000E-07
87 78  0.4239160059735000E-07 -0.6545604689525999E-07
87 79  0.6495176246637000E-07  0.6720861616558000E-07
87 80 -0.1612467458093000E-07 -0.1455151942134000E-07
87 81 -0.2930539569574000E-07  0.1407620700522000E-07
87 82 -0.1275260641435000E-07 -0.9206317512235001E-08
87 83 -0.6146118786040000E-08 -0.6888572313312999E-07
87 84  0.2350076945735000E-07 -0.2285725162306000E-07
87 85  0.6676240820102000E-08 -0.2345070921558000E-07
87 86 -0.9713117278986000E-07 -0.4696679674331000E-07
87 87  0.1242560750502000E-06 -0.3078966355839000E-07
88  0  0.2496042002679000E-07  0.0000000000000000E+00
88 1  0.4610662483368000E-07 -0.4704799775415000E-07
88 2  0.8071593995912001E-07 -0.5698754043906000E-07
88 3  0.1979714007652000E-07  0.2258359510454000E-07
88 4 -0.5390893353913000E-07 -0.5327313385687000E-07
88 5 -0.2574034690211000E-07  0.3360243859489000E-07
88 6  0.3188577291659000E-07 -0.2816870427931000E-07
88 7  0.3549165906496000E-07  0.1062926085206000E-06
88 8 -0.4098367941383000E-08 -0.7239793261550000E-07
88 9 -0.2630506936181000E-07  0.6550407524493999E-07
88 10 -0.6666164703516999E-07 -0.5025885953589000E-07
88 11 -0.5368748014945000E-07 -0.4580136707723000E-07
88 12 -0.1084935316960000E-07  0.1749806004619000E-07
88 13  0.6499621967385999E-07 -0.4620666878093000E-07
88 14  0.2201732674370000E-07 -0.1023124406613000E-07
88 15 -0.1321939039378000E-07  0.1229878396725000E-06
88 16 -0.5933771486258000E-07 -0.1400513062833000E-06
88 17  0.5624768759111000E-08  0.2747157179055000E-08
88 18  0.2351548407192000E-07  0.5847343586135000E-07
88 19 -0.2018981508564000E-07 -0.2517756585150000E-07
88 20 -0.2986164876401000E-07  0.4217904401727000E-07
88 21 -0.8025772856178000E-08 -0.2599460889740000E-07
88 22 -0.6123026677383999E-07 -0.4715193603270000E-07
88 23  0.2294185661350000E-07 -0.2978824275756000E-07
88 24  0.1372682187311000E-07  0.3143317637388000E-07
88 25  0.4849069827217000E-07 -0.1832083754892000E-07
88 26  0.8567778127259001E-08  0.4790705141568000E-07
88 27  0.7450766005217000E-08 -0.2834018570929000E-07
88 28  0.4245573960313000E-07 -0.2166392546634000E-07
88 29  0.2049099002039000E-07  0.4744755374838000E-07
88 30 -0.4045640824384000E-08  0.9080422859954000E-08
88 31  0.2835074424858000E-08  0.1588166752339000E-07
88 32  0.2488641157062000E-07 -0.2590672079661000E-07
88 33 -0.2268519053980000E-07  0.2685122246075000E-07
88 34  0.1712372627995000E-07 -0.5423515558088000E-07
88 35 -0.4435184137124000E-07 -0.1754720825135000E-07
88 36  0.8870020918691001E-08  0.9212370689592000E-07
88 37 -0.3714113094053000E-09  0.3798169820174000E-07
88 38  0.5701936318816000E-07 -0.3139286934735000E-07
88 39  0.4663017058048000E-07 -0.1563745830052000E-07
88 40 -0.2016543689327000E-07  0.1460673824814000E-07
88 41 -0.1106984797342000E-07 -0.1796695166436000E-07
88 42 -0.1188463188554000E-07 -0.5347876299387000E-07
88 43 -0.8778953453171999E-07 -0.2623811708571000E-07
88 44 -0.9078173041764000E-09  0.3790079238228000E-07
88 45 -0.6090392540421000E-08 -0.3235620401427000E-08
88 46  0.3740494669950000E-07  0.2335621371998000E-07
88 47 -0.9366755357291000E-07 -0.9948932816714000E-08
88 48  0.9504355572821999E-08 -0.3494910814806000E-07
88 49  0.1519863379491000E-08  0.4426323744803000E-07
88 50  0.1426565689179000E-07  0.4054692900978000E-07
88 51 -0.3733360387029000E-07  0.4416822229490000E-07
88 52  0.4339441757663000E-07 -0.8635442534640000E-07
88 53  0.2789702805657000E-07  0.2675101596058000E-08
88 54  0.8968321546834000E-08  0.3661140512484000E-07
88 55  0.5501871251419000E-07 -0.4472920709048000E-07
88 56 -0.4370376515090000E-07  0.7978816191693000E-07
88 57  0.3741954785463000E-07 -0.7130055628530000E-08
88 58  0.3574083538742000E-07 -0.3161269294216000E-07
88 59  0.6307158900165000E-07 -0.1636381837263000E-07
88 60 -0.1004077558369000E-06 -0.2546887518982000E-07
88 61  0.7187472108300000E-07  0.1116478421606000E-06
88 62  0.2654143334075000E-07 -0.1935008676635000E-07
88 63  0.1736956549292000E-07 -0.3437350852447000E-07
88 64  0.2549704704328000E-07 -0.6659547130974000E-08
88 65  0.2445754814560000E-07  0.4324660077747000E-07
88 66 -0.1120839843039000E-07 -0.4692781592715000E-07
88 67  0.2617127951503000E-07 -0.3581225252385000E-07
88 68  0.1192318305911000E-07 -0.8336780027955000E-07
88 69  0.1776343773125000E-07 -0.2836853022292000E-07
88 70 -0.5846061759347000E-08  0.3570684615492000E-07
88 71 -0.4827975773476000E-07  0.4502282811919000E-07
88 72 -0.2441116329502000E-07  0.5374575083121000E-08
88 73  0.2578368352820000E-07  0.1903831360451000E-07
88 74 -0.4240990924062000E-07 -0.7028400196675000E-07
88 75  0.1360734985675000E-07  0.1789934381750000E-07
88 76  0.2904450380525000E-07  0.2990081761252000E-08
88 77  0.8869788206236000E-08 -0.6789648695394000E-07
88 78 -0.5430812904037000E-07 -0.1895236092851000E-08
88 79 -0.8332898635976001E-07  0.3782989092771000E-07
88 80 -0.5120108070036000E-07  0.5622503754604000E-07
88 81 -0.3700274757807000E-08  0.1927814520173000E-07
88 82  0.2285057497390000E-07 -0.6642437014069000E-08
88 83 -0.4868451943675000E-07 -0.1986140032069000E-07
88 84  0.2583776284111000E-07 -0.4187549369561000E-08
88 85 -0.6402511221985000E-08  0.6913052076301000E-07
88 86 -0.2646747207726000E-07  0.3230184084901000E-07
88 87  0.3226712512766000E-07  0.3540910317700000E-07
88 88 -0.8042999503045000E-07  0.4120790631902000E-07
89  0  0.2474971495714000E-07  0.0000000000000000E+00
89 1  0.1815604719310000E-07 -0.1441378152974000E-07
89 2 -0.2133014244338000E-07  0.6674339155398000E-08
89 3 -0.8621587308663999E-07 -0.4852515364680000E-07
89 4 -0.7632452300023000E-07  0.4038547084340000E-07
89 5  0.8138920704275000E-07 -0.2027559486660000E-07
89 6 -0.6853699302556999E-07  0.3715725269656000E-07
89 7 -0.8157508728809000E-07 -0.6882681685923999E-07
89 8  0.1351264290419000E-07  0.1629775015789000E-07
89 9 -0.1448571011034000E-07 -0.4648395536082000E-07
89 10 -0.1913978703493000E-07  0.1252882180598000E-07
89 11 -0.1819045345138000E-07  0.1659956525994000E-07
89 12  0.2101626086089000E-07 -0.2094398015313000E-07
89 13 -0.3957577678008000E-07  0.8338297279886000E-08
89 14  0.5057026293120000E-08  0.1526275414316000E-07
89 15  0.3555490202703000E-07 -0.3132902068632000E-07
89 16 -0.1088734213781000E-07 -0.1181302287972000E-06
89 17  0.1701814320962000E-07  0.1215688001252000E-06
89 18  0.8542525587724000E-08 -0.1274076288975000E-07
89 19  0.9315237144355000E-08  0.2421019773018000E-08
89 20 -0.2486942182143000E-07 -0.1176271275159000E-07
89 21 -0.8554198952720000E-07  0.2854356927346000E-07
89 22 -0.3197286060024000E-07  0.2415596862363000E-07
89 23  0.3405739647859000E-07  0.5015282431893000E-07
89 24  0.8634664274814000E-07 -0.1860901806430000E-07
89 25 -0.1004090369906000E-06  0.4958762618570000E-07
89 26  0.1819408557931000E-07 -0.1037493165884000E-07
89 27  0.9101162006829000E-07 -0.2409517903404000E-07
89 28 -0.5286130285100000E-07  0.3306318121648000E-07
89 29 -0.5051424607778000E-07  0.1633324542102000E-07
89 30 -0.5234476731581000E-07 -0.3616971465235000E-07
89 31  0.6317456672555000E-07 -0.3221508830232000E-07
89 32 -0.6341263367188000E-07  0.2442257942430000E-07
89 33 -0.3655679562770000E-07 -0.2872693251134000E-07
89 34  0.6683150727951000E-08 -0.3451592683737000E-07
89 35 -0.8104685391533000E-08  0.2267988914903000E-07
89 36 -0.1378011782140000E-07  0.4503045969017000E-07
89 37  0.1065539325068000E-07 -0.5900816433716000E-07
89 38 -0.4490155044753000E-07 -0.5381642891694000E-07
89 39 -0.2244607478286000E-07  0.1373608928020000E-07
89 40 -0.3292564991638000E-07 -0.2979945442031000E-07
89 41 -0.1320141098180000E-08  0.3129420008282000E-07
89 42 -0.8163845240003000E-07  0.8829059968577999E-08
89 43  0.8392180680763001E-07  0.2874587726399000E-07
89 44  0.5787532715107000E-07 -0.4215487205360000E-07
89 45 -0.2158585448585000E-07  0.1127206868013000E-07
89 46 -0.3182144234568000E-07 -0.1596889339562000E-07
89 47  0.2325182461414000E-08 -0.1514505555093000E-07
89 48  0.5513440522970000E-07 -0.6762494186136000E-08
89 49 -0.2230942466353000E-07 -0.3654045288012000E-09
89 50 -0.5433843597442000E-07  0.3345459575538000E-07
89 51  0.2506864646813000E-07 -0.7753745920075000E-09
89 52  0.5724545275125000E-07 -0.4440206326161000E-07
89 53 -0.3958628741015000E-08  0.2791144139373000E-07
89 54  0.2682781497314000E-08 -0.1433290228299000E-07
89 55 -0.1166831836489000E-07  0.5156454414007000E-07
89 56  0.5770608485616000E-08  0.4785768626861000E-07
89 57  0.1770047834381000E-07 -0.1276831650715000E-06
89 58 -0.2859881523563000E-07  0.1200295409818000E-07
89 59 -0.4408865387211000E-07  0.1124461425932000E-06
89 60 -0.1644624521605000E-07 -0.5541435768668000E-08
89 61  0.7070596408637000E-07 -0.2875553811489000E-07
89 62 -0.1029115200202000E-06 -0.2038349629326000E-07
89 63  0.7696753524519000E-08 -0.8220081028635000E-08
89 64 -0.3695761892728000E-07  0.4303370903541000E-07
89 65  0.5488950892129000E-07 -0.6056280951642001E-07
89 66  0.3059665448349000E-07  0.3853127937859000E-07
89 67  0.3415205059389000E-07  0.3396519744431000E-07
89 68 -0.1407769851902000E-07 -0.2580961405086000E-07
89 69 -0.3282932638713000E-08  0.3613604218943000E-07
89 70  0.3346921949030000E-07  0.4502742867226000E-07
89 71 -0.2980710766860000E-08 -0.5088050177283000E-07
89 72  0.2685126527827000E-07  0.1914912704588000E-07
89 73  0.3997562783519000E-09  0.2265900701800000E-07
89 74 -0.6315239278567000E-08 -0.3222408665579000E-07
89 75 -0.3116084165487000E-07  0.3396682551988000E-07
89 76  0.2460290021768000E-07 -0.3928202906955000E-07
89 77 -0.4464600589740000E-07  0.2271378454932000E-07
89 78 -0.1965264246866000E-07  0.3891001892723000E-07
89 79 -0.1878218100957000E-07 -0.1921712393138000E-07
89 80  0.2828411694508000E-07 -0.3258558832692000E-07
89 81  0.8681486663380000E-07  0.2695202244025000E-07
89 82  0.2719462747627000E-07 -0.6082534055726000E-07
89 83  0.2017318269703000E-07 -0.6706477635519000E-07
89 84 -0.4546775125672000E-09  0.6443355016481000E-07
89 85  0.3192574522774000E-07  0.5914749961582000E-07
89 86 -0.2342269345116000E-07 -0.7660814917996000E-07
89 87 -0.7863557796695000E-08 -0.1714320678780000E-07
89 88 -0.2336457904886000E-08 -0.3875908465716000E-07
89 89 -0.3121937330933000E-07 -0.2997210536519000E-07
90  0 -0.5720059392420000E-07  0.0000000000000000E+00
90 1 -0.7047617694168000E-07 -0.4446056698607000E-07
90 2 -0.9159463038687001E-07 -0.4017752219020000E-07
90 3  0.8802153496927999E-07 -0.2058871813493000E-07
90 4  0.2360237711789000E-07 -0.3324973303266000E-07
90 5 -0.7075639132090000E-07 -0.4617180028651000E-07
90 6  0.1687474507389000E-07 -0.4899361563238000E-07
90 7 -0.3382957537081000E-09  0.3607586495562000E-07
90 8 -0.8837720037658000E-07 -0.3800868821727000E-07
90 9 -0.6989092988583000E-07 -0.8877819738086000E-09
90 10  0.7595931639054001E-07  0.3553373123946000E-08
90 11  0.5241372656547000E-08  0.3875329831932000E-07
90 12  0.2067909951975000E-07 -0.4848690733376000E-07
90 13  0.3597093868161000E-07 -0.4854515368282000E-07
90 14  0.2696792607380000E-07 -0.2915306610161000E-07
90 15 -0.7793265152564000E-07 -0.4487482061786000E-07
90 16  0.1061080036261000E-06  0.7511954224953000E-08
90 17 -0.8657414949285999E-08  0.6849051038278000E-07
90 18 -0.1035252560456000E-07  0.1861796082058000E-07
90 19  0.1195894646251000E-07  0.2600275759962000E-07
90 20 -0.3686176138850000E-07 -0.4738700157886000E-07
90 21 -0.5960163031740000E-08 -0.4890014723540000E-07
90 22  0.8663930617445001E-07  0.5463318936104000E-07
90 23  0.1323728881657000E-06 -0.7529152387610000E-09
90 24 -0.1033922831278000E-06  0.5785013048353000E-07
90 25  0.4081282506300000E-07  0.1407881324984000E-07
90 26  0.2366362634366000E-08 -0.2698252824783000E-07
90 27 -0.1712359541799000E-07  0.7600666575528000E-08
90 28 -0.1331596347809000E-07  0.4349213940190000E-07
90 29  0.5022011474043000E-07 -0.4480204442550000E-07
90 30  0.1080527980268000E-07 -0.5802198137472000E-07
90 31 -0.1163115597083000E-07  0.5703961317907000E-08
90 32 -0.4193871653264000E-07  0.3235132099761000E-07
90 33  0.2450188341906000E-07 -0.2060787701254000E-07
90 34 -0.3147248898566000E-07 -0.1859161935894000E-07
90 35 -0.2596105979405000E-07  0.9976535677541001E-08
90 36  0.4977485377521000E-08  0.1055982907015000E-08
90 37  0.2108562701490000E-07 -0.5889380357049000E-07
90 38  0.9472681748379000E-07 -0.2181742949507000E-08
90 39 -0.2419090493010000E-07  0.5269194713752000E-07
90 40  0.1169157521234000E-07 -0.2789312264504000E-07
90 41  0.4110161283902000E-07  0.7976530768802000E-07
90 42  0.2355637725198000E-07  0.1813057626120000E-07
90 43  0.4414512362802000E-07 -0.6619841755762000E-07
90 44 -0.2604481679534000E-07  0.7691556673956000E-08
90 45 -0.2668814051675000E-07  0.2808949215861000E-08
90 46  0.4922700571934000E-08 -0.8683267963151000E-08
90 47 -0.7077499387561999E-09  0.3590894369137000E-07
90 48  0.9983721663903000E-08  0.1958098224305000E-07
90 49 -0.7213793770661000E-07 -0.3264613316932000E-07
90 50  0.5314895861735000E-07  0.1788944469609000E-08
90 51  0.9344301266929001E-08 -0.2897776900592000E-07
90 52  0.8629207344130000E-08  0.1313439830282000E-07
90 53 -0.2178932619802000E-07  0.1068295881219000E-07
90 54 -0.4262542832173000E-08 -0.1818788877038000E-07
90 55  0.1028598929406000E-07 -0.5541790069617000E-07
90 56 -0.8280271869880000E-07 -0.3547189901609000E-07
90 57  0.7737152635405000E-08  0.3437734106113000E-07
90 58  0.1600085260994000E-08  0.4328886622119000E-07
90 59  0.3118749845972000E-07 -0.1724066858894000E-07
90 60 -0.3620770186881000E-07 -0.4371835751596000E-07
90 61  0.2220237820843000E-07  0.3019638295541000E-08
90 62  0.2508190324311000E-07  0.3949371829082000E-07
90 63  0.9913503406517000E-08  0.7268068527908000E-07
90 64  0.2430305312090000E-07 -0.3967822927537000E-07
90 65 -0.4039440493540000E-08  0.2117345842967000E-07
90 66 -0.5023678780819000E-07  0.2444750152676000E-07
90 67  0.1384442648549000E-07 -0.3826117667175000E-07
90 68  0.5433545561298000E-09 -0.2834951140885000E-07
90 69  0.2707618407125000E-07  0.7026331832354000E-07
90 70  0.1384356171006000E-07 -0.4842088840941000E-07
90 71 -0.4551872986085000E-07 -0.5635074278612000E-07
90 72 -0.7034311842182000E-08 -0.4769346959431000E-07
90 73 -0.1723083028841000E-07 -0.1353452641001000E-07
90 74  0.3853059918613000E-07 -0.7620283362262000E-07
90 75 -0.2644503636523000E-07  0.5570214899482000E-07
90 76  0.3045553711694000E-07  0.9300560570880000E-08
90 77  0.2017530819079000E-07  0.3016061140531000E-07
90 78 -0.3006392293068000E-07  0.2072959147929000E-07
90 79  0.5752502116082000E-07 -0.3017665621189000E-07
90 80  0.7894545665615001E-07  0.9165645553542999E-07
90 81  0.4099880245537000E-07 -0.2977556024242000E-08
90 82 -0.3724132051491000E-07  0.7939662167828000E-08
90 83  0.1104723628392000E-07  0.2396306595518000E-07
90 84  0.4934302433032000E-07  0.4244397164696000E-07
90 85 -0.8437952613979001E-08 -0.1237986781963000E-06
90 86 -0.3205325897816000E-07 -0.2847349262738000E-07
90 87 -0.3295833031735000E-07  0.2173575479869000E-07
90 88 -0.3890163845790000E-08  0.1642760661630000E-07
90 89 -0.2612870939337000E-07  0.3185853161047000E-08
90 90  0.6450418365719000E-07 -0.2829651246053000E-07
91  0 -0.3439371184623000E-07  0.0000000000000000E+00
91 1  0.5440112249564000E-07 -0.5695126407088000E-07
91 2  0.1012093585892000E-06  0.2144712542687000E-07
91 3  0.3855671044283000E-07 -0.1872247203300000E-07
91 4 -0.4147114383701000E-07  0.7626738893399001E-07
91 5  0.5311105255646000E-07 -0.5280481632552000E-08
91 6  0.3651637936067000E-08  0.1159921771257000E-07
91 7 -0.3914013000179000E-07 -0.3912522592037000E-07
91 8  0.7920672306666000E-07 -0.4367949344367000E-07
91 9  0.4755171468130000E-07 -0.2445029452771000E-07
91 10 -0.5457493073946000E-09 -0.4426963441832000E-08
91 11 -0.8027829146952000E-08 -0.3154868200445000E-07
91 12 -0.6252399448972000E-07 -0.5732332812757000E-07
91 13 -0.7478399800760000E-08 -0.3154004830227000E-07
91 14 -0.2290084251855000E-07 -0.1476780045250000E-07
91 15  0.4224009063665000E-07  0.5080766634757000E-07
91 16  0.1516351594429000E-08  0.2189057675723000E-07
91 17  0.3684772729940000E-08  0.1587934043125000E-08
91 18  0.6606360003137000E-07 -0.3002719362530000E-07
91 19  0.5237675176363000E-08 -0.7346408503273000E-08
91 20  0.1772662763260000E-07  0.6445740673253000E-07
91 21  0.3764931623387000E-07  0.4646833276780000E-07
91 22  0.7528230882922000E-08  0.2069184170981000E-07
91 23 -0.4320326496439000E-08 -0.4872266093569000E-07
91 24 -0.2187680429882000E-07 -0.6473870603641000E-07
91 25 -0.1564368625622000E-07 -0.1589956994680000E-08
91 26  0.4378247306434000E-07  0.1464085669470000E-09
91 27  0.2560818794618000E-07 -0.7721314053323000E-08
91 28  0.4701907196787000E-07 -0.8655076446417999E-08
91 29 -0.3895159291015000E-07 -0.1372900704723000E-06
91 30 -0.4396263216515000E-07  0.2113205741848000E-07
91 31 -0.2479871784583000E-07  0.4963773983844000E-07
91 32 -0.2016683186834000E-08  0.8479673023458001E-08
91 33  0.4612926079214000E-07 -0.3452797944479000E-07
91 34 -0.7573867062947000E-08  0.2364181965111000E-07
91 35  0.2496645765959000E-07  0.5050799858426000E-08
91 36 -0.4120074512025000E-07  0.4298023912218000E-07
91 37  0.1744138760444000E-07 -0.5824266336161000E-09
91 38 -0.2855050045810000E-07  0.4098334907343000E-07
91 39 -0.4607000433563000E-07  0.5262169746799000E-07
91 40 -0.1326297727529000E-07 -0.6341466694523999E-07
91 41  0.2567856725952000E-07 -0.3292901155468000E-07
91 42 -0.7464858486229000E-07 -0.1333690599826000E-06
91 43 -0.2121981112998000E-07  0.4558199893285000E-07
91 44 -0.2382529808786000E-07  0.2282825561200000E-07
91 45  0.2544912718306000E-07 -0.2919750184924000E-07
91 46 -0.1776780159283000E-07  0.1654759977428000E-07
91 47 -0.1521055034086000E-07  0.4368266920938000E-07
91 48  0.2939545728273000E-07 -0.3145698653579000E-07
91 49  0.3984586166294000E-08  0.5302605538905000E-07
91 50  0.4064443034782000E-07 -0.7926256683255001E-08
91 51 -0.4798210951285000E-07 -0.1430530123710000E-07
91 52 -0.1225625447958000E-06  0.1772705500889000E-08
91 53  0.4808998834409000E-07 -0.1062938331588000E-07
91 54  0.6534902664497000E-07  0.5716059606175000E-07
91 55  0.1944552773831000E-07 -0.3705065011791000E-07
91 56 -0.2344904620200000E-07  0.7200369501481001E-07
91 57  0.1327558868654000E-07  0.3120426065790000E-07
91 58  0.2238948244869000E-07  0.7591318868585000E-08
91 59  0.2869336897724000E-07  0.3632790756323000E-07
91 60 -0.2804879145861000E-07 -0.7533094606687999E-08
91 61  0.6016526643090999E-07 -0.1381304664172000E-07
91 62 -0.4105093153597000E-07  0.2569230169658000E-07
91 63 -0.4257393530807000E-07 -0.2069165790038000E-07
91 64  0.3752061566704000E-07  0.6787439989796000E-08
91 65 -0.3425891342651000E-08  0.7234122803100000E-07
91 66  0.3512541199903000E-09 -0.2881372983158000E-07
91 67 -0.2987018454623000E-07 -0.8954394398151999E-08
91 68  0.6750139651302000E-08  0.5413652370741000E-07
91 69  0.8309550196390000E-08  0.2130008427750000E-07
91 70  0.2488082537351000E-07 -0.2624339955961000E-07
91 71  0.2679008182674000E-07  0.3843581002610000E-07
91 72  0.2755240192623000E-07 -0.2664365849605000E-08
91 73  0.5699599523185000E-07  0.2179349768783000E-07
91 74 -0.1417082944243000E-07  0.6629249122577000E-07
91 75 -0.5022073727847000E-07  0.1922724161080000E-07
91 76  0.1906480225572000E-07 -0.6502482809603000E-07
91 77 -0.5359990635765000E-07 -0.2271641386610000E-07
91 78  0.1430360574904000E-07 -0.6181781935466000E-07
91 79  0.4715616906447000E-07 -0.1751450751995000E-07
91 80 -0.5616839918507000E-07  0.6829331418607001E-07
91 81 -0.3484134717069000E-07 -0.9499506496877000E-07
91 82 -0.3808969098421000E-07  0.1747259161502000E-07
91 83 -0.4174563701331000E-07  0.2976897109798000E-07
91 84 -0.5810230084876000E-07  0.5394813766134000E-07
91 85  0.3085122811052000E-07  0.5071703259836000E-07
91 86 -0.2548834672725000E-07  0.8869911167539000E-07
91 87  0.2889880286556000E-07  0.3690277693053000E-08
91 88  0.7791455880515000E-07  0.5764137902278000E-07
91 89  0.2307790428357000E-07 -0.7164516176165000E-08
91 90 -0.3040590639170000E-07  0.1388459885549000E-07
91 91 -0.5856769885212000E-07  0.1578339709695000E-07
92  0  0.2838451722060000E-07  0.0000000000000000E+00
92 1  0.3172862187425000E-07 -0.3585716806686000E-07
92 2 -0.1526045942376000E-08  0.2057378100416000E-07
92 3 -0.2277929521287000E-07  0.2412780412241000E-07
92 4  0.1579964210246000E-07 -0.2362031913097000E-07
92 5 -0.4487557780958000E-07 -0.3979137814964000E-07
92 6  0.1155821384482000E-07 -0.7194432862126001E-07
92 7  0.4429887936107000E-08  0.2867104887002000E-07
92 8  0.2353058921297000E-07 -0.4465407225595000E-07
92 9  0.1441275750990000E-07 -0.2031821473948000E-07
92 10  0.2853375219001000E-07 -0.1939910590863000E-07
92 11 -0.5940690620292000E-07  0.3264346013568000E-07
92 12  0.8535976929713000E-08  0.2181231878225000E-07
92 13  0.4545902865314000E-08  0.1876920145499000E-07
92 14 -0.2795360265506000E-07  0.3979252804207000E-07
92 15 -0.6947206234112000E-07 -0.8150037646419000E-07
92 16  0.2989239968531000E-07  0.7446046264649000E-07
92 17  0.9596680843660000E-08  0.2182914985469000E-07
92 18 -0.8397971738998999E-08 -0.1526842071887000E-07
92 19 -0.6698307026785000E-07 -0.4112981793567000E-07
92 20 -0.6020687999935000E-07 -0.2584496099366000E-07
92 21 -0.4320105148762000E-07  0.6305630724251000E-07
92 22  0.1909132153847000E-08 -0.4877490275613000E-07
92 23  0.6978498365582999E-07 -0.2913830164713000E-07
92 24 -0.6206754570885000E-07  0.8158170520795000E-07
92 25  0.4298974418794000E-07  0.3242044104841000E-07
92 26 -0.3454569152882000E-08  0.2612771472866000E-07
92 27  0.4123982342905000E-07  0.6998732068502000E-07
92 28 -0.2752997661159000E-09 -0.3856687046181000E-07
92 29 -0.3126981565305000E-07  0.7628236837212999E-07
92 30  0.1361418143865000E-08  0.4388701690752000E-07
92 31  0.2169810409626000E-07 -0.3926368123044000E-07
92 32 -0.4185673072286000E-07 -0.6053938586208999E-07
92 33  0.8436780711840000E-08  0.7576321202549000E-07
92 34  0.3800305409338000E-07 -0.2993371669579000E-08
92 35 -0.6731336817524000E-07  0.4152845065373000E-07
92 36  0.1781818698213000E-07  0.1303179849550000E-07
92 37  0.4589889380737000E-07  0.1929947063590000E-07
92 38 -0.1824172844917000E-07  0.2414585831304000E-07
92 39 -0.1794614251200000E-07  0.2016891933274000E-07
92 40  0.1108015540418000E-06 -0.6294925246622000E-07
92 41 -0.7284447696142999E-07 -0.2821647139997000E-08
92 42  0.3882491691957000E-07  0.2412567509777000E-07
92 43  0.5423658443457000E-07  0.2902210784500000E-07
92 44  0.1800289103682000E-07  0.5445621266859000E-09
92 45 -0.3042792120012000E-07  0.5704437905027000E-08
92 46  0.3180111508599000E-07  0.7975684106957999E-07
92 47  0.1388158143722000E-07 -0.2361412054547000E-08
92 48  0.4488256709107000E-08 -0.4075399150757000E-07
92 49 -0.1954757103650000E-07  0.2060630616108000E-07
92 50 -0.3973853865310000E-07 -0.4445943121007000E-07
92 51 -0.1530122645545000E-07 -0.1015206568261000E-07
92 52  0.3863308571569000E-07  0.6225019100754000E-08
92 53 -0.1519760797444000E-08  0.6894707471789000E-07
92 54  0.1516896271459000E-07 -0.1607606793275000E-07
92 55 -0.2871041510357000E-07 -0.2459629664942000E-07
92 56 -0.2631183936083000E-07  0.3686210666532000E-07
92 57 -0.2104275471376000E-07 -0.7515409869490000E-07
92 58 -0.4926459979217000E-07  0.2104951257988000E-07
92 59 -0.2288131882502000E-07 -0.3350072075166000E-07
92 60 -0.1283731934868000E-07 -0.2882712995065000E-07
92 61 -0.4123248825617000E-07 -0.2273833427593000E-07
92 62 -0.5244413055195000E-07  0.4658587988797000E-07
92 63 -0.1262376882126000E-07 -0.8830351223169000E-08
92 64  0.3825192940524000E-07  0.4948623868507000E-07
92 65 -0.4956118719664000E-07 -0.3210023713297000E-07
92 66  0.2197046196585000E-07 -0.1246274084962000E-06
92 67 -0.1043616279844000E-07  0.7627236513530000E-07
92 68  0.3471301173193000E-07  0.1825102702532000E-07
92 69  0.1509536874935000E-07 -0.3453496701014000E-07
92 70 -0.8104410405368000E-08 -0.1288701611946000E-08
92 71 -0.7095686645223000E-07 -0.1027558843974000E-06
92 72  0.4244277138191000E-07 -0.2262755303370000E-07
92 73 -0.2200759830884000E-07 -0.1379572658108000E-07
92 74 -0.1668319093829000E-07 -0.3451716296575000E-07
92 75  0.1558120106154000E-07  0.1135554669989000E-07
92 76  0.1682867202646000E-07 -0.2973654753038000E-07
92 77 -0.1502481351610000E-07  0.1985950748023000E-07
92 78  0.4151388031897000E-07  0.6631844630976000E-07
92 79 -0.4097077762972000E-07  0.3560860979261000E-07
92 80 -0.3801827884585000E-07 -0.5667919118077000E-07
92 81 -0.3929690217053000E-08  0.6815155684245000E-08
92 82 -0.3604410253117000E-07  0.3479831245962000E-07
92 83 -0.5240643706221000E-08 -0.1002880371194000E-07
92 84  0.2803860804454000E-07  0.2451938143730000E-07
92 85 -0.1841415970979000E-07 -0.8689470680489000E-07
92 86 -0.5677190730420000E-07 -0.5350525677909000E-07
92 87  0.5479777895333000E-08  0.1584570420983000E-07
92 88 -0.1407028555144000E-07  0.1396216057402000E-07
92 89 -0.1408324815074000E-06 -0.9250084888852000E-08
92 90 -0.4778188976714000E-07  0.2711259408892000E-07
92 91 -0.1926766087533000E-07 -0.1098990959643000E-07
92 92  0.2077866873146000E-08  0.1207699257591000E-07
93  0  0.2976284966321000E-07  0.0000000000000000E+00
93 1 -0.1062724312378000E-07 -0.4250387930424000E-07
93 2 -0.1214013685478000E-07 -0.8574921902860001E-08
93 3 -0.5390285430512000E-07 -0.5180468962658000E-07
93 4 -0.6367111854463999E-07  0.1128044711995000E-07
93 5  0.1683101981482000E-07 -0.4083992102803000E-07
93 6 -0.1228779328893000E-07  0.4933506690167000E-07
93 7  0.2028638851030000E-07 -0.5766037483057000E-07
93 8 -0.2409256101075000E-07  0.4081703690374000E-07
93 9  0.5086546065028000E-08 -0.1234175139006000E-08
93 10 -0.5120212397246000E-07  0.9598139838669999E-07
93 11  0.3108629420505000E-07 -0.4682116850136000E-07
93 12 -0.2016607055624000E-07 -0.6983834237291000E-07
93 13 -0.4965464443975000E-08 -0.1671633892488000E-09
93 14  0.1134654942402000E-07 -0.9981433353180999E-08
93 15 -0.3995775649408000E-07 -0.2219990901451000E-07
93 16  0.1547414860793000E-07  0.5969082873192000E-07
93 17 -0.2904180891338000E-07 -0.9881727850661999E-07
93 18 -0.1721598029666000E-07  0.6145086028829000E-07
93 19 -0.5049911415730000E-07 -0.8550582608707999E-08
93 20  0.7497031991239000E-07  0.3582711239456000E-07
93 21  0.1557184578706000E-07 -0.2084907265477000E-07
93 22  0.5812962999676000E-07 -0.5697304098952000E-07
93 23 -0.5381209477493000E-08  0.1075132735440000E-07
93 24  0.3153160632525000E-07 -0.7704790347670000E-07
93 25 -0.4378734481014000E-07  0.9495094345808000E-08
93 26  0.3326990895958000E-07  0.2876008326466000E-07
93 27 -0.4510973247087000E-08  0.2945341778854000E-09
93 28 -0.5649042160515000E-07 -0.6852021865966000E-07
93 29 -0.8373906408996000E-08  0.2096390724055000E-09
93 30  0.5232419998291000E-09 -0.1596842903318000E-07
93 31 -0.9550482381363000E-09 -0.4104867420367000E-07
93 32 -0.3146864870030000E-07 -0.1470873761199000E-07
93 33  0.3426096972244000E-08  0.1212247970060000E-07
93 34 -0.9643946834764999E-07 -0.6685987276199000E-07
93 35  0.4433670364751000E-07  0.6646378676430000E-08
93 36  0.7139639123694000E-08  0.1298684048931000E-07
93 37 -0.3753805590417000E-07 -0.2535414593240000E-07
93 38  0.7806938259255000E-07 -0.2764705123599000E-07
93 39  0.1784666507804000E-07 -0.5217067042242000E-07
93 40 -0.1771754747524000E-07 -0.5486699327746000E-07
93 41 -0.1462473064335000E-07  0.9703286568604000E-07
93 42  0.1718542435267000E-07  0.5667876081041000E-07
93 43 -0.1900642021263000E-07 -0.1475505888074000E-07
93 44  0.1477794841965000E-07 -0.6148691748130001E-07
93 45 -0.4337261661114000E-07 -0.4055701721346000E-07
93 46  0.2063453604498000E-07 -0.5199767699957000E-07
93 47  0.3358748569647000E-07 -0.5822163698162000E-07
93 48  0.7260055247351000E-08  0.1707538736743000E-07
93 49 -0.4345857494126000E-07 -0.6127319082490000E-07
93 50  0.3235611960731000E-07 -0.2208106862069000E-07
93 51  0.6126348748248000E-07  0.1243965266119000E-07
93 52 -0.1474842506359000E-08  0.1256411751254000E-08
93 53  0.2621295145715000E-07  0.2658326549096000E-07
93 54 -0.8324086963975001E-08 -0.4415815490704000E-07
93 55 -0.8556729448295000E-09  0.2728164918966000E-07
93 56  0.4046183515873000E-07  0.7676693327797001E-08
93 57  0.6349126979213000E-08 -0.6500303739775000E-08
93 58  0.5692616245638000E-07 -0.9218856436247000E-08
93 59 -0.1813084636432000E-07 -0.2914085495563000E-07
93 60 -0.3613147968293000E-07  0.1420222278939000E-07
93 61  0.5620375332671000E-07  0.6663062258179000E-08
93 62  0.5533278960219000E-07  0.5056563757138000E-07
93 63 -0.5010520201189000E-07 -0.5196330627052000E-07
93 64  0.6229851017493000E-07  0.3297449317834000E-07
93 65 -0.4521108765957000E-07  0.8853825183067001E-08
93 66  0.3463156788856000E-08  0.5645360374696000E-07
93 67  0.5182398240865000E-07  0.5861923369815000E-07
93 68  0.8394014072624000E-07 -0.3933361777306000E-07
93 69 -0.2373082687147000E-07 -0.7491014214466001E-07
93 70  0.2197612079180000E-07  0.4746646383696000E-07
93 71 -0.1131278164393000E-07 -0.7367780797821000E-08
93 72  0.6282093610072000E-07  0.8954795619173000E-07
93 73 -0.2784054903052000E-07 -0.2529571894187000E-07
93 74 -0.1219157836329000E-07  0.5353438041042000E-08
93 75 -0.2331543325499000E-07  0.1378828848265000E-07
93 76 -0.6276601075325000E-08 -0.3428627986697000E-07
93 77 -0.4477341182687000E-08 -0.5027780047295000E-08
93 78  0.1204392031043000E-07 -0.3100253643630000E-07
93 79 -0.4343745544665000E-07 -0.4699050981220000E-07
93 80  0.8854657091565000E-07  0.1858140474271000E-07
93 81  0.3218407871087000E-07 -0.6506100177902000E-09
93 82 -0.3136677337437000E-07 -0.2299171242233000E-07
93 83 -0.1531277364167000E-07  0.1893392960700000E-07
93 84  0.5568316746540000E-07 -0.4515511343065000E-07
93 85  0.1434006819718000E-07  0.1694661062400000E-07
93 86  0.3459627166501000E-07 -0.2045297906969000E-07
93 87  0.5978536234362000E-07  0.7062251627442999E-07
93 88  0.4497549887795000E-08 -0.2118214891202000E-07
93 89  0.9023245115889001E-07  0.4065210748791000E-07
93 90  0.8484262021575000E-07 -0.2728590481303000E-07
93 91  0.4588899991684000E-07 -0.3909674069438000E-07
93 92  0.1881471829592000E-07 -0.2770285119182000E-07
93 93  0.6691918624883000E-07  0.1740856280107000E-07
94  0 -0.9805482132011999E-07  0.0000000000000000E+00
94 1 -0.8795561762358000E-07  0.1194218723618000E-08
94 2 -0.3410822897405000E-07 -0.1458354745331000E-07
94 3  0.1279759501285000E-07 -0.1438866297014000E-07
94 4 -0.4030485167389000E-07 -0.4631994020213000E-07
94 5  0.2175336803850000E-07  0.1313224834435000E-07
94 6  0.1419810615217000E-07 -0.3144886173252000E-07
94 7 -0.5570135190379000E-07  0.9552983467809000E-07
94 8 -0.6092066943212000E-07 -0.6160512976909000E-07
94 9  0.4613135913319000E-07  0.1262163705018000E-07
94 10  0.1430620052295000E-07 -0.1438196750840000E-07
94 11 -0.3804640069093000E-07 -0.2723956015234000E-07
94 12  0.1860224321756000E-07  0.1537896469048000E-07
94 13 -0.2713855686391000E-07 -0.1801285307884000E-07
94 14  0.6328689625493000E-08 -0.4791454316967000E-07
94 15  0.3443985983909000E-07  0.3247472493976000E-07
94 16  0.7142564491309000E-07 -0.2469920676952000E-07
94 17  0.2588015590394000E-07 -0.3174590084946000E-07
94 18  0.4273731901729000E-07 -0.7564529946999000E-08
94 19 -0.1077578929380000E-07 -0.1128630232714000E-07
94 20  0.2595587256137000E-07  0.6318681277635000E-08
94 21 -0.1902160972761000E-08 -0.2589549695390000E-07
94 22  0.8503493051755000E-07 -0.2048116141471000E-07
94 23  0.2877179318320000E-07  0.3251590293633000E-07
94 24 -0.1172027186795000E-06  0.3392247906663000E-07
94 25 -0.3895301019310000E-08  0.6704741374562000E-07
94 26  0.3943996676030000E-07 -0.2137927451739000E-07
94 27 -0.5457361793054000E-07 -0.5089575960472000E-07
94 28  0.4204173178853000E-07  0.7624594352230001E-08
94 29 -0.2961631876975000E-07 -0.7028819235130000E-07
94 30  0.3038169880271000E-07 -0.1630546208603000E-07
94 31 -0.7784147549443000E-07  0.5677094786914000E-07
94 32  0.2192585154237000E-07  0.2760335501692000E-07
94 33 -0.1728488993684000E-08  0.1109884150453000E-07
94 34  0.1648132120507000E-07  0.3337564863749000E-07
94 35 -0.1006118276184000E-07  0.7847223120670000E-08
94 36  0.4717003890960000E-08 -0.2042253635539000E-07
94 37  0.6946463159527000E-07 -0.2686181554435000E-08
94 38 -0.8389969339642999E-08 -0.2315743385314000E-07
94 39 -0.4305851296616000E-07 -0.6802310398046000E-08
94 40 -0.2198643239368000E-07  0.1460745295925000E-07
94 41 -0.5636679401694000E-07  0.7188932097657000E-07
94 42  0.1014367451405000E-07 -0.4448748749200000E-07
94 43 -0.3503822232406000E-07 -0.9928422285700000E-07
94 44 -0.1244333453979000E-07  0.2806406864208000E-07
94 45 -0.1804259087978000E-07  0.8741274491231001E-08
94 46  0.5182616855550000E-08  0.1176673781593000E-06
94 47 -0.6866486611526000E-07  0.3963241346632000E-07
94 48 -0.9578493634689999E-08 -0.4303635990075000E-07
94 49 -0.1047471968322000E-07  0.8835345685930001E-08
94 50  0.6775749006292000E-07  0.8919502040623001E-07
94 51  0.1664931820953000E-07  0.1941137451831000E-07
94 52 -0.9539834603979000E-08  0.4319733129003000E-08
94 53 -0.8485110156632000E-07 -0.6522588193170000E-07
94 54  0.1705919926875000E-07  0.4038179399061000E-08
94 55 -0.1467425544348000E-07 -0.7390252439295000E-08
94 56  0.3491940640217000E-07 -0.2274319621544000E-07
94 57 -0.2531198441781000E-07  0.5763696716973000E-07
94 58 -0.2545626449459000E-08  0.1728913583674000E-08
94 59  0.7616368252657000E-07 -0.2623926732046000E-09
94 60  0.9711863177495000E-08  0.3950323175283000E-07
94 61  0.6752150577539001E-07  0.1989344376627000E-08
94 62 -0.3739270533363000E-07  0.1199679174999000E-07
94 63 -0.3013304393411000E-07  0.6965043079023000E-08
94 64  0.5340724557389000E-08  0.6264576857980000E-07
94 65 -0.4892544337777000E-07 -0.3288308217044000E-07
94 66  0.5641693750576000E-07  0.1904544382791000E-07
94 67  0.2499824723681000E-09  0.3720154935905000E-09
94 68 -0.8198647566462999E-07  0.1025546288003000E-07
94 69 -0.3108669645796000E-07  0.4503231334551000E-07
94 70  0.3999408534875000E-07  0.1489043229880000E-08
94 71  0.2605491557366000E-07 -0.9892259140274000E-08
94 72 -0.4618833805436000E-07  0.1285302962988000E-07
94 73  0.1405372723111000E-07 -0.6280501919212000E-07
94 74  0.1295735051027000E-07 -0.5610954214141000E-08
94 75  0.7322281293546000E-07 -0.5742662086150000E-07
94 76 -0.2156377665845000E-08  0.2151306831143000E-07
94 77  0.1672076453349000E-07  0.4305246152333000E-07
94 78 -0.3601844398944000E-07  0.1775365603566000E-08
94 79  0.3678547730884000E-08  0.3390733053851000E-07
94 80  0.9877203297389999E-09  0.4699706856081000E-07
94 81 -0.3723627333449000E-07 -0.4166316369058000E-07
94 82 -0.2604890513942000E-07 -0.7049555949913000E-08
94 83 -0.9368271854765000E-08  0.4094086304514000E-07
94 84  0.2132729821668000E-07  0.3497549265535000E-08
94 85 -0.3190728597378000E-07 -0.3441955446936000E-07
94 86 -0.4477118946175000E-07 -0.1932677790024000E-07
94 87  0.7539383176884000E-08  0.1093370643826000E-07
94 88  0.1656456618368000E-07 -0.4418091667429000E-07
94 89 -0.1013794099180000E-06 -0.2808101565376000E-07
94 90 -0.1258135125328000E-06 -0.3603202954226000E-08
94 91 -0.1542272480695000E-07  0.1977880049807000E-07
94 92 -0.4010231882348000E-07 -0.9068544462579000E-08
94 93 -0.3577231290397000E-07 -0.1415216696382000E-07
94 94 -0.3831504915014000E-07 -0.9659318811937000E-08
95  0  0.5818231916168000E-08  0.0000000000000000E+00
95 1  0.3443520394556000E-07 -0.6258617187160000E-08
95 2  0.4377517405012000E-07 -0.1265613718950000E-07
95 3 -0.5701934711382000E-07  0.4094790361888000E-07
95 4 -0.1233511507638000E-07  0.2975322648122000E-08
95 5  0.2624070467831000E-07  0.2088626559337000E-07
95 6 -0.1941354843708000E-07 -0.3218123426986000E-07
95 7  0.2603798150689000E-07 -0.7328586485726000E-07
95 8  0.9279707184920999E-07 -0.3905843754710000E-07
95 9  0.8150035075428999E-07  0.2935894673845000E-07
95 10 -0.3541573394566000E-07 -0.2378583686009000E-07
95 11  0.1115185325882000E-06 -0.3024865320840000E-08
95 12 -0.2094123161706000E-08  0.1510823402637000E-07
95 13  0.7228803648107000E-07  0.8140577038095000E-07
95 14  0.4758777711115000E-07  0.3115221822040000E-07
95 15 -0.1374753760876000E-07  0.3695148011981000E-08
95 16 -0.5239680514592000E-07  0.7447606562700000E-08
95 17 -0.4693352317951000E-07  0.6478272445135000E-07
95 18 -0.1453682021994000E-07  0.2095330407138000E-07
95 19 -0.4838290054360000E-08  0.3103479910736000E-08
95 20  0.5160167212255000E-07  0.3711974536450000E-09
95 21 -0.5459388756336000E-07  0.2163224976407000E-07
95 22 -0.1675786736946000E-07 -0.4111671060173000E-08
95 23 -0.1047646238429000E-06  0.1340667695565000E-07
95 24  0.1037072111194000E-07 -0.2626974236378000E-07
95 25  0.1124489890955000E-06 -0.2470501712362000E-07
95 26  0.4181432312780000E-07 -0.3106745086724000E-07
95 27  0.3037499943379000E-07  0.4459877430229000E-07
95 28  0.1956166690250000E-07 -0.1901232534797000E-07
95 29  0.4017537717417000E-07  0.1225891239420000E-07
95 30  0.1545662440993000E-07  0.5825983296003000E-07
95 31  0.6683153092333000E-07  0.4088840883351000E-07
95 32  0.4040300742815000E-07 -0.4942983760283000E-07
95 33 -0.1470603840162000E-07  0.3265075522773000E-08
95 34  0.2009562169354000E-07 -0.2077796167120000E-07
95 35  0.5602910065354000E-07 -0.1272876939772000E-07
95 36  0.1778648905368000E-07 -0.1451897849718000E-07
95 37  0.6055143079088000E-08  0.3251878231977000E-08
95 38 -0.2197333860137000E-07  0.1412544309598000E-07
95 39  0.2932307428173000E-07  0.2361186986570000E-07
95 40  0.4050364668467000E-08 -0.2141074180244000E-07
95 41  0.2162659664073000E-07  0.2460808011552000E-07
95 42  0.1588955065234000E-07 -0.2844539918366000E-07
95 43  0.5521781964251000E-07  0.2015107524184000E-07
95 44  0.2507792021957000E-07  0.2338877324674000E-07
95 45  0.7664617206523001E-07  0.1991166608842000E-07
95 46  0.1794603312293000E-07 -0.1077518418020000E-07
95 47  0.5990791178417000E-07 -0.8936483539459999E-08
95 48 -0.2074095455742000E-07  0.1396185614937000E-07
95 49 -0.5924782646153000E-09  0.2913043934486000E-07
95 50 -0.1771356460164000E-07 -0.2589731493934000E-08
95 51 -0.2875657859994000E-07 -0.4929975030151000E-07
95 52 -0.3855646102866000E-07 -0.6982928818548000E-08
95 53  0.5380207116029000E-07  0.1656207879801000E-07
95 54  0.3461446350379000E-07 -0.1994979058602000E-08
95 55 -0.4082601044664000E-07 -0.1027434362308000E-07
95 56  0.4128049842190000E-07  0.7972586368015000E-08
95 57  0.1933649940912000E-07  0.2416395237086000E-07
95 58  0.1574337969136000E-07 -0.2849890383221000E-07
95 59 -0.9325412791583000E-07  0.6479310887007000E-08
95 60 -0.2991366516429000E-07 -0.1593994566626000E-07
95 61  0.1720464735168000E-07 -0.8648203179761001E-08
95 62 -0.2123215204362000E-07 -0.2505582634820000E-07
95 63 -0.1188612439915000E-08 -0.1079902398949000E-07
95 64 -0.1171166781841000E-07 -0.9452318392882000E-08
95 65  0.7354095550864000E-08 -0.9310130206026000E-08
95 66 -0.2156248432647000E-07 -0.1072431537076000E-07
95 67 -0.2036473514066000E-07 -0.2222275022579000E-07
95 68  0.1659444571934000E-07 -0.3131119638444000E-07
95 69  0.6760094287142000E-07 -0.2474211723311000E-07
95 70 -0.2894239423083000E-07  0.3441484581590000E-07
95 71 -0.4901456677834000E-07  0.2176131218930000E-07
95 72  0.1194277201278000E-07 -0.1478761389250000E-08
95 73  0.6278464439007000E-08 -0.1565751270654000E-07
95 74  0.3675936773818000E-07  0.3791230805927000E-07
95 75  0.4210075568526000E-07  0.4004117210968000E-07
95 76 -0.5649202151996000E-07  0.5507049123590000E-07
95 77  0.2301950741310000E-07  0.1461925838579000E-07
95 78  0.1535970240630000E-07 -0.2473382299028000E-07
95 79  0.1622141904430000E-07 -0.1906217564913000E-07
95 80  0.3124084468007000E-07 -0.3336790763509000E-07
95 81 -0.3036815043394000E-07 -0.2504854428703000E-07
95 82 -0.1012287751159000E-07  0.4032875829383000E-07
95 83  0.7422581701898000E-07 -0.3100053670701000E-07
95 84  0.1782734815883000E-08  0.9431044783484000E-09
95 85 -0.3001387868701000E-07  0.1590236294626000E-07
95 86  0.1164512602522000E-07  0.4858002852059000E-07
95 87  0.4229279021214000E-07  0.3706620074889000E-07
95 88 -0.4535175718140000E-07 -0.5307484201746000E-07
95 89  0.1295605031310000E-08  0.1967136672550000E-07
95 90  0.8998424043740000E-07  0.7463551681205000E-08
95 91  0.2386807566987000E-07 -0.5494189112370000E-08
95 92 -0.4290052647284000E-07  0.2216089620998000E-07
95 93  0.2535676847628000E-07  0.6521665034560000E-07
95 94  0.1560398264867000E-08  0.2046092762417000E-07
95 95 -0.4329762696383000E-07  0.2622297931973000E-07
96  0  0.2440244292898000E-07  0.0000000000000000E+00
96 1 -0.2513215027920000E-07 -0.1890141160332000E-07
96 2 -0.3930525869813000E-07  0.2133483345724000E-07
96 3  0.3535460912155000E-07  0.3801591165138000E-07
96 4  0.4718245103331000E-08 -0.1651356758358000E-07
96 5 -0.6242785554409000E-08 -0.3951027169182000E-07
96 6  0.4815145617650000E-07  0.2048099484718000E-07
96 7 -0.6400208319197000E-09  0.3855947371663000E-07
96 8 -0.4211364980188000E-07  0.2464763797140000E-07
96 9  0.2059155069824000E-07  0.1954298828914000E-07
96 10 -0.2033950995182000E-07  0.7785978283017000E-09
96 11  0.6678112385004000E-08  0.9772101157135999E-08
96 12 -0.1198004744224000E-07 -0.6560561890666001E-07
96 13 -0.3540449749403000E-07 -0.1850473927910000E-07
96 14 -0.4796053173275000E-07 -0.5791680073564000E-07
96 15 -0.3683569524010000E-07 -0.3940604405752000E-07
96 16  0.5212610571349000E-07  0.3595986766402000E-07
96 17  0.2165235651683000E-08  0.1597236093291000E-07
96 18 -0.2301501865370000E-07 -0.5672883127197000E-07
96 19 -0.1556398787079000E-07  0.2781682653755000E-07
96 20 -0.3760824100476000E-07 -0.4084458530483000E-07
96 21 -0.1771648897753000E-09  0.6557119763072000E-08
96 22 -0.4259573942670000E-07 -0.9883935410296000E-08
96 23  0.6121189464074000E-07  0.1305486127951000E-07
96 24  0.1015531842649000E-07 -0.8698454737628999E-08
96 25 -0.6105602409506999E-07 -0.5358001770667000E-08
96 26 -0.2288290859470000E-07  0.1971386847416000E-07
96 27 -0.2645942041651000E-07  0.3090950413282000E-07
96 28  0.2897266422573000E-07 -0.1837873985163000E-08
96 29 -0.2478191046993000E-07  0.2516453032668000E-07
96 30  0.2753415129843000E-07  0.6486654342526000E-07
96 31 -0.7590647414611001E-08  0.7057344786301000E-08
96 32 -0.3415612178924000E-07 -0.2208756521210000E-07
96 33 -0.2071148483436000E-07  0.3937623463512000E-07
96 34 -0.2282522824374000E-08 -0.2794611268370000E-07
96 35  0.6680988758151000E-08  0.5083800202130000E-07
96 36  0.3712965073933000E-07 -0.5144492962278000E-07
96 37  0.7563290563580000E-08 -0.3723659240290000E-07
96 38 -0.4013306443616000E-07  0.2262118484884000E-07
96 39  0.1127908453397000E-08 -0.1001896470470000E-07
96 40 -0.5624037419608000E-07 -0.9950130221088000E-08
96 41  0.2869416904719000E-08  0.4378076538745000E-07
96 42 -0.3174017315054000E-07 -0.2353698000092000E-07
96 43 -0.2238705628387000E-07  0.9273021682249000E-09
96 44  0.6034920377692000E-07  0.1599089391614000E-07
96 45 -0.1632396351292000E-07 -0.5074426747117000E-08
96 46 -0.4232339267849000E-07 -0.9836609748735000E-08
96 47 -0.1091241902337000E-07 -0.2998468646057000E-07
96 48  0.1119449903649000E-07 -0.6928470585263000E-07
96 49 -0.2597158482118000E-07 -0.1863460861936000E-08
96 50  0.1538709631976000E-07 -0.1270889588139000E-07
96 51  0.7249750692110000E-08  0.1234439060541000E-08
96 52  0.1372829070020000E-07  0.4304440111051000E-07
96 53  0.8349422382452000E-07  0.2169017556945000E-07
96 54 -0.3610167275243000E-07 -0.3901353618934000E-07
96 55  0.3324548812106000E-07 -0.9931732455002000E-08
96 56  0.4830052967511000E-07  0.1657036535712000E-07
96 57 -0.9988865907204000E-08  0.1317776151862000E-07
96 58  0.2439012901076000E-07  0.2393429580378000E-07
96 59 -0.4561249442190000E-07  0.4049682320657000E-07
96 60  0.7025338365908999E-07 -0.8813538062848000E-08
96 61  0.2843451435758000E-07  0.2338935966370000E-07
96 62  0.2037720126438000E-07 -0.3926062662678000E-07
96 63 -0.1728146851871000E-07  0.1756502436569000E-07
96 64  0.3023948343672000E-07  0.5625335305419000E-07
96 65 -0.4186630295902000E-07 -0.6457883205870000E-08
96 66  0.2774554309549000E-07 -0.4773165103344000E-07
96 67 -0.2082639127775000E-07  0.1331824546194000E-08
96 68  0.1060173659950000E-07  0.1442570236014000E-07
96 69  0.8544189408005999E-08  0.5755119075052000E-07
96 70  0.6027728964795000E-07 -0.7151369435805000E-08
96 71  0.7556021730416000E-07 -0.5753260251497000E-07
96 72  0.5837382425313000E-07 -0.3455688028468000E-07
96 73 -0.4085384724048000E-08  0.2062134218906000E-07
96 74  0.2929743004389000E-08  0.8703525569543000E-08
96 75 -0.1177472568318000E-07  0.6061727990391000E-08
96 76 -0.3352830981809000E-07 -0.2105510120713000E-07
96 77 -0.1790234505885000E-07 -0.1086421104128000E-07
96 78 -0.8444505847189000E-08 -0.6141102322416000E-07
96 79 -0.1481117251335000E-07 -0.2289927873815000E-07
96 80 -0.5991170770038000E-07 -0.9521131483204000E-08
96 81 -0.2137095594919000E-07  0.5349325395152000E-07
96 82 -0.3784886728641000E-07 -0.6255988885360000E-07
96 83  0.3024070808923000E-07 -0.1927772650998000E-07
96 84 -0.4213479463802000E-07 -0.6467077018926000E-09
96 85 -0.3936309585907000E-07 -0.9358568251239000E-07
96 86  0.4463443387069000E-08  0.1795097475439000E-07
96 87  0.2585406715282000E-08 -0.1844602404853000E-08
96 88 -0.2379745836791000E-07 -0.6344969417049000E-07
96 89  0.9117285011594000E-08  0.1407712499974000E-07
96 90  0.7920056964773001E-08  0.4982379691905000E-07
96 91 -0.2131797109894000E-07 -0.6210249317237000E-08
96 92  0.2653822280341000E-07 -0.1167206188370000E-07
96 93 -0.6381020151965000E-08 -0.1162468278140000E-07
96 94 -0.3766722117978000E-07  0.6591385842365000E-08
96 95 -0.1450690819321000E-07 -0.3379135427064000E-07
96 96  0.1982130090585000E-07 -0.3427457111852000E-07
97  0 -0.3770626977082000E-07  0.0000000000000000E+00
97 1 -0.5306854202242000E-07  0.1207394165861000E-07
97 2 -0.1969961978808000E-07  0.1821074722583000E-07
97 3 -0.9317299294782999E-08  0.8012547039407999E-08
97 4 -0.1591760489870000E-07 -0.1864340935494000E-07
97 5  0.5075153927061000E-07  0.1028482501152000E-07
97 6  0.3837857124270000E-07  0.1887655955245000E-07
97 7 -0.3074594216293000E-07 -0.5508663045199000E-07
97 8 -0.9386838564550000E-08  0.7365930504651000E-08
97 9  0.7595493542470999E-08 -0.1693367940873000E-07
97 10 -0.2244202074364000E-07 -0.1136069708788000E-07
97 11  0.3258325276610000E-07 -0.2408413163237000E-07
97 12 -0.3543221758263000E-07  0.8536976450638001E-07
97 13 -0.7353486061736000E-08  0.6389784391176000E-07
97 14  0.1038964329612000E-06 -0.2075073996328000E-07
97 15  0.8751534872533000E-08  0.1942294684010000E-07
97 16 -0.2124474005079000E-07  0.9609051400956001E-08
97 17  0.1721358754502000E-07 -0.3089491429574000E-07
97 18  0.8329455831013001E-08  0.1390386517885000E-07
97 19 -0.2089100746487000E-07 -0.7848113032287000E-07
97 20  0.1800351911318000E-07  0.1035319768815000E-07
97 21 -0.3082713753186000E-07 -0.1070789692099000E-07
97 22  0.3905252709380000E-07  0.6054174633814000E-07
97 23  0.2288543083010000E-07  0.7323636345156000E-08
97 24 -0.4057790532898000E-08 -0.7923296164902000E-07
97 25  0.5650182034954000E-08  0.2156286022946000E-07
97 26 -0.9053496195544001E-08  0.4217880776286000E-07
97 27 -0.2594378898219000E-07 -0.3086787793421000E-07
97 28 -0.3115928215445000E-08  0.1629150139856000E-07
97 29 -0.9333281153678000E-08 -0.5636078376096000E-08
97 30 -0.6285355547915000E-07 -0.4804228468417000E-07
97 31 -0.1593140164229000E-07  0.1082124308280000E-07
97 32  0.1792671445047000E-07 -0.2537636890717000E-07
97 33  0.2311829900106000E-07  0.1348225959039000E-07
97 34 -0.2121356138747000E-07  0.4417145711831000E-08
97 35  0.2668121197472000E-07 -0.3722657525931000E-07
97 36  0.1027714276678000E-07  0.2241407484148000E-07
97 37  0.2019087357149000E-07  0.8483229423451000E-07
97 38  0.6106296755967000E-07 -0.3167570798593000E-07
97 39  0.1396242012694000E-07 -0.1410264588640000E-07
97 40 -0.1648385337724000E-07 -0.2759925695716000E-07
97 41 -0.2482955487888000E-07  0.2625363593247000E-07
97 42  0.2586633086374000E-07 -0.5778104346810000E-08
97 43  0.1477517395328000E-07  0.1550720998114000E-07
97 44 -0.5030407748114000E-09 -0.2672305238911000E-07
97 45 -0.2277542346738000E-07  0.6053479782040001E-07
97 46 -0.7728756048863000E-09 -0.3170374309516000E-07
97 47 -0.8070562148622000E-08  0.5502555460087000E-07
97 48  0.1595740445018000E-07 -0.2009531863449000E-07
97 49 -0.6488140450202000E-07  0.4021190329837000E-07
97 50  0.4320233585945000E-07 -0.2300486929623000E-08
97 51  0.2031701063946000E-07 -0.5148114671964000E-08
97 52  0.1856950447718000E-07 -0.1864772998498000E-07
97 53 -0.6319839951753000E-07 -0.1003115027701000E-06
97 54  0.1140998788277000E-07  0.2710755951952000E-07
97 55  0.2235322874250000E-07  0.3236907170359000E-07
97 56  0.4350932955123000E-07 -0.5202694187632000E-08
97 57 -0.6661751849953000E-07  0.2263250785390000E-07
97 58 -0.5023356703945000E-07  0.2099181807261000E-08
97 59  0.2182546278732000E-07  0.2189729872374000E-08
97 60  0.2744859055199000E-07 -0.6779751876010000E-08
97 61 -0.1181539904192000E-07 -0.1457552112900000E-07
97 62  0.6513032357420000E-08  0.4012899308096000E-07
97 63 -0.3985038169514000E-07  0.2904284240424000E-07
97 64 -0.4248624135667000E-08  0.3143767985396000E-07
97 65 -0.5287768847311000E-08 -0.3647539214104000E-07
97 66 -0.5620598657591000E-08 -0.1396353989344000E-07
97 67  0.1261587771228000E-07  0.9402405896814000E-08
97 68  0.6024092596510001E-07  0.6779286096565000E-07
97 69  0.3068174897370000E-07 -0.1162608892096000E-07
97 70 -0.5195724341289000E-07 -0.3619707761049000E-07
97 71  0.3943316530520000E-08  0.2116331793327000E-09
97 72 -0.3509174378116000E-07  0.5281593083178000E-07
97 73 -0.8853215224115001E-08  0.1831368279700000E-07
97 74 -0.6007847530465000E-08 -0.3098897742247000E-07
97 75 -0.2482546763276000E-07  0.6044406413177001E-07
97 76 -0.1973257344010000E-07 -0.9415434114660001E-07
97 77  0.1927293404549000E-07 -0.1043828235197000E-08
97 78 -0.4609372453281000E-07 -0.3331028133018000E-07
97 79 -0.6353440462012000E-08  0.5989553548687999E-07
97 80  0.4803203230321000E-07  0.5652073766419000E-07
97 81 -0.3870455768341000E-07 -0.3505147765302000E-07
97 82  0.1263193337560000E-07 -0.6527835999757000E-08
97 83  0.3329933102440000E-07  0.2979631828640000E-07
97 84 -0.1674879226155000E-07  0.6708896262101000E-08
97 85  0.5093473909448000E-07  0.6677428129025000E-07
97 86  0.1060905242037000E-07  0.8420163598087000E-07
97 87 -0.1126514847841000E-07 -0.2890283510678000E-07
97 88  0.2021093867722000E-07  0.2485326804709000E-07
97 89 -0.3681029368460000E-07  0.5314152537798000E-07
97 90  0.3681974598567000E-07  0.3409738841078000E-09
97 91 -0.2810010988106000E-07 -0.2495538029732000E-07
97 92 -0.4104261083529000E-07  0.1451345767535000E-07
97 93 -0.3539666681524000E-07 -0.4668763341643000E-07
97 94 -0.7354500688592000E-08 -0.3220998465706000E-07
97 95 -0.5075161040315000E-08  0.1151654769127000E-07
97 96  0.4385201626574000E-07  0.5564354139641000E-07
97 97  0.3346285834361000E-07  0.5218756206057000E-07
98  0 -0.4603681544198000E-07  0.0000000000000000E+00
98 1  0.2572153078381000E-07 -0.2008846033522000E-07
98 2  0.4552172796474000E-07 -0.2119266532909000E-07
98 3  0.2080043590278000E-07  0.9507675041734000E-08
98 4 -0.2048535142634000E-07 -0.4834307712005000E-07
98 5 -0.1634444680735000E-08 -0.2545112143013000E-08
98 6 -0.2910503736073000E-07  0.2233065465222000E-07
98 7 -0.7290534991858001E-07 -0.1028782448495000E-07
98 8  0.4196241307484000E-07 -0.1146901669922000E-07
98 9  0.1649765804642000E-07  0.4039146285934000E-07
98 10 -0.2936293533966000E-07 -0.7642874017924000E-08
98 11  0.3309666640471000E-07 -0.3077958508806000E-07
98 12 -0.1323302251593000E-07  0.1930239501088000E-07
98 13  0.3839684496522000E-07 -0.2554072759750000E-07
98 14  0.2808186435570000E-07 -0.2114753101731000E-07
98 15  0.3390942238641000E-07  0.4368572473922000E-07
98 16  0.8815317148795000E-07  0.6020129214565000E-08
98 17 -0.3053266228832000E-07  0.2093628729613000E-07
98 18 -0.5502171869422000E-07 -0.1194334149134000E-07
98 19 -0.1585967340337000E-07  0.1773799428038000E-07
98 20 -0.3918243333737000E-07  0.1506976484564000E-07
98 21  0.4366478185566000E-07 -0.7170094147566000E-08
98 22  0.5808666947171000E-07  0.2067310506775000E-07
98 23  0.2882192311622000E-07 -0.4745703672911000E-07
98 24 -0.1185399025119000E-07  0.1088878920798000E-07
98 25 -0.1229901346347000E-07 -0.3131002747059000E-07
98 26  0.3927542137233000E-07  0.1842001541447000E-07
98 27  0.4751872226648000E-08  0.3717219136874000E-07
98 28  0.2871281632036000E-07  0.6050655012141001E-07
98 29 -0.2268940782988000E-07 -0.6745804468062001E-07
98 30  0.9649954951796000E-07  0.1971482166424000E-07
98 31 -0.5643786804164000E-07 -0.3016019862869000E-07
98 32 -0.1381853475978000E-07 -0.1475396579771000E-07
98 33 -0.2931805297527000E-08  0.9654540472783001E-07
98 34  0.1950256256654000E-07  0.9949084286348999E-08
98 35 -0.3005283385826000E-07  0.4384694559914000E-07
98 36  0.8765558458407999E-08 -0.3882143342895000E-07
98 37 -0.6503895097037001E-07  0.1496608196059000E-07
98 38 -0.1367383698031000E-07  0.3801078064413000E-07
98 39 -0.6871959118023000E-08  0.4540005101006000E-07
98 40  0.3937841331893000E-07 -0.3841676120093000E-07
98 41 -0.2629839755655000E-07  0.3523763211229000E-07
98 42  0.5788145843354000E-08 -0.4992235374694000E-07
98 43 -0.4077760383986000E-07  0.1423414429205000E-07
98 44 -0.9998617049591001E-08  0.4717284058319000E-08
98 45 -0.3920609956236000E-07 -0.8123106609519000E-08
98 46 -0.2442476886769000E-07  0.2711174689987000E-07
98 47 -0.1042154269227000E-07  0.1370741718204000E-07
98 48  0.1218814791724000E-07  0.1237279048699000E-07
98 49  0.9498161352682999E-08  0.2233820853313000E-07
98 50  0.3447804807326000E-07  0.9734394893639001E-08
98 51 -0.7451713091278999E-07 -0.3726284253557000E-07
98 52 -0.1221046938852000E-07  0.7475628201287000E-08
98 53  0.2394840388316000E-07  0.1622921201977000E-08
98 54 -0.3870666733260000E-07  0.2923832475229000E-07
98 55  0.2275365896425000E-07  0.2368539239374000E-07
98 56 -0.5966782470624000E-07  0.8515971943245000E-08
98 57  0.2982948750065000E-07 -0.6532419330912000E-08
98 58  0.2327082702454000E-07  0.1845310197848000E-07
98 59  0.3326693662256000E-07  0.1903801786352000E-07
98 60  0.1007301444242000E-07  0.1322095117167000E-07
98 61 -0.2400499184065000E-07 -0.2855342894445000E-07
98 62 -0.5786186515684000E-07 -0.5514760508602000E-07
98 63 -0.2941327319319000E-08 -0.1486595912395000E-07
98 64  0.4160450184120000E-07  0.2976945709698000E-07
98 65  0.3285757217352000E-07 -0.1825155109739000E-07
98 66 -0.4779676178801000E-07  0.3371109338939000E-07
98 67 -0.1230342403583000E-07  0.4396439586209000E-07
98 68  0.5999727136052000E-08 -0.1857308317594000E-07
98 69 -0.1614492681237000E-07 -0.5893556483740000E-07
98 70 -0.4025738240519000E-07 -0.1116930495822000E-07
98 71 -0.1393341679652000E-07  0.3083808968313000E-07
98 72  0.3974222802409000E-08  0.4167821931493000E-07
98 73  0.9847984861091001E-08 -0.9960725839414001E-08
98 74 -0.5794224347834000E-07 -0.9764010666120000E-08
98 75  0.9605977675318000E-07 -0.1830985476560000E-07
98 76 -0.4584343805679000E-07  0.2756575567625000E-07
98 77  0.3823997028283000E-07  0.8411115716680000E-07
98 78 -0.9396408136350999E-08 -0.1656522344069000E-07
98 79  0.4185952625929000E-07  0.2233001399791000E-07
98 80 -0.1744700457412000E-07 -0.5834905351464000E-07
98 81  0.3622672588171000E-07  0.3380968917322000E-08
98 82  0.3269551042405000E-07  0.1755046716192000E-07
98 83  0.5733319402696000E-07  0.3577915443541000E-07
98 84 -0.1386832270472000E-07  0.1017270747681000E-08
98 85 -0.6761492954920000E-07 -0.1213152819257000E-07
98 86  0.2090747885445000E-07 -0.4404737582345000E-07
98 87  0.1452548408199000E-07  0.9388050755245999E-08
98 88 -0.4946607946557000E-07  0.1657878180310000E-07
98 89 -0.2979387188278000E-08 -0.6755534304116000E-07
98 90  0.2704789740114000E-07  0.3135005532287000E-07
98 91 -0.2830234097336000E-07 -0.2584216699603000E-07
98 92  0.1837344153331000E-07 -0.4083625547771000E-07
98 93 -0.5628363514654000E-08 -0.4430648556976000E-07
98 94  0.1883385202448000E-07  0.1850029263577000E-07
98 95  0.7561587147011000E-07  0.2299549686781000E-07
98 96  0.3176970113807000E-07 -0.3726027060676000E-08
98 97 -0.5241261290421000E-07 -0.5182926833399000E-09
98 98 -0.1520081097106000E-07 -0.2198239972787000E-07
99  0  0.5450265744685000E-07  0.0000000000000000E+00
99 1 -0.1336173282183000E-07  0.3174648621017000E-07
99 2 -0.6135022688157000E-07  0.3213055513387000E-07
99 3 -0.7855883908294000E-07 -0.6552522731691000E-08
99 4  0.2370341554399000E-07 -0.2182740183318000E-07
99 5 -0.2540162565857000E-07  0.3276117371038000E-07
99 6 -0.8702230988272999E-08  0.2206040925606000E-08
99 7  0.8197423879761000E-07 -0.3483452548938000E-07
99 8  0.1029900089944000E-07  0.4319571179970000E-08
99 9  0.5664595131277000E-07  0.1112669029709000E-08
99 10 -0.3531418043210000E-07 -0.6939878913186000E-07
99 11  0.2915258087991000E-07  0.6990722584312000E-07
99 12  0.1499562324430000E-07  0.2228850159332000E-07
99 13  0.5737460084535000E-07 -0.6790731528675000E-07
99 14  0.5780470069309000E-08  0.2494649960857000E-07
99 15 -0.2004786625756000E-07 -0.4801308720540000E-07
99 16 -0.6005246627153000E-07 -0.3975401485651000E-07
99 17 -0.1984482943208000E-07  0.9210806347911000E-07
99 18  0.3499183879914000E-07  0.1784076418036000E-07
99 19  0.2322195420345000E-07  0.8979179663509000E-08
99 20  0.1004837205715000E-06  0.2986818375681000E-07
99 21  0.2290386661489000E-07 -0.2369989704844000E-07
99 22 -0.4265731998195000E-07  0.4770465102767000E-07
99 23  0.1053565320768000E-09 -0.4427000590195000E-07
99 24 -0.3494387797636000E-07 -0.1958116276354000E-07
99 25  0.4855006506458000E-07  0.3200749845781000E-07
99 26 -0.6557555604325000E-07  0.1378595363177000E-07
99 27 -0.8264921041521000E-08 -0.1447053222295000E-07
99 28  0.2431721857135000E-07 -0.2977168870718000E-07
99 29  0.7307997433930000E-07 -0.3650210069339000E-08
99 30 -0.2640201873843000E-07  0.2335767266698000E-07
99 31  0.1249684848282000E-07 -0.7750272101387001E-08
99 32  0.3991819289725000E-07  0.2908140372579000E-07
99 33 -0.3138222055186000E-07 -0.3443595602253000E-07
99 34 -0.4767864766999000E-07 -0.1993084899834000E-07
99 35  0.7608013258344001E-07 -0.4978698835887000E-07
99 36  0.2564582237121000E-08  0.4759466207047000E-07
99 37  0.1662720148838000E-07  0.2189161923592000E-07
99 38  0.6404827010856000E-07 -0.4545179314865000E-07
99 39 -0.1723674686823000E-07 -0.4976602914446000E-07
99 40 -0.2761196153300000E-07  0.3332429986820000E-07
99 41  0.3034356115427000E-07  0.2221132806164000E-07
99 42 -0.1626857419945000E-07 -0.8784776616500000E-08
99 43 -0.4012963632078000E-07 -0.2176927124042000E-07
99 44 -0.7688073791026000E-08  0.2357814832518000E-09
99 45  0.1433644685119000E-07 -0.1204239910756000E-07
99 46  0.1080598081144000E-08  0.8942791809044000E-08
99 47  0.2272961079401000E-07  0.1279048803401000E-07
99 48  0.1148947241580000E-07 -0.1167209225881000E-08
99 49 -0.3589014494174000E-09 -0.2085422623700000E-07
99 50 -0.6183073072654000E-07  0.4896983819887000E-09
99 51  0.4071293581825000E-07 -0.4050313912258000E-07
99 52 -0.4089970662312000E-07  0.5216122892885000E-07
99 53 -0.6113644308629000E-07  0.1433601400526000E-07
99 54 -0.2918380411731000E-07  0.1760777090157000E-07
99 55  0.1821902318813000E-08  0.1220588473023000E-08
99 56  0.1699884597962000E-07 -0.3781028446752000E-07
99 57 -0.2059274730752000E-07 -0.1851934249703000E-07
99 58 -0.9120770349974000E-08  0.9249285534722000E-08
99 59  0.2859945843258000E-07  0.5947813354838000E-08
99 60 -0.2349647859618000E-07  0.2316159914816000E-08
99 61  0.1540088402559000E-07 -0.2570167247776000E-07
99 62  0.3598931016574000E-07  0.2228619209066000E-07
99 63 -0.8051216333602000E-08 -0.1098332966848000E-07
99 64  0.1370094337259000E-07  0.6254757792714999E-07
99 65 -0.3371289057715000E-07 -0.4001885323999000E-07
99 66  0.1890553217944000E-07 -0.6298178933426000E-07
99 67  0.1896066189987000E-07 -0.2393123416187000E-07
99 68  0.3077332070602000E-07 -0.1421909062753000E-07
99 69 -0.4459975690210000E-07  0.2337420177394000E-07
99 70 -0.1395319221124000E-07 -0.4061607281070000E-07
99 71  0.2135919158025000E-07  0.2082403110081000E-07
99 72  0.4615628157017000E-08 -0.3352623297999000E-07
99 73  0.1733510436121000E-07  0.4810287135682000E-08
99 74  0.5368399644210000E-08  0.1732144276651000E-07
99 75 -0.2843811170609000E-07  0.1433686374990000E-08
99 76 -0.2095449047719000E-07  0.2825673436112000E-07
99 77 -0.1765711047560000E-07 -0.6475343056377000E-08
99 78  0.2010759270459000E-07 -0.1375823087304000E-07
99 79  0.1094815762206000E-07  0.3246814524860000E-07
99 80  0.2138607852644000E-07  0.6628746037470000E-08
99 81 -0.2517173967297000E-07  0.4932059483597000E-07
99 82 -0.3024814949070000E-07  0.2237867261827000E-07
99 83 -0.5372306303447000E-07 -0.2058165194549000E-07
99 84 -0.7354467819629000E-07 -0.4475907659272000E-07
99 85  0.6344668477780000E-09 -0.5033992219439000E-07
99 86 -0.2863537695461000E-08 -0.3567235343869000E-07
99 87 -0.2124924295629000E-08  0.2682884581468000E-07
99 88  0.1918451831962000E-07  0.1706559911578000E-07
99 89  0.3804197628328000E-07  0.1213960019962000E-07
99 90 -0.3516884360122000E-07 -0.1200541631859000E-07
99 91 -0.1845035010808000E-07 -0.4435740018251000E-07
99 92 -0.1638321999504000E-07 -0.1615699311349000E-08
99 93  0.7424715308567000E-08  0.7868205900690999E-08
99 94  0.9118061414265000E-08  0.1083096638122000E-07
99 95 -0.2042505002694000E-07  0.3531238579010000E-07
99 96 -0.3890747927305000E-07  0.1360739556260000E-07
99 97 -0.8908469134277000E-08  0.1200873433759000E-07
99 98  0.4016777442981000E-07 -0.7685280625668001E-08
99 99 -0.3895221470379000E-07  0.5081668110764000E-07
100  0 -0.1107987044437000E-06  0.0000000000000000E+00
100 1 -0.2649412044405000E-07 -0.3035664481481000E-08
100 2 -0.2523751429421000E-07 -0.9947930488661999E-08
100 3 -0.2866491124127000E-07 -0.2478051997210000E-07
100 4  0.8675137881798000E-07  0.2470182588371000E-07
100 5 -0.3291571106377000E-07  0.1417053435587000E-07
100 6  0.3959005685673000E-07  0.2088095853650000E-07
100 7 -0.2139570816301000E-07  0.2817946187066000E-07
100 8  0.7254873352858000E-08  0.6892149255814000E-07
100 9 -0.2431371229627000E-07 -0.5345735419087000E-07
100 10 -0.2155502052364000E-08  0.3592326829015000E-07
100 11  0.1726299768929000E-07  0.3014219131413000E-09
100 12 -0.4706008999030000E-07 -0.1997925140770000E-08
100 13 -0.8022339432254000E-07  0.4081160579288000E-07
100 14 -0.3155217930031000E-08 -0.5353742724784000E-08
100 15  0.2290950694799000E-07  0.2156046595932000E-07
100 16 -0.2665186129584000E-07  0.9276955798057000E-07
100 17 -0.1474771000454000E-07 -0.2183841641765000E-07
100 18 -0.1011420509094000E-06 -0.2971006626382000E-08
100 19 -0.1522914036728000E-07  0.7121418716749000E-07
100 20 -0.5696124957999000E-08 -0.2441424104966000E-07
100 21 -0.5783474543856000E-07  0.3199842005041000E-07
100 22  0.2568484128907000E-07 -0.3020319609608000E-07
100 23 -0.6794928525388000E-08  0.1713549352757000E-07
100 24 -0.3254424999564000E-07  0.3616403463409000E-07
100 25  0.2950308530518000E-07 -0.1881555547143000E-08
100 26 -0.1293347318810000E-09  0.2773724835749000E-07
100 27  0.4940487416084000E-07  0.3312498002827000E-07
100 28  0.2099103624314000E-07  0.2842942311342000E-07
100 29 -0.1958223653230000E-07 -0.5119051855160000E-07
100 30  0.7553255800205001E-08  0.3648600498544000E-07
100 31 -0.5956177698313000E-07 -0.3222697408470000E-07
100 32  0.5393170024711000E-07  0.1229190602843000E-07
100 33  0.5062768017712000E-07 -0.8591256994385999E-08
100 34  0.5251389290682000E-07  0.2599139922580000E-07
100 35 -0.2027512242736000E-08 -0.5618661781824000E-08
100 36 -0.2733300311436000E-07 -0.2822443373252000E-07
100 37 -0.5669814478156000E-07 -0.5858708492774000E-07
100 38  0.6980772213973000E-08  0.8240131051711000E-07
100 39 -0.3488669572989000E-08  0.3159091540129000E-07
100 40 -0.5329795273137000E-07 -0.2712617798401000E-07
100 41 -0.1201836694459000E-07 -0.3185407023462000E-07
100 42  0.3096570747265000E-07  0.1283525683250000E-07
100 43 -0.4214063425094000E-07  0.1347916905200000E-07
100 44  0.4169436668140000E-07 -0.4320887566051000E-07
100 45 -0.2011343889258000E-07  0.9522658380451000E-08
100 46  0.1969702343303000E-07 -0.1543434877234000E-07
100 47  0.4522061145374000E-08 -0.1466260260770000E-07
100 48  0.5089915925491000E-07 -0.4954476628936000E-07
100 49 -0.6696666522787000E-07 -0.2481545621805000E-07
100 50  0.1340247635468000E-07  0.1702440383491000E-07
100 51  0.3085053511332000E-07  0.1291429930624000E-08
100 52  0.8673396751466000E-08  0.1805134345870000E-07
100 53  0.9707448301546999E-08 -0.9553229738534000E-07
100 54  0.5956265247123000E-07  0.5285833352755000E-08
100 55  0.1756346278611000E-07  0.2475006902517000E-07
100 56  0.1545090528607000E-08 -0.3725185416690000E-07
100 57  0.1560832929398000E-07  0.1476153380265000E-07
100 58 -0.7587158020089000E-08  0.1348594998512000E-07
100 59 -0.2726542018384000E-08 -0.3943853647824000E-07
100 60 -0.4058513324113000E-07  0.1427939343415000E-07
100 61  0.1668763909716000E-08  0.2860408676781000E-07
100 62  0.2507263311493000E-07  0.6352549886903000E-08
100 63 -0.4349408145262000E-07  0.4783786690137000E-07
100 64 -0.2746121171718000E-07 -0.1616391347855000E-07
100 65 -0.9121779196612000E-08 -0.1088550377783000E-07
100 66 -0.1500439950567000E-07 -0.9772571459514001E-08
100 67  0.2992575645417000E-07  0.3389995081877000E-07
100 68 -0.2470684353107000E-07 -0.4480298615541000E-07
100 69 -0.3869278028730000E-07 -0.1331389113699000E-07
100 70 -0.6010394274626000E-08 -0.1282464815162000E-07
100 71  0.4762266651085000E-08  0.6346924354797000E-08
100 72 -0.2125177776897000E-07  0.1310846052841000E-07
100 73 -0.4728759230224000E-07  0.1739769787305000E-07
100 74 -0.7447152430428000E-07 -0.1520522938330000E-07
100 75  0.2286140299489000E-07  0.1197397236291000E-07
100 76 -0.1641168640292000E-07 -0.6010093109839000E-08
100 77  0.5665309753121000E-07 -0.3404197804954000E-07
100 78  0.9769211565824000E-08 -0.2435621770377000E-07
100 79 -0.5756997950311000E-07 -0.2928572553277000E-07
100 80  0.4422166708145000E-07 -0.2229915365064000E-07
100 81  0.3028320103446000E-07  0.2236846424843000E-08
100 82 -0.3670002736236000E-08 -0.6546563859330999E-07
100 83 -0.1459797120981000E-07 -0.2392038033989000E-09
100 84  0.1822370370504000E-07 -0.2518698442408000E-07
100 85  0.3943961903071000E-07  0.3047914298917000E-07
100 86  0.7833907601639999E-08  0.3264841840754000E-07
100 87  0.3171530558674000E-07  0.3485411564806000E-07
100 88 -0.5877920130953000E-08  0.2484705240440000E-07
100 89 -0.5337199036534000E-08 -0.5084837871696000E-07
100 90  0.8057738814402000E-08  0.2853810673452000E-08
100 91  0.1908539014478000E-07  0.3325325439717000E-07
100 92  0.2962533320443000E-07  0.7650987464182000E-08
100 93 -0.3036406436376000E-07  0.1499841762965000E-07
100 94  0.7220473583182000E-08  0.3694534926567000E-07
100 95 -0.2055537856217000E-07 -0.1852815590051000E-07
100 96  0.5304356773843000E-07 -0.7304908564746001E-07
100 97  0.1277500680058000E-07  0.6539257512953000E-07
100 98 -0.1901644429658000E-07 -0.1334983317715000E-07
100 99 -0.1130489529337000E-08 -0.6885933791473000E-08
100 100 -0.6112343472532000E-08 -0.1816329276789000E-08
]